/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.renjin.gcc.annotations.Struct;
import org.renjin.gcc.format.ByteCharIterator;
import org.renjin.gcc.format.FileHandleCharIterator;
import org.renjin.gcc.format.FormatArrayInput;
import org.renjin.gcc.format.FormatInput;
import org.renjin.gcc.format.Formatter;
import org.renjin.gcc.format.VarArgsInput;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.FileHandle;
import org.renjin.gcc.runtime.FileHandleImpl;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.LongJumpException;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.MixedPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.RecordUnitPtr;
import org.renjin.gcc.runtime.StdInHandle;
import org.renjin.gcc.runtime.StdOutHandle;
import org.renjin.gcc.runtime.timespec;
import org.renjin.gcc.runtime.tm;

public class Stdlib {
    public static final int CLOCKS_PER_SEC = 4;
    private static long PROGRAM_START = System.currentTimeMillis();
    public static BytePtr tzname;
    public static int timezone;
    public static int daylight;
    public static final Ptr stdout;
    public static final Ptr stderr;
    public static final Ptr stdin;
    private static final DateFormat CTIME_FORMAT;
    private static final int CLOCK_REALTIME = 0;
    private static final int CLOCK_MONOTONIC = 1;
    private static final int CLOCK_MONOTONIC_RAW = 4;
    private static final int CLOCK_REALTIME_COARSE = 5;
    private static final ThreadLocal<Random> RANDOM;
    public static final int RAND_MAX = Integer.MAX_VALUE;

    @Deprecated
    public static int strncmp(BytePtr x, BytePtr y, int n) {
        return Stdlib.strncmp((Ptr)x, (Ptr)y, n);
    }

    public static int strncmp(Ptr x, Ptr y, int n) {
        for (int i = 0; i < n; ++i) {
            byte by;
            byte bx = x.getByte(i);
            if (bx < (by = y.getByte(i))) {
                return -1;
            }
            if (bx > by) {
                return 1;
            }
            if (bx == 0) break;
        }
        return 0;
    }

    @Deprecated
    public static int strcmp(BytePtr x, BytePtr y) {
        return Stdlib.strncmp((Ptr)x, (Ptr)y, Integer.MAX_VALUE);
    }

    public static int strcmp(Ptr x, Ptr y) {
        return Stdlib.strncmp(x, y, Integer.MAX_VALUE);
    }

    public static int strcoll(Ptr x, Ptr y) {
        throw new UnsupportedOperationException("TODO: strcoll");
    }

    public static int strcasecmp(Ptr x, Ptr y) {
        return Stdlib.strncasecmp(x, y, Integer.MAX_VALUE);
    }

    public static int strncasecmp(Ptr x, Ptr y, int len) {
        for (int i = 0; i < len; ++i) {
            int by;
            int bx = Character.toLowerCase(x.getByte(i));
            if (bx < (by = Character.toLowerCase(y.getByte(i)))) {
                return -1;
            }
            if (bx > by) {
                return 1;
            }
            if (bx == 0) break;
        }
        return 0;
    }

    public static Ptr strchr(Ptr string, int ch) {
        int pos = 0;
        while (true) {
            byte pc;
            if ((pc = string.getByte(pos)) == ch) {
                return string.pointerPlus(pos);
            }
            if (pc == 0) break;
            ++pos;
        }
        return BytePtr.NULL;
    }

    public static Ptr strrchr(Ptr string, int ch) {
        int len = 0;
        while (string.getByte(len) != 0) {
            ++len;
        }
        for (int pos = len - 1; pos > 0; --pos) {
            byte pc = string.getByte(pos);
            if (pc != ch) continue;
            return string.pointerPlus(pos);
        }
        return BytePtr.NULL;
    }

    public static Ptr strstr(Ptr string, Ptr searched) {
        int offset = Stdlib.nullTerminatedString(string).indexOf(Stdlib.nullTerminatedString(searched));
        return new OffsetPtr(string, offset);
    }

    public static int strcspn(Ptr str1, Ptr str2) {
        int i = 0;
        while (true) {
            byte d;
            byte c = str1.getByte(i);
            int j = 0;
            do {
                if (c == (d = str2.getByte(j))) {
                    return i;
                }
                ++j;
            } while (d != 0);
            ++i;
        }
    }

    @Deprecated
    public static long strtol(Ptr string) {
        return Stdlib.strtol(string, BytePtr.NULL, 10);
    }

    public static long strtol(Ptr str, Ptr endptr, int radix) {
        return Stdlib.strtol(str, endptr, radix, true);
    }

    public static long strtoul(Ptr str, Ptr endptr, int radix) {
        return Stdlib.strtol(str, endptr, radix, false);
    }

    public static double strtold(Ptr string) {
        return Stdlib.strtod(string);
    }

    public static double strtod(Ptr string) {
        return Double.parseDouble(Stdlib.nullTerminatedString(string));
    }

    static long strtol(Ptr str, Ptr endptr, int radix, boolean signed) {
        int start;
        String s = Stdlib.nullTerminatedString(str);
        for (start = 0; start < s.length() && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        int pos = start;
        if (pos < s.length() && (s.charAt(pos) == '-' || s.charAt(pos) == '+')) {
            ++pos;
        } else if (!(radix != 0 && radix != 16 || pos + 1 >= s.length() || s.charAt(pos) != '0' || s.charAt(pos + 1) != 'x' && s.charAt(pos + 1) != 'X')) {
            pos = start += 2;
            radix = 16;
        } else if (radix == 0 && pos < s.length() && s.charAt(pos) == '0') {
            radix = 8;
        }
        if (radix == 0) {
            radix = 10;
        }
        while (pos < s.length() && Character.digit(s.charAt(pos), radix) != -1) {
            ++pos;
        }
        if (!endptr.isNull()) {
            endptr.setPointer(str.pointerPlus(pos));
        }
        if (start == pos) {
            return 0L;
        }
        s = s.substring(start, pos);
        if (signed) {
            try {
                return Long.parseLong(s, radix);
            }
            catch (NumberFormatException e) {
                return Long.MAX_VALUE;
            }
        }
        try {
            return Long.parseUnsignedLong(s, radix);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static Ptr strdup(Ptr s) {
        int strlen = Stdlib.strlen(s);
        BytePtr dup = BytePtr.malloc(strlen + 1);
        Stdlib.strcpy((Ptr)dup, s);
        return dup;
    }

    @Deprecated
    public static BytePtr strcpy(BytePtr destination, BytePtr source) {
        return (BytePtr)Stdlib.strcpy((Ptr)destination, (Ptr)source);
    }

    public static Ptr strcpy(Ptr destination, Ptr source) {
        int length = Stdlib.strlen(source);
        for (int i = 0; i < length + 1; ++i) {
            destination.setByte(i, source.getByte(i));
        }
        return destination;
    }

    @Deprecated
    public static BytePtr strncpy(BytePtr destination, BytePtr source, int num) {
        return (BytePtr)Stdlib.strncpy((Ptr)destination, (Ptr)source, num);
    }

    public static Ptr strncpy(Ptr destination, Ptr source, int num) {
        for (int i = 0; i < num; ++i) {
            byte srcChar = source.getByte(i);
            destination.setByte(i, srcChar);
            if (srcChar == 0) break;
        }
        return destination;
    }

    @Deprecated
    public static int atoi(BytePtr str) {
        return Stdlib.atoi((Ptr)str);
    }

    public static int atoi(Ptr str) {
        try {
            return Integer.parseInt(Stdlib.nullTerminatedString(str));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static double asinh(double x) {
        if (Double.isInfinite(x)) {
            return x;
        }
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static String nullTerminatedString(Ptr x) {
        byte b;
        StringBuilder str = new StringBuilder();
        int i = 0;
        while ((b = x.getByte(i)) != 0) {
            str.append((char)b);
            ++i;
        }
        return str.toString();
    }

    @Deprecated
    public static int strlen(BytePtr x) {
        return Stdlib.strlen((Ptr)x);
    }

    public static int strlen(Ptr x) {
        int len = 0;
        while (x.getByte(len) != 0) {
            ++len;
        }
        return len;
    }

    @Deprecated
    public static BytePtr strcat(BytePtr dest, BytePtr src) {
        return (BytePtr)Stdlib.strcat((Ptr)dest, (Ptr)src);
    }

    public static Ptr strcat(Ptr dest, Ptr src) {
        byte srcByte;
        int destPos = 0;
        while (dest.getByte(destPos) != 0) {
            ++destPos;
        }
        int srcPos = 0;
        do {
            srcByte = src.getByte(srcPos++);
            dest.setByte(destPos++, srcByte);
        } while (srcByte != 0);
        return dest;
    }

    public static int printf(BytePtr format, Object ... arguments) {
        String outputString;
        try {
            outputString = Stdlib.format((Ptr)format, (Formatter f) -> new FormatArrayInput(arguments));
        }
        catch (Exception e) {
            return -1;
        }
        System.out.print(outputString);
        return outputString.length();
    }

    public static int puts(BytePtr string) {
        System.out.println(string.nullTerminatedString());
        return 0;
    }

    public static int putchar(int character) {
        System.out.println((char)character);
        return character;
    }

    public static int sprintf(Ptr string, Ptr format, Object ... arguments) {
        return Stdlib.snprintf(string, Integer.MAX_VALUE, format, arguments);
    }

    @Deprecated
    public static int sprintf(BytePtr string, BytePtr format, Object ... arguments) {
        return Stdlib.snprintf(string, Integer.MAX_VALUE, format, arguments);
    }

    @Deprecated
    public static int snprintf(BytePtr string, int limit, BytePtr format, Object ... arguments) {
        return Stdlib.sprintf((Ptr)string, limit, format, (Formatter f) -> new FormatArrayInput(arguments));
    }

    public static int snprintf(Ptr string, int limit, Ptr format, Object ... arguments) {
        return Stdlib.sprintf(string, limit, format, (Formatter f) -> new FormatArrayInput(arguments));
    }

    @Deprecated
    public static int vsnprintf(BytePtr string, int n, BytePtr format, Ptr argumentList) {
        return Stdlib.sprintf((Ptr)string, n, format, (Formatter f) -> new VarArgsInput((Formatter)f, argumentList));
    }

    public static int vsnprintf(Ptr string, int n, Ptr format, Ptr argumentList) {
        return Stdlib.sprintf(string, n, format, (Formatter f) -> new VarArgsInput((Formatter)f, argumentList));
    }

    private static int sprintf(Ptr string, int limit, Ptr format, Function<Formatter, FormatInput> arguments) {
        String outputString;
        try {
            outputString = Stdlib.format(format, arguments);
        }
        catch (Exception e) {
            return -1;
        }
        byte[] outputBytes = outputString.getBytes();
        int bytesToCopy = Math.min(outputBytes.length, limit - 1);
        if (string instanceof BytePtr) {
            Stdlib.copyToString((BytePtr)string, outputBytes, bytesToCopy);
        } else {
            Stdlib.copyToString(string, outputBytes, bytesToCopy);
        }
        if (limit > 0) {
            string.setByte(bytesToCopy, (byte)0);
        }
        return outputBytes.length;
    }

    private static void copyToString(Ptr string, byte[] outputBytes, int n) {
        for (int i = 0; i < n; ++i) {
            string.setByte(i, outputBytes[i]);
        }
    }

    private static void copyToString(BytePtr string, byte[] outputBytes, int n) {
        if (n > 0) {
            System.arraycopy(outputBytes, 0, string.array, string.offset, n);
        }
    }

    public static int __isoc99_sscanf(Ptr str, Ptr format, Object ... arguments) {
        return Stdlib.sscanf(str, format, arguments);
    }

    public static int sscanf(Ptr str, Ptr format, Object ... arguments) {
        Formatter formatter = new Formatter(Stdlib.nullTerminatedString(format), Formatter.Mode.SCAN);
        return formatter.scan(new ByteCharIterator(str), arguments);
    }

    public static int __isoc99_fscanf(Ptr fileHandle, Ptr format, Object ... args) {
        return Stdlib.fscanf(fileHandle, format, args);
    }

    public static int fscanf(Ptr fileHandle, Ptr format, Object ... args) {
        FileHandle h = (FileHandle)fileHandle.getArray();
        Formatter formatter = new Formatter(Stdlib.nullTerminatedString(format), Formatter.Mode.SCAN);
        try (FileHandleCharIterator it = new FileHandleCharIterator(h);){
            int n = formatter.scan(it, args);
            return n;
        }
    }

    public static int tolower(int c) {
        return Character.toLowerCase(c);
    }

    public static int toupper(int c) {
        return Character.toUpperCase(c);
    }

    public static String format(Ptr format, Object ... arguments) {
        return Stdlib.format(format, (Formatter f) -> new FormatArrayInput(arguments));
    }

    public static String format(Ptr format, Function<Formatter, FormatInput> input) {
        String formatString = Stdlib.nullTerminatedString(format);
        Formatter formatter = new Formatter(formatString);
        return formatter.format(input.apply(formatter));
    }

    public static void qsort(Ptr base, int nitems, int size, MethodHandle comparator) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void qsort(Object base, int nitems, int size, MethodHandle comparator) {
        throw new UnsupportedOperationException();
    }

    @Struct
    public static int[] div(int numer, int denom) {
        int quot = numer / denom;
        int rem = numer % denom;
        return new int[]{quot, rem};
    }

    public static double nearbyint(double arg) {
        return Math.round(arg);
    }

    @Deprecated
    public static int time(IntPtr seconds) {
        return Stdlib.time((Ptr)seconds);
    }

    public static int time(Ptr seconds) {
        int time = (int)(System.currentTimeMillis() / 1000L);
        if (!seconds.isNull()) {
            seconds.setInt(time);
        }
        return time;
    }

    public static BytePtr ctime(IntPtr timePtr) {
        Date date = new Date((long)timePtr.get() * 1000L);
        return BytePtr.nullTerminatedString(CTIME_FORMAT.format(date) + "\n", StandardCharsets.US_ASCII);
    }

    @Deprecated
    public static tm localtime(IntPtr time) {
        return new tm(time.unwrap());
    }

    public static Ptr localtime(Ptr time) {
        int instant = time.getInt();
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(instant);
        int[] tm2 = new int[]{instance.get(13), instance.get(12), instance.get(10), instance.get(5), instance.get(2), instance.get(1), instance.get(7), instance.get(6), instance.getTimeZone().inDaylightTime(new Date(instant)) ? 1 : 0};
        return new IntPtr(tm2);
    }

    public static void tzset() {
        TimeZone currentTimezone = TimeZone.getDefault();
        tzname = BytePtr.nullTerminatedString(currentTimezone.getDisplayName(), StandardCharsets.US_ASCII);
        timezone = currentTimezone.getOffset(System.currentTimeMillis());
        daylight = currentTimezone.inDaylightTime(new Date()) ? 1 : 0;
    }

    @Deprecated
    public static void fflush(Object file) {
    }

    public static int clock() {
        long millisSinceProgramStart = System.currentTimeMillis() - PROGRAM_START;
        int secondsSinceProgramStart = (int)TimeUnit.MILLISECONDS.toSeconds(millisSinceProgramStart);
        return secondsSinceProgramStart * 4;
    }

    @Deprecated
    public static int clock_gettime(int clockId, timespec tp) {
        switch (clockId) {
            case 0: 
            case 5: {
                tp.set(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                return 0;
            }
            case 1: 
            case 4: {
                tp.set(System.nanoTime(), TimeUnit.NANOSECONDS);
                return 0;
            }
        }
        return -1;
    }

    public static int clock_gettime(int clockId, Ptr tp) {
        TimeUnit timeUnit;
        long duration;
        switch (clockId) {
            case 0: 
            case 5: {
                duration = System.currentTimeMillis();
                timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case 1: 
            case 4: {
                duration = System.nanoTime();
                timeUnit = TimeUnit.NANOSECONDS;
                break;
            }
            default: {
                return -1;
            }
        }
        int seconds = (int)timeUnit.toSeconds(duration);
        int nanoseconds = (int)(timeUnit.toNanos(duration) - TimeUnit.SECONDS.toNanos(seconds));
        tp.setAlignedInt(0, seconds);
        tp.setAlignedInt(1, nanoseconds);
        return 0;
    }

    @Deprecated
    public static Object fopen() {
        throw new UnsupportedOperationException("Please recompile with the latest version of Renjin.");
    }

    public static Ptr fopen(Ptr filename, Ptr mode) {
        String filenameString = Stdlib.nullTerminatedString(filename);
        String modeString = Stdlib.nullTerminatedString(mode);
        try {
            return new RecordUnitPtr<FileHandleImpl>(Stdlib.openFile(filenameString, modeString));
        }
        catch (IOException e) {
            return BytePtr.NULL;
        }
    }

    public static FileHandleImpl openFile(String filenameString, String modeString) throws IOException {
        switch (modeString) {
            case "r": 
            case "rb": {
                return new FileHandleImpl(new RandomAccessFile(filenameString, "r"));
            }
            case "w": 
            case "wb": {
                return new FileHandleImpl(new RandomAccessFile(filenameString, "rw"));
            }
            case "w+b": {
                RandomAccessFile raf = new RandomAccessFile(filenameString, "rw");
                raf.seek(raf.length());
                return new FileHandleImpl(raf);
            }
        }
        throw new UnsupportedOperationException("Not implemented. Mode = " + modeString);
    }

    public static int fflush(Ptr stream) throws IOException {
        FileHandle handle = (FileHandle)stream.getArray();
        handle.flush();
        return 0;
    }

    public static int fprintf(Ptr stream, BytePtr format, Object ... arguments) {
        try {
            String outputString = Stdlib.format((Ptr)format, (Formatter f) -> new FormatArrayInput(arguments));
            byte[] outputBytes = outputString.getBytes(StandardCharsets.UTF_8);
            BytePtr outputPtr = new BytePtr(outputBytes);
            int bytesWritten = Stdlib.fwrite((Ptr)outputPtr, 1, outputBytes.length, stream);
            return bytesWritten;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Deprecated
    public static int fwrite(BytePtr ptr, int size, int count, Ptr stream) throws IOException {
        return Stdlib.fwrite((Ptr)ptr, size, count, stream);
    }

    public static int fwrite(Ptr ptr, int size, int count, Ptr stream) throws IOException {
        FileHandle handle = (FileHandle)stream.getArray();
        int bytesWritten = 0;
        for (int i = 0; i < count * size; ++i) {
            try {
                handle.write(ptr.getByte(i));
                ++bytesWritten;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                i = count * size;
            }
        }
        return bytesWritten;
    }

    public static int ferror(Ptr stream) {
        FileHandle handle = (FileHandle)stream.getArray();
        return handle.getError();
    }

    public static void clearerr(Ptr stream) {
        FileHandle handle = (FileHandle)stream.getArray();
        handle.clearError();
    }

    public static int fread(Ptr ptr, int size, int count, Ptr stream) throws IOException {
        int b;
        FileHandle handle = (FileHandle)stream.getArray();
        int bytesRead = 0;
        for (int i = 0; i < count * size && (b = handle.read()) != -1; ++i) {
            ptr.setByte(i, (byte)b);
            ++bytesRead;
        }
        return bytesRead / size;
    }

    public static void rewind(Ptr stream) throws IOException {
        FileHandle handle = (FileHandle)stream.getArray();
        handle.rewind();
    }

    public static int fseek(Ptr stream, long offset, int whence) {
        FileHandle fileHandle = (FileHandle)stream.getArray();
        try {
            switch (whence) {
                case 0: {
                    fileHandle.seekSet(offset);
                    break;
                }
                case 1: {
                    fileHandle.seekCurrent(offset);
                    break;
                }
                case 2: {
                    fileHandle.seekEnd(offset);
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int fclose(Ptr stream) {
        try {
            ((FileHandle)stream.getArray()).close();
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int fgetc(Ptr stream) {
        try {
            return ((FileHandle)stream.getArray()).read();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private static FileHandle fileHandle(Ptr ptr) {
        return (FileHandle)ptr.getArray();
    }

    public static int feof(Ptr handlePtr) {
        return Stdlib.fileHandle(handlePtr).isEof() ? 1 : 0;
    }

    public static long ftell(Ptr stream) {
        FileHandle handle = (FileHandle)stream.getArray();
        try {
            return handle.position();
        }
        catch (IOException e) {
            handle.setError(e);
            return -1L;
        }
    }

    public static int fputs(Ptr str, Ptr stream) {
        throw new UnsupportedOperationException("fputs");
    }

    public static Ptr fgets(Ptr str, int num, Ptr stream) {
        int charsRead;
        FileHandle handle = Stdlib.fileHandle(stream);
        for (charsRead = 0; charsRead < num - 1; ++charsRead) {
            int c;
            try {
                c = handle.read();
            }
            catch (IOException e) {
                handle.setError(e);
                return BytePtr.NULL;
            }
            if (c == -1) {
                if (charsRead != 0) break;
                handle.setError(1);
                return BytePtr.NULL;
            }
            if (c == 0) break;
            str.setByte(charsRead, (byte)c);
            if (c != 10) continue;
            break;
        }
        str.setByte(charsRead, (byte)0);
        return str;
    }

    public static int fputc(int character, Ptr stream) {
        FileHandle handle = (FileHandle)stream.getArray();
        try {
            handle.write(character);
            return character;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static int __isinf(double x) {
        return Double.isInfinite(x) ? 1 : 0;
    }

    public static int isinf(double x) {
        return Stdlib.__isinf(x);
    }

    public static float logf(float x) {
        return (float)Math.log(x);
    }

    public static long lroundf(float x) {
        if (Float.isInfinite(x)) {
            if (x < 0.0f) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
        long sign = (long)Math.signum(x);
        long closest = Math.round((double)Math.abs(x));
        return closest * sign;
    }

    public static int __cxa_guard_acquire(LongPtr guard_object) {
        return 1;
    }

    public static void __cxa_guard_release(LongPtr guard_object) {
    }

    public static void __cxa_guard_abort(LongPtr p) {
    }

    public static void __cxa_free_exception(Ptr p) {
    }

    public static void __cxa_call_unexpected(Ptr p) {
    }

    public static int __cxa_atexit(MethodHandle fn, Ptr arg, Ptr dso_handle) {
        return 0;
    }

    public static int posix_memalign(Ptr memPtr, int aligment, int size) {
        memPtr.setPointer(MixedPtr.malloc(size));
        return 0;
    }

    public static void inlineAssembly() {
        throw new UnsupportedOperationException("Compilation of inline assembly not supported");
    }

    public static void srand(int seed) {
        RANDOM.get().setSeed(seed);
    }

    public static int rand() {
        return RANDOM.get().nextInt(Integer.MAX_VALUE);
    }

    public static int _setjmp(Ptr buf) {
        return 0;
    }

    public static void longjmp(Ptr buf, int value) {
        throw new LongJumpException(buf, value);
    }

    public static int __ctype_get_mb_cur_max() {
        return 1;
    }

    public static int mbrtowc(Ptr pwc, Ptr s, int n, Ptr ps) {
        throw new UnsupportedOperationException("TODO: mbrtowc");
    }

    public static int mbstowcs(Ptr dst, Ptr src, int len) {
        throw new UnsupportedOperationException("TODO: mbstowcs");
    }

    public static int wcrtomb(Ptr s, int wc, Ptr ps) {
        throw new UnsupportedOperationException("TODO: wcrtomb");
    }

    public static Ptr strerror(int errnum) {
        throw new UnsupportedOperationException("strerror");
    }

    public static Ptr dngettext(Ptr domainname, Ptr __msgid1, Ptr __msgid2, long n) {
        if (n > 1L) {
            return __msgid2;
        }
        return __msgid1;
    }

    static {
        stdout = new RecordUnitPtr<StdOutHandle>(new StdOutHandle(System.out));
        stderr = new RecordUnitPtr<StdOutHandle>(new StdOutHandle(System.err));
        stdin = new RecordUnitPtr<StdInHandle>(new StdInHandle());
        CTIME_FORMAT = new SimpleDateFormat("E MMM d HH:mm:ss yyyy");
        RANDOM = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                return new Random(1L);
            }
        };
    }
}

