/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import org.renjin.grDevices.AwtPanel;
import org.renjin.grDevices.GDContainer;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;

public class AwtContainer
implements GDContainer {
    private AwtPanel panel;
    private GDState state;
    private Dimension size;
    private int deviceNumber = -1;

    public AwtContainer(int w, int h) {
        this.size = new Dimension(w, h);
        this.state = new GDState();
        this.state.setFont(new Font(null, 0, 12));
        this.panel = new AwtPanel(this.size);
        this.panel.setBackground(Color.white);
        this.panel.setForceAntiAliasing(true);
    }

    @Override
    public GDState getGState() {
        return this.state;
    }

    @Override
    public Graphics getGraphics() {
        return this.panel.getGraphics();
    }

    @Override
    public void setDeviceNumber(int deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    @Override
    public int getDeviceNumber() {
        return this.deviceNumber;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void closeDisplay() {
    }

    @Override
    public void syncDisplay(boolean finish) {
        this.panel.setRepaintPaused(!finish);
    }

    @Override
    public synchronized void add(GDObject o) {
        this.panel.paint(o, this.state);
    }

    @Override
    public synchronized void reset() {
        this.panel.reset();
    }

    public AwtPanel getPanel() {
        return this.panel;
    }
}

