/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.grDevices.GDCircle;
import org.renjin.grDevices.GDClip;
import org.renjin.grDevices.GDColor;
import org.renjin.grDevices.GDContainer;
import org.renjin.grDevices.GDFill;
import org.renjin.grDevices.GDFont;
import org.renjin.grDevices.GDLine;
import org.renjin.grDevices.GDLinePar;
import org.renjin.grDevices.GDPath;
import org.renjin.grDevices.GDPolygon;
import org.renjin.grDevices.GDRaster;
import org.renjin.grDevices.GDRect;
import org.renjin.grDevices.GDText;

public abstract class GraphicsDevice {
    private boolean active = false;
    private boolean holding = false;
    int deviceNumber = -1;
    protected GDContainer container = null;

    public abstract void open(double var1, double var3);

    public void activate() {
        this.active = true;
    }

    public void circle(double x, double y, double r) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDCircle(x, y, r));
    }

    public void clip(double x0, double x1, double y0, double y1) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDClip(x0, y0, x1, y1));
    }

    public void close() {
        if (this.container != null) {
            this.container.closeDisplay();
        }
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void hold() {
    }

    public void flush(boolean flush) {
        boolean bl = this.holding = !flush;
        if (flush && this.container != null) {
            this.container.syncDisplay(false);
        }
    }

    public Ptr locator() {
        return DoublePtr.NULL;
    }

    public void line(double x1, double y1, double x2, double y2) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDLine(x1, y1, x2, y2));
    }

    public double[] metricInfo(int ch) {
        FontMetrics fm;
        Font f;
        Graphics g;
        double[] res = new double[3];
        double ascent = 0.0;
        double descent = 0.0;
        double width = 8.0;
        if (this.container != null && (g = this.container.getGraphics()) != null && (f = this.container.getGState().getFont()) != null && (fm = g.getFontMetrics(this.container.getGState().getFont())) != null) {
            ascent = fm.getAscent();
            descent = fm.getDescent();
            width = fm.charWidth(ch == 0 ? 77 : ch);
        }
        res[0] = ascent;
        res[1] = descent;
        res[2] = width;
        return res;
    }

    public void mode(int mode) {
        if (!this.holding && this.container != null) {
            this.container.syncDisplay(mode == 0);
        }
    }

    public void newPage() {
        if (this.container != null) {
            this.container.reset();
        }
    }

    public void newPage(int devNr) {
        this.deviceNumber = devNr;
        if (this.container != null) {
            this.container.reset();
            this.container.setDeviceNumber(devNr);
        }
    }

    public void path(int npoly, Ptr nper, Ptr x, Ptr y, boolean winding) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDPath(npoly, nper, x, y, winding));
    }

    public void polygon(int n, Ptr x, Ptr y) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDPolygon(n, x, y, false));
    }

    public void polyline(int n, Ptr x, Ptr y) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDPolygon(n, x, y, true));
    }

    public void rect(double x0, double y0, double x1, double y1) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDRect(x0, y0, x1, y1));
    }

    public void raster(Ptr image, int imageWidth, int imageHeight, double x, double y, double w, double h, double rot, boolean interpolate) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDRaster(image, imageWidth, imageHeight, x, y, w, h, rot, interpolate));
    }

    public double[] size() {
        double[] res = new double[4];
        double width = 0.0;
        double height = 0.0;
        if (this.container != null) {
            Dimension d = this.container.getSize();
            width = d.getWidth();
            height = d.getHeight();
        }
        res[0] = 0.0;
        res[1] = width;
        res[2] = height;
        res[3] = 0.0;
        return res;
    }

    public double strWidth(String str) {
        FontMetrics fm;
        Font f;
        Graphics g;
        double width = 8 * str.length();
        if (this.container != null && (g = this.container.getGraphics()) != null && (f = this.container.getGState().getFont()) != null && (fm = g.getFontMetrics(f)) != null) {
            width = fm.stringWidth(str);
        }
        return width;
    }

    public void text(double x, double y, String str, double rot, double hadj) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDText(x, y, rot, hadj, str));
    }

    public void setColor(int cc) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDColor(cc));
    }

    public void setFill(int cc) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDFill(cc));
    }

    public void setLine(double lwd, int lty) {
        if (this.container == null) {
            return;
        }
        this.container.add(new GDLinePar(lwd, lty));
    }

    public void setFont(double cex, double ps, double lineheight, int fontface, String fontfamily) {
        if (this.container == null) {
            return;
        }
        GDFont f = new GDFont(cex, ps, lineheight, fontface, fontfamily);
        this.container.add(f);
        this.container.getGState().setFont(f.getFont());
    }

    public int getDeviceNumber() {
        return this.container == null ? this.deviceNumber : this.container.getDeviceNumber();
    }
}

