/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class LocatorSync
implements MouseListener {
    private static final Point CANCELLED = new Point();
    private final BlockingQueue<Point> points = new ArrayBlockingQueue<Point>(10);
    private boolean waiting = false;

    public synchronized Optional<Point> waitForClick() {
        this.points.clear();
        this.waiting = true;
        try {
            Point point = this.points.take();
            if (point == CANCELLED) {
                Optional<Point> optional = Optional.empty();
                return optional;
            }
            Optional<Point> optional = Optional.of(point);
            return optional;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Optional<Point> optional = Optional.empty();
            return optional;
        }
        finally {
            this.waiting = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.waiting) {
            if (e.getButton() == 1) {
                this.points.offer(e.getPoint());
            } else {
                this.points.offer(CANCELLED);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

