/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;

class GDPath
implements GDObject {
    private GeneralPath path;

    public GDPath(int npoly, Ptr numberOfPointsPerPath, Ptr x, Ptr y, boolean winding) {
        this.path = new GeneralPath(winding ? 1 : 0, this.countPoints(npoly, numberOfPointsPerPath));
        int k = 0;
        int end = 0;
        for (int i = 0; i < npoly; ++i) {
            end += numberOfPointsPerPath.getAlignedInt(i);
            this.path.moveTo((float)x.getAlignedDouble(k), (float)y.getAlignedDouble(k));
            ++k;
            while (k < end) {
                this.path.lineTo((float)x.getAlignedDouble(k), (float)y.getAlignedDouble(k));
                ++k;
            }
            this.path.closePath();
        }
    }

    private int countPoints(int npoly, Ptr numberOfPointsPerPath) {
        int count = 0;
        for (int i = 0; i < npoly; ++i) {
            count += numberOfPointsPerPath.getAlignedInt(i);
        }
        return count;
    }

    @Override
    public void paint(Component c, GDState gs, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (gs.getFill() != null) {
            g2.setColor(gs.getFill());
            g2.fill(this.path);
            if (gs.getCol() != null) {
                g2.setColor(gs.getCol());
            }
        }
        if (gs.getCol() != null) {
            g2.draw(this.path);
        }
    }
}

