/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.vfs2.FileObject;
import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.grDevices.GDContainer;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;

public class ImageContainer
implements GDContainer {
    private final GDState state;
    private final Dimension size;
    private int deviceNumber;
    private final BufferedImage bufferedImage;
    private final Session session;
    private final String filenameFormat;
    private String formatName;
    private Graphics2D graphics;
    private boolean empty = true;
    private int pageNumber = 1;

    public ImageContainer(Session session, String filenameFormat, String formatName, Color backgroundColor, int width, int height) {
        this.session = session;
        this.filenameFormat = filenameFormat;
        this.formatName = formatName;
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.size = new Dimension(width, height);
        this.graphics = this.bufferedImage.createGraphics();
        this.graphics.setBackground(backgroundColor);
        this.graphics.clearRect(0, 0, (int)this.size.getWidth(), (int)this.size.getHeight());
        this.state = new GDState();
    }

    @Override
    public void add(GDObject o) {
        this.empty = false;
        o.paint(null, this.state, this.graphics);
    }

    @Override
    public void reset() {
        if (!this.empty) {
            this.flush();
        }
        this.graphics.setClip(null);
        this.graphics.clearRect(0, 0, (int)this.size.getWidth(), (int)this.size.getHeight());
    }

    @Override
    public GDState getGState() {
        return this.state;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public void syncDisplay(boolean finish) {
    }

    @Override
    public void setDeviceNumber(int dn) {
        this.deviceNumber = dn;
    }

    @Override
    public void closeDisplay() {
        this.flush();
    }

    private void flush() {
        try {
            String filename = String.format(this.filenameFormat, this.pageNumber++);
            FileObject fileObject = this.session.resolveFile(filename);
            try (OutputStream outputStream = fileObject.getContent().getOutputStream();){
                ImageIO.write((RenderedImage)this.bufferedImage, this.formatName, outputStream);
            }
        }
        catch (IOException e) {
            throw new EvalException("Failed to write image: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getDeviceNumber() {
        return this.deviceNumber;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }
}

