/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Component;
import java.awt.Graphics;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;

class GDPolygon
implements GDObject {
    private int n;
    private int[] xi;
    private int[] yi;
    private boolean isPolyline;

    public GDPolygon(int n, Ptr x, Ptr y, boolean isPolyline) {
        this.n = n;
        this.isPolyline = isPolyline;
        this.xi = new int[n];
        this.yi = new int[n];
        for (int i = 0; i < n; ++i) {
            this.xi[i] = (int)(x.getAlignedDouble(i) + 0.5);
            this.yi[i] = (int)(y.getAlignedDouble(i) + 0.5);
        }
    }

    @Override
    public void paint(Component c, GDState gs, Graphics g) {
        if (gs.getFill() != null && !this.isPolyline) {
            g.setColor(gs.getFill());
            g.fillPolygon(this.xi, this.yi, this.n);
            if (gs.getCol() != null) {
                g.setColor(gs.getCol());
            }
        }
        if (gs.getCol() != null) {
            if (this.isPolyline) {
                g.drawPolyline(this.xi, this.yi, this.n);
            } else {
                g.drawPolygon(this.xi, this.yi, this.n);
            }
        }
    }
}

