/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;

class GDRaster
implements GDObject {
    private boolean interpolate;
    private Image image;
    private AffineTransform atrans;

    public GDRaster(Ptr image, int imageWidth, int imageHeight, double x, double y, double w, double h, double rot, boolean interpolate) {
        this.interpolate = interpolate;
        this.atrans = new AffineTransform();
        y += h;
        h = -h;
        double sx = w / (double)imageWidth;
        double sy = h / (double)imageHeight;
        this.atrans.translate(x, y);
        this.atrans.rotate(-rot / 180.0 * Math.PI, 0.0, y);
        this.atrans.scale(sx, sy);
        DataBuffer dbuf = this.toDataBuffer(image, imageWidth * imageHeight * 4);
        int[] compOffsets = new int[]{0, 1, 2, 3};
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, imageWidth, imageHeight, 4, imageWidth * 4, compOffsets);
        WritableRaster raster = Raster.createWritableRaster(sm, dbuf, null);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        this.image = new BufferedImage(cm, raster, false, null);
    }

    private DataBuffer toDataBuffer(Ptr image, int size) {
        if (image instanceof BytePtr) {
            BytePtr bytePtr = (BytePtr)image;
            return new DataBufferByte(bytePtr.array, size, bytePtr.offset);
        }
        byte[] buffer = new byte[size];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = image.getByte(i);
        }
        return new DataBufferByte(buffer, size, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Component c, GDState gs, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Object oh = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolate ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.drawImage(this.image, this.atrans, null);
        }
        finally {
            if (oh != null) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oh);
            }
        }
    }
}

