/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;

class GDText
implements GDObject {
    private double x;
    private double y;
    private double r;
    private double h;
    private String txt;

    public GDText(double x, double y, double r, double h, String txt) {
        this.x = x;
        this.y = y;
        this.r = r;
        this.h = h;
        this.txt = txt;
    }

    @Override
    public void paint(Component c, GDState gs, Graphics g) {
        if (gs.getCol() != null) {
            double rx = this.x;
            double ry = this.y;
            double hc = 0.0;
            if (this.h != 0.0) {
                FontMetrics fm = g.getFontMetrics();
                int w = fm.stringWidth(this.txt);
                hc = (double)w * this.h;
                rx = this.x - (double)w * this.h;
            }
            int ix = (int)(rx + 0.5);
            int iy = (int)(ry + 0.5);
            if (this.r != 0.0) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.translate(this.x, this.y);
                double rr = -this.r / 180.0 * Math.PI;
                g2d.rotate(rr);
                if (hc != 0.0) {
                    g2d.translate(-hc, 0.0);
                }
                g2d.drawString(this.txt, 0, 0);
                if (hc != 0.0) {
                    g2d.translate(hc, 0.0);
                }
                g2d.rotate(-rr);
                g2d.translate(-this.x, -this.y);
            } else {
                g.drawString(this.txt, ix, iy);
            }
        }
    }
}

