/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.FileObject;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.grDevices.GDContainer;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.hash.Hashing;
import org.renjin.repackaged.guava.io.Files;

public class SvgContainer
implements GDContainer {
    private static final String RENJINCI_PLOT_DIR = System.getenv("RENJINCI_PLOT_DIR");
    private final SVGGraphics2D graphics;
    private final GDState state;
    private final Dimension size;
    private int deviceNumber;
    private final Session session;
    private final String filenameFormat;
    private boolean empty = true;
    private int pageNumber = 1;

    public SvgContainer(Session session, String filenameFormat, int width, int height, Color backgroundColor) {
        this.session = session;
        this.filenameFormat = filenameFormat;
        this.size = new Dimension(width, height);
        this.graphics = new SVGGraphics2D(width, height);
        this.graphics.setBackground(backgroundColor);
        this.graphics.clearRect(0, 0, (int)this.size.getWidth(), (int)this.size.getHeight());
        this.state = new GDState();
    }

    @Override
    public void add(GDObject o) {
        this.empty = false;
        o.paint(null, this.state, (Graphics)this.graphics);
    }

    @Override
    public void reset() {
        if (!this.empty) {
            this.flush();
        }
        this.graphics.clearRect(0, 0, (int)this.size.getWidth(), (int)this.size.getHeight());
    }

    @Override
    public GDState getGState() {
        return this.state;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public void syncDisplay(boolean finish) {
    }

    @Override
    public void setDeviceNumber(int dn) {
        this.deviceNumber = dn;
    }

    @Override
    public void closeDisplay() {
        this.flush();
    }

    @Override
    public int getDeviceNumber() {
        return this.deviceNumber;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    public void flush() {
        String svg = this.graphics.getSVGDocument();
        try {
            if (!Strings.isNullOrEmpty((String)RENJINCI_PLOT_DIR)) {
                this.flushCiObject(svg);
            }
            String filename = String.format(this.filenameFormat, this.pageNumber++);
            FileObject fileObject = this.session.getFileSystemManager().resolveFile(filename);
            try (OutputStreamWriter writer = new OutputStreamWriter(fileObject.getContent().getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(svg);
            }
        }
        catch (IOException e) {
            throw new EvalException("Failed to write SVG file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void flushCiObject(String svg) throws IOException {
        boolean created;
        String hashCode = Hashing.sha256().hashString((CharSequence)svg, StandardCharsets.UTF_8).toString();
        File plotDir = new File(RENJINCI_PLOT_DIR);
        if (!plotDir.exists() && !(created = plotDir.mkdirs())) {
            throw new IOException("Could not create directory " + plotDir.getAbsolutePath());
        }
        File plotFile = new File(plotDir, hashCode + ".svg");
        Files.write((CharSequence)svg, (File)plotFile, (Charset)StandardCharsets.UTF_8);
        this.session.getStdOut().println("<<<<plot:" + hashCode + ".svg>>>>");
        this.session.getStdOut().flush();
    }
}

