/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grid;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.RecordUnitPtr;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rinternals2;
import org.renjin.grid.unit__;
import org.renjin.grid.viewport__;
import org.renjin.sexp.SEXP;

public class layout__ {
    private layout__() {
    }

    public static void calcViewportLocationFromLayout(SEXP layoutPosRow, SEXP layoutPosCol, SEXP parent, Ptr vpl) {
        int maxcol;
        int mincol;
        int maxrow;
        int minrow;
        double[] height = new double[1];
        double[] width = new double[1];
        double[] y = new double[1];
        double[] x = new double[1];
        height[0] = 0.0;
        width[0] = 0.0;
        y[0] = 0.0;
        x[0] = 0.0;
        SEXP layout = viewport__.viewportLayout(parent);
        if (Rinternals.Rf_isNull((SEXP)layoutPosRow)) {
            minrow = 0;
            maxrow = layout__.layoutNRow(layout) + -1;
        } else {
            minrow = Rinternals2.INTEGER((SEXP)layoutPosRow).getInt() + -1;
            maxrow = Rinternals2.INTEGER((SEXP)layoutPosRow).getInt(4) + -1;
        }
        if (Rinternals.Rf_isNull((SEXP)layoutPosCol)) {
            mincol = 0;
            maxcol = layout__.layoutNCol(layout) + -1;
        } else {
            mincol = Rinternals2.INTEGER((SEXP)layoutPosCol).getInt() + -1;
            maxcol = Rinternals2.INTEGER((SEXP)layoutPosCol).getInt(4) + -1;
        }
        double d = Rinternals2.REAL((SEXP)viewport__.viewportHeightCM(parent)).getDouble();
        double d2 = Rinternals2.REAL((SEXP)viewport__.viewportWidthCM(parent)).getDouble();
        Ptr ptr = Rinternals2.REAL((SEXP)viewport__.viewportLayoutHeights(parent));
        Ptr ptr2 = Rinternals2.REAL((SEXP)viewport__.viewportLayoutWidths(parent));
        layout__.subRegion(viewport__.viewportLayout(parent), minrow, maxrow, mincol, maxcol, ptr2, ptr, d2, d, (Ptr)new DoublePtr(x, 0), (Ptr)new DoublePtr(y, 0), (Ptr)new DoublePtr(width, 0), (Ptr)new DoublePtr(height, 0));
        SEXP vpx = unit__.unit(x[0], 1);
        Rinternals.Rf_protect((SEXP)vpx);
        vpl.setPointer((Ptr)new RecordUnitPtr((Object)vpx));
        SEXP vpy = unit__.unit(y[0], 1);
        Rinternals.Rf_protect((SEXP)vpy);
        vpl.setAlignedPointer(1, (Ptr)new RecordUnitPtr((Object)vpy));
        SEXP vpwidth = unit__.unit(width[0], 1);
        Rinternals.Rf_protect((SEXP)vpwidth);
        vpl.setAlignedPointer(2, (Ptr)new RecordUnitPtr((Object)vpwidth));
        SEXP vpheight = unit__.unit(height[0], 1);
        Rinternals.Rf_protect((SEXP)vpheight);
        vpl.setAlignedPointer(3, (Ptr)new RecordUnitPtr((Object)vpheight));
        vpl.setAlignedDouble(2, 0.0);
        vpl.setAlignedDouble(3, 0.0);
        Rinternals.Rf_unprotect((int)4);
    }

    public static int checkPosRowPosCol(SEXP vp, SEXP parent) {
        int ncol = layout__.layoutNCol(viewport__.viewportLayout(parent));
        int nrow = layout__.layoutNRow(viewport__.viewportLayout(parent));
        if (!(Rinternals.Rf_isNull((SEXP)viewport__.viewportLayoutPosRow(vp)) || Rinternals2.INTEGER((SEXP)viewport__.viewportLayoutPosRow(vp)).getInt() > 0 && Rinternals2.INTEGER((SEXP)viewport__.viewportLayoutPosRow(vp)).getInt(4) <= nrow)) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("invalid 'layout.pos.row'\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        if (!(Rinternals.Rf_isNull((SEXP)viewport__.viewportLayoutPosCol(vp)) || Rinternals2.INTEGER((SEXP)viewport__.viewportLayoutPosCol(vp)).getInt() > 0 && Rinternals2.INTEGER((SEXP)viewport__.viewportLayoutPosCol(vp)).getInt(4) <= ncol)) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("invalid 'layout.pos.col'\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        return 1;
    }

    public static void calcViewportLayout(SEXP viewport, double parentWidthCM, double parentHeightCM, Ptr parentContext, Ptr parentgc, Ptr dd) {
        double[] reducedHeightCM = new double[1];
        double[] reducedWidthCM = new double[1];
        Ptr npcHeights = BytePtr.of((int)0);
        int npcHeights$offset = 0;
        Ptr npcWidths = BytePtr.of((int)0);
        int npcWidths$offset = 0;
        SEXP layout = (SEXP)BytePtr.of((int)0).getArray();
        SEXP currentHeights = (SEXP)BytePtr.of((int)0).getArray();
        SEXP currentWidths = (SEXP)BytePtr.of((int)0).getArray();
        layout = viewport__.viewportLayout(viewport);
        npcWidths = DoublePtr.malloc((int)(layout__.layoutNCol(layout) * 8));
        npcWidths$offset = 0;
        npcHeights = DoublePtr.malloc((int)(layout__.layoutNRow(layout) * 8));
        npcHeights$offset = 0;
        IntPtr relativeWidths = IntPtr.malloc((int)(layout__.layoutNCol(layout) * 4));
        IntPtr relativeHeights = IntPtr.malloc((int)(layout__.layoutNRow(layout) * 4));
        reducedWidthCM[0] = parentWidthCM;
        reducedHeightCM[0] = parentHeightCM;
        layout__.findRelWidths(layout, (Ptr)relativeWidths, dd);
        layout__.findRelHeights(layout, (Ptr)relativeHeights, dd);
        layout__.allocateKnownWidths(layout, (Ptr)relativeWidths, parentWidthCM, parentHeightCM, parentContext.copyOf(32), parentgc, dd, npcWidths.pointerPlus(npcWidths$offset), (Ptr)new DoublePtr(reducedWidthCM, 0));
        layout__.allocateKnownHeights(layout, (Ptr)relativeHeights, parentWidthCM, parentHeightCM, parentContext.copyOf(32), parentgc, dd, npcHeights.pointerPlus(npcHeights$offset), (Ptr)new DoublePtr(reducedHeightCM, 0));
        if (reducedWidthCM[0] > 0.0 || reducedHeightCM[0] > 0.0) {
            layout__.allocateRespected(layout, (Ptr)relativeWidths, (Ptr)relativeHeights, (Ptr)new DoublePtr(reducedWidthCM, 0), (Ptr)new DoublePtr(reducedHeightCM, 0), parentContext.copyOf(32), parentgc, dd, npcWidths.pointerPlus(npcWidths$offset), npcHeights.pointerPlus(npcHeights$offset));
        } else {
            layout__.setRespectedZero(layout, (Ptr)relativeWidths, (Ptr)relativeHeights, npcWidths.pointerPlus(npcWidths$offset), npcHeights.pointerPlus(npcHeights$offset));
        }
        if (reducedWidthCM[0] > 0.0) {
            double reducedWidthCM$7 = reducedWidthCM[0];
            layout__.allocateRemainingWidth(layout, (Ptr)relativeWidths, reducedWidthCM$7, parentContext.copyOf(32), parentgc, dd, npcWidths.pointerPlus(npcWidths$offset));
        } else {
            layout__.setRemainingWidthZero(layout, (Ptr)relativeWidths, npcWidths.pointerPlus(npcWidths$offset));
        }
        if (reducedHeightCM[0] > 0.0) {
            double reducedHeightCM$9 = reducedHeightCM[0];
            layout__.allocateRemainingHeight(layout, (Ptr)relativeHeights, reducedHeightCM$9, parentContext.copyOf(32), parentgc, dd, npcHeights.pointerPlus(npcHeights$offset));
        } else {
            layout__.setRemainingHeightZero(layout, (Ptr)relativeHeights, npcHeights.pointerPlus(npcHeights$offset));
        }
        int n = layout__.layoutNCol(layout);
        currentWidths = Rinternals.Rf_allocVector((int)14, (int)n);
        Rinternals.Rf_protect((SEXP)currentWidths);
        int n2 = layout__.layoutNRow(layout);
        currentHeights = Rinternals.Rf_allocVector((int)14, (int)n2);
        Rinternals.Rf_protect((SEXP)currentHeights);
        int i = 0;
        while (layout__.layoutNCol(layout) > i) {
            Ptr ptr = Rinternals2.REAL((SEXP)currentWidths);
            int n3 = i * 8;
            Ptr ptr2 = ptr;
            int n4 = 0 + n3;
            int n5 = i * 8;
            Ptr ptr3 = npcWidths;
            int n6 = npcWidths$offset + n5;
            double d = ptr3.getDouble(n6);
            ptr2.setDouble(n4, d);
            ++i;
        }
        i = 0;
        while (layout__.layoutNRow(layout) > i) {
            Ptr ptr = Rinternals2.REAL((SEXP)currentHeights);
            int n7 = i * 8;
            Ptr ptr4 = ptr;
            int n8 = 0 + n7;
            int n9 = i * 8;
            Ptr ptr5 = npcHeights;
            int n10 = npcHeights$offset + n9;
            double d = ptr5.getDouble(n10);
            ptr4.setDouble(n8, d);
            ++i;
        }
        Rinternals.SET_VECTOR_ELT((SEXP)viewport, (int)20, (SEXP)currentWidths);
        Rinternals.SET_VECTOR_ELT((SEXP)viewport, (int)21, (SEXP)currentHeights);
        Rinternals.Rf_unprotect((int)2);
    }

    public static void subRegion(SEXP layout, int minrow, int maxrow, int mincol, int maxcol, Ptr widths, Ptr heights, double parentWidthCM, double parentHeightCM, Ptr left, Ptr bottom, Ptr width, Ptr height) {
        double hjust = layout__.layoutHJust(layout);
        double vjust = layout__.layoutVJust(layout);
        int n = layout__.layoutNCol(layout) + -1;
        double totalWidth = layout__.sumDims(widths, 0, n);
        int n2 = layout__.layoutNRow(layout) + -1;
        double totalHeight = layout__.sumDims(heights, 0, n2);
        double d = layout__.sumDims(widths, mincol, maxcol);
        width.setDouble(d);
        double d2 = layout__.sumDims(heights, minrow, maxrow);
        height.setDouble(d2);
        double d3 = parentWidthCM * hjust;
        double d4 = totalWidth * hjust;
        double d5 = d3 - d4;
        int n3 = mincol + -1;
        double d6 = layout__.sumDims(widths, 0, n3);
        double d7 = d5 + d6;
        left.setDouble(d7);
        double d8 = parentHeightCM * vjust;
        double d9 = (1.0 - vjust) * totalHeight;
        double d10 = d8 + d9;
        double d11 = layout__.sumDims(heights, 0, maxrow);
        double d12 = d10 - d11;
        bottom.setDouble(d12);
    }

    public static double sumDims(Ptr dims, int from, int to) {
        double s = 0.0;
        int i = from;
        while (to + 1 > i) {
            int n = i * 8;
            Ptr ptr = dims;
            int n2 = n;
            s = ptr.getDouble(n2) + s;
            ++i;
        }
        return s;
    }

    public static void allocateRemainingHeight(SEXP layout, Ptr relativeHeights, double remainingHeightCM, Ptr parentContext, Ptr parentgc, Ptr dd, Ptr npcHeights) {
        double sumHeight = 0.0;
        SEXP heights = (SEXP)BytePtr.of((int)0).getArray();
        heights = layout__.layoutHeights(layout);
        sumHeight = layout__.totalUnrespectedHeight(layout, relativeHeights, parentContext.copyOf(32), parentgc, dd);
        if (sumHeight > 0.0) {
            int i = 0;
            while (layout__.layoutNRow(layout) > i) {
                Ptr ptr = relativeHeights;
                int n = i * 4;
                int n2 = n;
                if (ptr.getInt(n2) != 0 && layout__.rowRespected(i, layout) == 0) {
                    int n3 = i * 8;
                    Ptr ptr2 = npcHeights;
                    int n4 = n3;
                    double d = unit__.transformHeight(heights, i, parentContext.copyOf(32), parentgc, 0.0, 0.0, 1, 0, dd) * remainingHeightCM / sumHeight;
                    ptr2.setDouble(n4, d);
                }
                ++i;
            }
        } else {
            layout__.setRemainingHeightZero(layout, relativeHeights, npcHeights);
        }
    }

    public static void setRemainingHeightZero(SEXP layout, Ptr relativeHeights, Ptr npcHeights) {
        int i = 0;
        while (layout__.layoutNRow(layout) > i) {
            Ptr ptr = relativeHeights;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) != 0 && layout__.rowRespected(i, layout) == 0) {
                int n3 = i * 8;
                Ptr ptr2 = npcHeights;
                int n4 = n3;
                ptr2.setDouble(n4, 0.0);
            }
            ++i;
        }
    }

    public static void allocateRemainingWidth(SEXP layout, Ptr relativeWidths, double remainingWidthCM, Ptr parentContext, Ptr parentgc, Ptr dd, Ptr npcWidths) {
        double sumWidth = 0.0;
        SEXP widths = (SEXP)BytePtr.of((int)0).getArray();
        widths = layout__.layoutWidths(layout);
        sumWidth = layout__.totalUnrespectedWidth(layout, relativeWidths, parentContext.copyOf(32), parentgc, dd);
        if (sumWidth > 0.0) {
            int i = 0;
            while (layout__.layoutNCol(layout) > i) {
                Ptr ptr = relativeWidths;
                int n = i * 4;
                int n2 = n;
                if (ptr.getInt(n2) != 0 && layout__.colRespected(i, layout) == 0) {
                    int n3 = i * 8;
                    Ptr ptr2 = npcWidths;
                    int n4 = n3;
                    double d = unit__.transformWidth(widths, i, parentContext.copyOf(32), parentgc, 0.0, 0.0, 1, 0, dd) * remainingWidthCM / sumWidth;
                    ptr2.setDouble(n4, d);
                }
                ++i;
            }
        } else {
            layout__.setRemainingWidthZero(layout, relativeWidths, npcWidths);
        }
    }

    public static void setRemainingWidthZero(SEXP layout, Ptr relativeWidths, Ptr npcWidths) {
        int i = 0;
        while (layout__.layoutNCol(layout) > i) {
            Ptr ptr = relativeWidths;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) != 0 && layout__.colRespected(i, layout) == 0) {
                int n3 = i * 8;
                Ptr ptr2 = npcWidths;
                int n4 = n3;
                ptr2.setDouble(n4, 0.0);
            }
            ++i;
        }
    }

    public static double totalUnrespectedHeight(SEXP layout, Ptr relativeHeights, Ptr parentContext, Ptr parentgc, Ptr dd) {
        double totalHeight = 0.0;
        SEXP heights = (SEXP)BytePtr.of((int)0).getArray();
        heights = layout__.layoutHeights(layout);
        totalHeight = 0.0;
        int i = 0;
        while (layout__.layoutNRow(layout) > i) {
            Ptr ptr = relativeHeights;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) != 0 && layout__.rowRespected(i, layout) == 0) {
                totalHeight = unit__.transformHeight(heights, i, parentContext.copyOf(32), parentgc, 0.0, 0.0, 1, 0, dd) + totalHeight;
            }
            ++i;
        }
        return totalHeight;
    }

    public static double totalUnrespectedWidth(SEXP layout, Ptr relativeWidths, Ptr parentContext, Ptr parentgc, Ptr dd) {
        double totalWidth = 0.0;
        SEXP widths = (SEXP)BytePtr.of((int)0).getArray();
        widths = layout__.layoutWidths(layout);
        totalWidth = 0.0;
        int i = 0;
        while (layout__.layoutNCol(layout) > i) {
            Ptr ptr = relativeWidths;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) != 0 && layout__.colRespected(i, layout) == 0) {
                totalWidth = unit__.transformWidth(widths, i, parentContext.copyOf(32), parentgc, 0.0, 0.0, 1, 0, dd) + totalWidth;
            }
            ++i;
        }
        return totalWidth;
    }

    public static void setRespectedZero(SEXP layout, Ptr relativeWidths, Ptr relativeHeights, Ptr npcWidths, Ptr npcHeights) {
        int i = 0;
        while (layout__.layoutNCol(layout) > i) {
            Ptr ptr = relativeWidths;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) != 0 && layout__.colRespected(i, layout) != 0) {
                int n3 = i * 8;
                Ptr ptr2 = npcWidths;
                int n4 = n3;
                ptr2.setDouble(n4, 0.0);
            }
            ++i;
        }
        i = 0;
        while (layout__.layoutNRow(layout) > i) {
            Ptr ptr = relativeHeights;
            int n = i * 4;
            int n5 = n;
            if (ptr.getInt(n5) != 0 && layout__.rowRespected(i, layout) != 0) {
                int n6 = i * 8;
                Ptr ptr3 = npcHeights;
                int n7 = n6;
                ptr3.setDouble(n7, 0.0);
            }
            ++i;
        }
    }

    public static void allocateRespected(SEXP layout, Ptr relativeWidths, Ptr relativeHeights, Ptr reducedWidthCM, Ptr reducedHeightCM, Ptr parentContext, Ptr parentgc, Ptr dd, Ptr npcWidths, Ptr npcHeights) {
        double tempHeightCM = 0.0;
        double tempWidthCM = 0.0;
        double mult = 0.0;
        double denom = 0.0;
        double sumHeight = 0.0;
        double sumWidth = 0.0;
        SEXP heights = (SEXP)BytePtr.of((int)0).getArray();
        SEXP widths = (SEXP)BytePtr.of((int)0).getArray();
        widths = layout__.layoutWidths(layout);
        heights = layout__.layoutHeights(layout);
        int respect = layout__.layoutRespect(layout);
        sumWidth = layout__.totalWidth(layout, relativeWidths, parentContext.copyOf(32), parentgc, dd);
        sumHeight = layout__.totalHeight(layout, relativeHeights, parentContext.copyOf(32), parentgc, dd);
        tempWidthCM = reducedWidthCM.getDouble();
        tempHeightCM = reducedHeightCM.getDouble();
        if (respect > 0) {
            double d = tempHeightCM * sumWidth;
            double d2 = sumHeight * tempWidthCM;
            if (d > d2) {
                denom = sumWidth;
                mult = tempWidthCM;
            } else {
                denom = sumHeight;
                mult = tempHeightCM;
            }
            int i = 0;
            while (layout__.layoutNCol(layout) > i) {
                Ptr ptr = relativeWidths;
                int n = i * 4;
                int n2 = n;
                if (ptr.getInt(n2) != 0 && layout__.colRespected(i, layout) != 0) {
                    if (sumHeight == 0.0) {
                        denom = sumWidth;
                        mult = tempWidthCM;
                    }
                    int n3 = i * 8;
                    Ptr ptr2 = npcWidths;
                    int n4 = n3;
                    double d3 = unit__.pureNullUnitValue(widths, i) / denom * mult;
                    ptr2.setDouble(n4, d3);
                    double d4 = reducedWidthCM.getDouble();
                    int n5 = i * 8;
                    Ptr ptr3 = npcWidths;
                    int n6 = n5;
                    double d5 = ptr3.getDouble(n6);
                    double d6 = d4 - d5;
                    reducedWidthCM.setDouble(d6);
                }
                ++i;
            }
            i = 0;
            while (layout__.layoutNRow(layout) > i) {
                Ptr ptr = relativeHeights;
                int n = i * 4;
                int n7 = n;
                if (ptr.getInt(n7) != 0 && layout__.rowRespected(i, layout) != 0) {
                    if (sumWidth == 0.0) {
                        denom = sumHeight;
                        mult = tempHeightCM;
                    }
                    int n8 = i * 8;
                    Ptr ptr4 = npcHeights;
                    int n9 = n8;
                    double d7 = unit__.pureNullUnitValue(heights, i) / denom * mult;
                    ptr4.setDouble(n9, d7);
                    double d8 = reducedHeightCM.getDouble();
                    int n10 = i * 8;
                    Ptr ptr5 = npcHeights;
                    int n11 = n10;
                    double d9 = ptr5.getDouble(n11);
                    double d10 = d8 - d9;
                    reducedHeightCM.setDouble(d10);
                }
                ++i;
            }
        }
    }

    public static double totalHeight(SEXP layout, Ptr relativeHeights, Ptr parentContext, Ptr parentgc, Ptr dd) {
        double totalHeight = 0.0;
        SEXP heights = (SEXP)BytePtr.of((int)0).getArray();
        heights = layout__.layoutHeights(layout);
        totalHeight = 0.0;
        int i = 0;
        while (layout__.layoutNRow(layout) > i) {
            Ptr ptr = relativeHeights;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) != 0) {
                totalHeight = unit__.transformHeight(heights, i, parentContext.copyOf(32), parentgc, 0.0, 0.0, 1, 0, dd) + totalHeight;
            }
            ++i;
        }
        return totalHeight;
    }

    public static double totalWidth(SEXP layout, Ptr relativeWidths, Ptr parentContext, Ptr parentgc, Ptr dd) {
        double totalWidth = 0.0;
        SEXP widths = (SEXP)BytePtr.of((int)0).getArray();
        widths = layout__.layoutWidths(layout);
        totalWidth = 0.0;
        int i = 0;
        while (layout__.layoutNCol(layout) > i) {
            Ptr ptr = relativeWidths;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) != 0) {
                totalWidth = unit__.transformWidth(widths, i, parentContext.copyOf(32), parentgc, 0.0, 0.0, 1, 0, dd) + totalWidth;
            }
            ++i;
        }
        return totalWidth;
    }

    public static int rowRespected(int row, SEXP layout) {
        Ptr respectMat = BytePtr.of((int)0);
        int respectMat$offset = 0;
        int result = 0;
        result = 0;
        int respect = layout__.layoutRespect(layout);
        respectMat = layout__.layoutRespectMat(layout);
        respectMat$offset = 0;
        if (respect == 1) {
            result = 1;
        } else {
            int i = 0;
            while (layout__.layoutNCol(layout) > i) {
                Ptr ptr = respectMat;
                int n = (layout__.layoutNRow(layout) * i + row) * 4;
                int n2 = respectMat$offset + n;
                if (ptr.getInt(n2) != 0) {
                    result = 1;
                }
                ++i;
            }
        }
        return result;
    }

    public static int colRespected(int col, SEXP layout) {
        Ptr respectMat = BytePtr.of((int)0);
        int respectMat$offset = 0;
        int result = 0;
        result = 0;
        int respect = layout__.layoutRespect(layout);
        respectMat = layout__.layoutRespectMat(layout);
        respectMat$offset = 0;
        if (respect == 1) {
            result = 1;
        } else {
            int i = 0;
            while (layout__.layoutNRow(layout) > i) {
                Ptr ptr = respectMat;
                int n = (layout__.layoutNRow(layout) * col + i) * 4;
                int n2 = respectMat$offset + n;
                if (ptr.getInt(n2) != 0) {
                    result = 1;
                }
                ++i;
            }
        }
        return result;
    }

    public static void allocateKnownHeights(SEXP layout, Ptr relativeHeights, double parentWidthCM, double parentHeightCM, Ptr parentContext, Ptr parentgc, Ptr dd, Ptr npcHeights, Ptr heightLeftCM) {
        SEXP heights = (SEXP)BytePtr.of((int)0).getArray();
        heights = layout__.layoutHeights(layout);
        int i = 0;
        while (layout__.layoutNRow(layout) > i) {
            Ptr ptr = relativeHeights;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) == 0) {
                int n3 = i * 8;
                Ptr ptr2 = npcHeights;
                int n4 = n3;
                double d = unit__.transformHeight(heights, i, parentContext.copyOf(32), parentgc, parentWidthCM, parentHeightCM, 0, 0, dd) * 2.54;
                ptr2.setDouble(n4, d);
                double d2 = heightLeftCM.getDouble();
                int n5 = i * 8;
                Ptr ptr3 = npcHeights;
                int n6 = n5;
                double d3 = ptr3.getDouble(n6);
                double d4 = d2 - d3;
                heightLeftCM.setDouble(d4);
            }
            ++i;
        }
    }

    public static void allocateKnownWidths(SEXP layout, Ptr relativeWidths, double parentWidthCM, double parentHeightCM, Ptr parentContext, Ptr parentgc, Ptr dd, Ptr npcWidths, Ptr widthLeftCM) {
        SEXP widths = (SEXP)BytePtr.of((int)0).getArray();
        widths = layout__.layoutWidths(layout);
        int i = 0;
        while (layout__.layoutNCol(layout) > i) {
            Ptr ptr = relativeWidths;
            int n = i * 4;
            int n2 = n;
            if (ptr.getInt(n2) == 0) {
                int n3 = i * 8;
                Ptr ptr2 = npcWidths;
                int n4 = n3;
                double d = unit__.transformWidth(widths, i, parentContext.copyOf(32), parentgc, parentWidthCM, parentHeightCM, 0, 0, dd) * 2.54;
                ptr2.setDouble(n4, d);
                double d2 = widthLeftCM.getDouble();
                int n5 = i * 8;
                Ptr ptr3 = npcWidths;
                int n6 = n5;
                double d3 = ptr3.getDouble(n6);
                double d4 = d2 - d3;
                widthLeftCM.setDouble(d4);
            }
            ++i;
        }
    }

    public static void findRelHeights(SEXP layout, Ptr relativeHeights, Ptr dd) {
        SEXP heights = (SEXP)BytePtr.of((int)0).getArray();
        heights = layout__.layoutHeights(layout);
        int i = 0;
        while (layout__.layoutNRow(layout) > i) {
            int n = i * 4;
            Ptr ptr = relativeHeights;
            int n2 = n;
            int n3 = layout__.relativeUnit(heights, i, dd);
            ptr.setInt(n2, n3);
            ++i;
        }
    }

    public static void findRelWidths(SEXP layout, Ptr relativeWidths, Ptr dd) {
        SEXP widths = (SEXP)BytePtr.of((int)0).getArray();
        widths = layout__.layoutWidths(layout);
        int i = 0;
        while (layout__.layoutNCol(layout) > i) {
            int n = i * 4;
            Ptr ptr = relativeWidths;
            int n2 = n;
            int n3 = layout__.relativeUnit(widths, i, dd);
            ptr.setInt(n2, n3);
            ++i;
        }
    }

    public static int relativeUnit(SEXP unit, int index, Ptr dd) {
        return unit__.pureNullUnit(unit, index, dd);
    }

    public static double layoutVJust(SEXP l) {
        return Rinternals2.REAL((SEXP)Rinternals.VECTOR_ELT((SEXP)l, (int)8)).getDouble(8);
    }

    public static double layoutHJust(SEXP l) {
        return Rinternals2.REAL((SEXP)Rinternals.VECTOR_ELT((SEXP)l, (int)8)).getDouble();
    }

    public static Ptr layoutRespectMat(SEXP l) {
        return Rinternals2.INTEGER((SEXP)Rinternals.VECTOR_ELT((SEXP)l, (int)6));
    }

    public static int layoutRespect(SEXP l) {
        return Rinternals2.INTEGER((SEXP)Rinternals.VECTOR_ELT((SEXP)l, (int)5)).getInt();
    }

    public static SEXP layoutHeights(SEXP l) {
        return Rinternals.VECTOR_ELT((SEXP)l, (int)3);
    }

    public static SEXP layoutWidths(SEXP l) {
        return Rinternals.VECTOR_ELT((SEXP)l, (int)2);
    }

    public static int layoutNCol(SEXP l) {
        return Rinternals2.INTEGER((SEXP)Rinternals.VECTOR_ELT((SEXP)l, (int)1)).getInt();
    }

    public static int layoutNRow(SEXP l) {
        return Rinternals2.INTEGER((SEXP)Rinternals.VECTOR_ELT((SEXP)l, (int)0)).getInt();
    }
}

