/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grid;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.MixedPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.gnur.api.Error;
import org.renjin.gnur.api.GetText;
import org.renjin.gnur.api.Rinternals;
import org.renjin.gnur.api.Rinternals2;
import org.renjin.grDevices.main_engine__;
import org.renjin.grDevices.main_plotmath__;
import org.renjin.grid.gpar__;
import org.renjin.grid.grid__;
import org.renjin.grid.matrix__;
import org.renjin.grid.state__;
import org.renjin.grid.util__;
import org.renjin.grid.viewport__;
import org.renjin.sexp.SEXP;

public class unit__ {
    public static Ptr UnitTable = MixedPtr.malloc((int)344);

    private unit__() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SEXP validUnits(SEXP units) {
        SEXP answer = (SEXP)BytePtr.of((int)0).getArray();
        int n = 0;
        SEXP sEXP = (SEXP)BytePtr.of((int)0).getArray();
        n = Rinternals.LENGTH((SEXP)units);
        answer = Rinternals.R_NilValue;
        if (n > 0) {
            if (Rinternals.Rf_isString((SEXP)units)) {
                answer = Rinternals.Rf_allocVector((int)13, (int)n);
                Rinternals.Rf_protect((SEXP)answer);
                int i = 0;
                while (i < n) {
                    Ptr ptr = Rinternals2.INTEGER((SEXP)answer);
                    int n2 = i * 4;
                    Ptr ptr2 = ptr;
                    int n3 = 0 + n2;
                    int n4 = unit__.convertUnit(units, i);
                    ptr2.setInt(n3, n4);
                    ++i;
                }
                Rinternals.Rf_unprotect((int)1);
                return answer;
            }
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("'units' must be character\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("'units' must be of length > 0\u0000".getBytes(), 0)), (Object[])new Object[0]);
        return sEXP;
    }

    public static int convertUnit(SEXP unit, int index) {
        boolean found = false;
        int result = 0;
        int i = 0;
        result = 0;
        found = false;
        while (result >= 0 && !found) {
            if (UnitTable.getPointer(i * 8).isNull()) {
                result = -1;
            } else {
                Ptr ptr = UnitTable.getPointer(i * 8);
                boolean bl = found = Stdlib.strcmp((Ptr)Rinternals.R_CHAR((SEXP)Rinternals.STRING_ELT((SEXP)unit, (int)index)), (Ptr)ptr) == 0;
                if (found && (result = UnitTable.getInt(i * 8 + 4)) > 1000) {
                    result -= 1000;
                }
            }
            ++i;
        }
        if (result < 0) {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("Invalid unit\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        return result;
    }

    public static double transformWHfromNPC(double x, int to, double min, double max) {
        double result = x;
        switch (to) {
            case 0: {
                break;
            }
            case 4: {
                result = (max - min) * x;
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("Unsupported unit conversion\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public static double transformXYfromNPC(double x, int to, double min, double max) {
        double result = x;
        switch (to) {
            case 0: {
                break;
            }
            case 4: {
                result = (max - min) * x + min;
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("Unsupported unit conversion\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public static double transformWHtoNPC(double x, int from, double min, double max) {
        double result = x;
        switch (from) {
            case 0: {
                break;
            }
            case 4: {
                double d = max - min;
                result = x / d;
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("Unsupported unit conversion\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public static double transformXYtoNPC(double x, int from, double min, double max) {
        double result = x;
        switch (from) {
            case 0: {
                break;
            }
            case 4: {
                double d = x - min;
                double d2 = max - min;
                result = d / d2;
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("Unsupported unit conversion\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public static double transformWidthHeightFromINCHES(double dimension, int unit, double scalemin, double scalemax, Ptr gc, double thisCM, double otherCM, Ptr dd) {
        double result = dimension;
        if ((unit == 4 || unit == 0) && thisCM < 1.0E-6) {
            if (result != 0.0) {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("Viewport has zero dimension(s)\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        } else {
            switch (unit) {
                case 4: {
                    double d = thisCM / 2.54;
                    double d2 = result / d;
                    double d3 = scalemax - scalemin;
                    result = d2 * d3;
                    break;
                }
                default: {
                    result = unit__.transformFromINCHES(dimension, unit, gc, thisCM, otherCM, dd);
                }
            }
        }
        return result;
    }

    public static double transformXYFromINCHES(double location, int unit, double scalemin, double scalemax, Ptr gc, double thisCM, double otherCM, Ptr dd) {
        double result = location;
        if ((unit == 4 || unit == 0) && thisCM < 1.0E-6) {
            if (result != 0.0) {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("Viewport has zero dimension(s)\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        } else {
            switch (unit) {
                case 4: {
                    double d = thisCM / 2.54;
                    double d2 = result / d;
                    double d3 = scalemax - scalemin;
                    result = d2 * d3 + scalemin;
                    break;
                }
                default: {
                    result = unit__.transformFromINCHES(location, unit, gc, thisCM, otherCM, dd);
                }
            }
        }
        return result;
    }

    public static double transformFromINCHES(double value, int unit, Ptr gc, double thisCM, double otherCM, Ptr dd) {
        double result = value;
        switch (unit) {
            case 0: {
                double d = thisCM / 2.54;
                result /= d;
                break;
            }
            case 1: {
                result *= 2.54;
                break;
            }
            case 2: {
                break;
            }
            case 18: {
                double d = result * 72.0;
                double d2 = gc.getDouble(52);
                double d3 = gc.getDouble(44);
                double d4 = d2 * d3;
                result = d / d4;
                break;
            }
            case 3: {
                double d = result * 72.0;
                double d5 = gc.getDouble(52);
                double d6 = gc.getDouble(44);
                double d7 = d5 * d6;
                double d8 = gc.getDouble(60);
                double d9 = d7 * d8;
                result = d / d9;
                break;
            }
            case 7: {
                result = result * 2.54 * 10.0;
                break;
            }
            case 8: {
                result *= 72.27;
                break;
            }
            case 9: {
                result = result / 12.0 * 72.27;
                break;
            }
            case 10: {
                result *= 72.0;
                break;
            }
            case 11: {
                result = result / 1238.0 * 1157.0 * 72.27;
                break;
            }
            case 12: {
                result = result / 1238.0 * 1157.0 * 72.27 / 12.0;
                break;
            }
            case 13: {
                result = result * 65536.0 * 72.27;
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("invalid unit or unit not yet implemented\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        switch (unit) {
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                double d = Rinternals2.REAL((SEXP)state__.gridStateElement(dd, 15)).getDouble();
                result /= d;
                break;
            }
        }
        return result;
    }

    public static void transformDimn(SEXP w, SEXP h, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, Ptr dd, double rotationAngle, Ptr ww, Ptr hh) {
        double[] r = new double[9];
        double[] dout = new double[3];
        double[] din = new double[3];
        double d = unit__.transformWidthtoINCHES(w, index, vpc.copyOf(32), gc, widthCM, heightCM, dd);
        ww.setDouble(d);
        double d2 = unit__.transformHeighttoINCHES(h, index, vpc.copyOf(32), gc, widthCM, heightCM, dd);
        hh.setDouble(d2);
        double d3 = hh.getDouble();
        matrix__.location(ww.getDouble(), d3, (Ptr)new DoublePtr(din, 0));
        matrix__.rotation(rotationAngle, (Ptr)new DoublePtr(r, 0));
        matrix__.trans((Ptr)new DoublePtr(din, 0), (Ptr)new DoublePtr(r, 0), (Ptr)new DoublePtr(dout, 0));
        double d4 = matrix__.locationX((Ptr)new DoublePtr(dout, 0));
        ww.setDouble(d4);
        double d5 = matrix__.locationY((Ptr)new DoublePtr(dout, 0));
        hh.setDouble(d5);
    }

    public static double transformHeighttoINCHES(SEXP h, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, Ptr dd) {
        return unit__.transformHeight(h, index, vpc.copyOf(32), gc, widthCM, heightCM, 0, 0, dd);
    }

    public static double transformWidthtoINCHES(SEXP w, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, Ptr dd) {
        return unit__.transformWidth(w, index, vpc.copyOf(32), gc, widthCM, heightCM, 0, 0, dd);
    }

    public static void transformLocn(SEXP x, SEXP y, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, Ptr dd, Ptr t, Ptr xx, Ptr yy) {
        double[] lout = new double[3];
        double[] lin = new double[3];
        double d = unit__.transformXtoINCHES(x, index, vpc.copyOf(32), gc, widthCM, heightCM, dd);
        xx.setDouble(d);
        double d2 = unit__.transformYtoINCHES(y, index, vpc.copyOf(32), gc, widthCM, heightCM, dd);
        yy.setDouble(d2);
        double d3 = yy.getDouble();
        matrix__.location(xx.getDouble(), d3, (Ptr)new DoublePtr(lin, 0));
        matrix__.trans((Ptr)new DoublePtr(lin, 0), t, (Ptr)new DoublePtr(lout, 0));
        double d4 = matrix__.locationX((Ptr)new DoublePtr(lout, 0));
        xx.setDouble(d4);
        double d5 = matrix__.locationY((Ptr)new DoublePtr(lout, 0));
        yy.setDouble(d5);
    }

    public static double transformYtoINCHES(SEXP y, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, Ptr dd) {
        return unit__.transformY(y, index, vpc.copyOf(32), gc, widthCM, heightCM, 0, 0, dd);
    }

    public static double transformXtoINCHES(SEXP x, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, Ptr dd) {
        return unit__.transformX(x, index, vpc.copyOf(32), gc, widthCM, heightCM, 0, 0, dd);
    }

    public static double transformHeightArithmetic(SEXP height, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, Ptr dd) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double result = 0.0;
        result = 0.0;
        if (unit__.addOp(height) != 0) {
            double d = unit__.transformHeight(unit__.arg1(height), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            double d2 = unit__.transformHeight(unit__.arg2(height), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            result = d + d2;
        } else if (unit__.minusOp(height) != 0) {
            double d = unit__.transformHeight(unit__.arg1(height), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            double d3 = unit__.transformHeight(unit__.arg2(height), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            result = d - d3;
        } else if (unit__.timesOp(height) != 0) {
            Ptr ptr = Rinternals2.REAL((SEXP)unit__.arg1(height));
            int n4 = Rinternals.LENGTH((SEXP)unit__.arg1(height));
            int n5 = index % n4 * 8;
            Ptr ptr2 = ptr;
            int n6 = 0 + n5;
            double d = ptr2.getDouble(n6);
            double d4 = unit__.transformHeight(unit__.arg2(height), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 7, dd);
            result = d * d4;
        } else if (unit__.minFunc(height) != 0) {
            n3 = unit__.unitLength(unit__.arg1(height));
            double temp = Double.MAX_VALUE;
            result = unit__.transformHeight(unit__.arg1(height), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
            int i = 1;
            while (i < n3) {
                temp = unit__.transformHeight(unit__.arg1(height), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
                if (temp < result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.maxFunc(height) != 0) {
            n2 = unit__.unitLength(unit__.arg1(height));
            double temp = Double.MIN_NORMAL;
            result = unit__.transformHeight(unit__.arg1(height), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
            int i = 1;
            while (i < n2) {
                temp = unit__.transformHeight(unit__.arg1(height), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
                if (temp > result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.sumFunc(height) != 0) {
            n = unit__.unitLength(unit__.arg1(height));
            result = 0.0;
            int i = 0;
            while (i < n) {
                result = unit__.transformHeight(unit__.arg1(height), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 3, dd) + result;
                ++i;
            }
        } else {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("unimplemented unit function\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        return result;
    }

    public static double transformWidthArithmetic(SEXP width, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, Ptr dd) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double result = 0.0;
        result = 0.0;
        if (unit__.addOp(width) != 0) {
            double d = unit__.transformWidth(unit__.arg1(width), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            double d2 = unit__.transformWidth(unit__.arg2(width), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            result = d + d2;
        } else if (unit__.minusOp(width) != 0) {
            double d = unit__.transformWidth(unit__.arg1(width), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            double d3 = unit__.transformWidth(unit__.arg2(width), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            result = d - d3;
        } else if (unit__.timesOp(width) != 0) {
            Ptr ptr = Rinternals2.REAL((SEXP)unit__.arg1(width));
            int n4 = Rinternals.LENGTH((SEXP)unit__.arg1(width));
            int n5 = index % n4 * 8;
            Ptr ptr2 = ptr;
            int n6 = 0 + n5;
            double d = ptr2.getDouble(n6);
            double d4 = unit__.transformWidth(unit__.arg2(width), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 7, dd);
            result = d * d4;
        } else if (unit__.minFunc(width) != 0) {
            n3 = unit__.unitLength(unit__.arg1(width));
            double temp = Double.MAX_VALUE;
            result = unit__.transformWidth(unit__.arg1(width), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
            int i = 1;
            while (i < n3) {
                temp = unit__.transformWidth(unit__.arg1(width), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
                if (temp < result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.maxFunc(width) != 0) {
            n2 = unit__.unitLength(unit__.arg1(width));
            double temp = Double.MIN_NORMAL;
            result = unit__.transformWidth(unit__.arg1(width), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
            int i = 1;
            while (i < n2) {
                temp = unit__.transformWidth(unit__.arg1(width), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
                if (temp > result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.sumFunc(width) != 0) {
            n = unit__.unitLength(unit__.arg1(width));
            result = 0.0;
            int i = 0;
            while (i < n) {
                result = unit__.transformWidth(unit__.arg1(width), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 3, dd) + result;
                ++i;
            }
        } else {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("unimplemented unit function\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        return result;
    }

    public static double transformYArithmetic(SEXP y, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, Ptr dd) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double result = 0.0;
        result = 0.0;
        if (unit__.addOp(y) != 0) {
            double d = unit__.transformY(unit__.arg1(y), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            double d2 = unit__.transformY(unit__.arg2(y), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            result = d + d2;
        } else if (unit__.minusOp(y) != 0) {
            double d = unit__.transformY(unit__.arg1(y), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            double d3 = unit__.transformY(unit__.arg2(y), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            result = d - d3;
        } else if (unit__.timesOp(y) != 0) {
            Ptr ptr = Rinternals2.REAL((SEXP)unit__.arg1(y));
            int n4 = Rinternals.LENGTH((SEXP)unit__.arg1(y));
            int n5 = index % n4 * 8;
            Ptr ptr2 = ptr;
            int n6 = 0 + n5;
            double d = ptr2.getDouble(n6);
            double d4 = unit__.transformY(unit__.arg2(y), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 7, dd);
            result = d * d4;
        } else if (unit__.minFunc(y) != 0) {
            n3 = unit__.unitLength(unit__.arg1(y));
            double temp = Double.MAX_VALUE;
            result = unit__.transformY(unit__.arg1(y), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
            int i = 1;
            while (i < n3) {
                temp = unit__.transformY(unit__.arg1(y), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
                if (temp < result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.maxFunc(y) != 0) {
            n2 = unit__.unitLength(unit__.arg1(y));
            double temp = Double.MIN_NORMAL;
            result = unit__.transformY(unit__.arg1(y), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
            int i = 1;
            while (i < n2) {
                temp = unit__.transformY(unit__.arg1(y), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
                if (temp > result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.sumFunc(y) != 0) {
            n = unit__.unitLength(unit__.arg1(y));
            result = 0.0;
            int i = 0;
            while (i < n) {
                result = unit__.transformY(unit__.arg1(y), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 3, dd) + result;
                ++i;
            }
        } else {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("unimplemented unit function\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        return result;
    }

    public static double transformXArithmetic(SEXP x, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, Ptr dd) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double result = 0.0;
        result = 0.0;
        if (unit__.addOp(x) != 0) {
            double d = unit__.transformX(unit__.arg1(x), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            double d2 = unit__.transformX(unit__.arg2(x), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 1, dd);
            result = d + d2;
        } else if (unit__.minusOp(x) != 0) {
            double d = unit__.transformX(unit__.arg1(x), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            double d3 = unit__.transformX(unit__.arg2(x), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 2, dd);
            result = d - d3;
        } else if (unit__.timesOp(x) != 0) {
            Ptr ptr = Rinternals2.REAL((SEXP)unit__.arg1(x));
            int n4 = Rinternals.LENGTH((SEXP)unit__.arg1(x));
            int n5 = index % n4 * 8;
            Ptr ptr2 = ptr;
            int n6 = 0 + n5;
            double d = ptr2.getDouble(n6);
            double d4 = unit__.transformX(unit__.arg2(x), index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 7, dd);
            result = d * d4;
        } else if (unit__.minFunc(x) != 0) {
            n3 = unit__.unitLength(unit__.arg1(x));
            double temp = Double.MAX_VALUE;
            result = unit__.transformX(unit__.arg1(x), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
            int i = 1;
            while (i < n3) {
                temp = unit__.transformX(unit__.arg1(x), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 6, dd);
                if (temp < result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.maxFunc(x) != 0) {
            n2 = unit__.unitLength(unit__.arg1(x));
            double temp = Double.MIN_NORMAL;
            result = unit__.transformX(unit__.arg1(x), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
            int i = 1;
            while (i < n2) {
                temp = unit__.transformX(unit__.arg1(x), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 5, dd);
                if (temp > result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.sumFunc(x) != 0) {
            n = unit__.unitLength(unit__.arg1(x));
            result = 0.0;
            int i = 0;
            while (i < n) {
                result = unit__.transformX(unit__.arg1(x), i, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, 3, dd) + result;
                ++i;
            }
        } else {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("unimplemented unit function\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        return result;
    }

    public static double transformHeight(SEXP height, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, int nullAMode, Ptr dd) {
        double result;
        if (unit__.isUnitArithmetic(height) != 0) {
            result = unit__.transformHeightArithmetic(height, index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, dd);
        } else if (unit__.isUnitList(height) != 0) {
            int n = unit__.unitLength(height);
            int n2 = index % n;
            result = unit__.transformHeight(Rinternals.VECTOR_ELT((SEXP)height, (int)n2), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, nullAMode, dd);
        } else {
            int nullamode = nullAMode == 0 ? 4 : nullAMode;
            result = unit__.unitValue(height, index);
            int unit = unit__.unitUnit(height, index);
            SEXP data = unit__.unitData(height, index);
            Rinternals.Rf_protect((SEXP)data);
            double d = vpc.getAlignedDouble(3);
            double d2 = vpc.getAlignedDouble(2);
            result = unit__.transformDimension(result, unit, data, d2, d, gc, heightCM, widthCM, nullLMode, nullamode, dd);
            Rinternals.Rf_unprotect((int)1);
        }
        return result;
    }

    public static double transformWidth(SEXP width, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, int nullAMode, Ptr dd) {
        double result;
        if (unit__.isUnitArithmetic(width) != 0) {
            result = unit__.transformWidthArithmetic(width, index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, dd);
        } else if (unit__.isUnitList(width) != 0) {
            int n = unit__.unitLength(width);
            int n2 = index % n;
            result = unit__.transformWidth(Rinternals.VECTOR_ELT((SEXP)width, (int)n2), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, nullAMode, dd);
        } else {
            int nullamode = nullAMode == 0 ? 4 : nullAMode;
            result = unit__.unitValue(width, index);
            int unit = unit__.unitUnit(width, index);
            SEXP data = unit__.unitData(width, index);
            Rinternals.Rf_protect((SEXP)data);
            double d = vpc.getAlignedDouble(1);
            double d2 = vpc.getDouble();
            result = unit__.transformDimension(result, unit, data, d2, d, gc, widthCM, heightCM, nullLMode, nullamode, dd);
            Rinternals.Rf_unprotect((int)1);
        }
        return result;
    }

    public static double transformDimension(double dim, int unit, SEXP data, double scalemin, double scalemax, Ptr gc, double thisCM, double otherCM, int nullLMode, int nullAMode, Ptr dd) {
        double result = dim;
        switch (unit) {
            case 4: {
                double d = scalemax - scalemin;
                result = dim / d * thisCM / 2.54;
                break;
            }
            default: {
                result = unit__.transform(dim, unit, data, scalemin, scalemax, gc, thisCM, otherCM, nullLMode, nullAMode, dd);
            }
        }
        return result;
    }

    public static double transformY(SEXP y, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, int nullAMode, Ptr dd) {
        double result;
        if (unit__.isUnitArithmetic(y) != 0) {
            result = unit__.transformYArithmetic(y, index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, dd);
        } else if (unit__.isUnitList(y) != 0) {
            int n = unit__.unitLength(y);
            int n2 = index % n;
            result = unit__.transformY(Rinternals.VECTOR_ELT((SEXP)y, (int)n2), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, nullAMode, dd);
        } else {
            int nullamode = nullAMode == 0 ? 4 : nullAMode;
            result = unit__.unitValue(y, index);
            int unit = unit__.unitUnit(y, index);
            SEXP data = unit__.unitData(y, index);
            Rinternals.Rf_protect((SEXP)data);
            double d = vpc.getAlignedDouble(3);
            double d2 = vpc.getAlignedDouble(2);
            result = unit__.transformLocation(result, unit, data, d2, d, gc, heightCM, widthCM, nullLMode, nullamode, dd);
            Rinternals.Rf_unprotect((int)1);
        }
        return result;
    }

    public static double transformX(SEXP x, int index, Ptr vpc, Ptr gc, double widthCM, double heightCM, int nullLMode, int nullAMode, Ptr dd) {
        double result;
        if (unit__.isUnitArithmetic(x) != 0) {
            result = unit__.transformXArithmetic(x, index, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, dd);
        } else if (unit__.isUnitList(x) != 0) {
            int n = unit__.unitLength(x);
            int n2 = index % n;
            result = unit__.transformX(Rinternals.VECTOR_ELT((SEXP)x, (int)n2), 0, vpc.copyOf(32), gc, widthCM, heightCM, nullLMode, nullAMode, dd);
        } else {
            int nullamode = nullAMode == 0 ? 4 : nullAMode;
            result = unit__.unitValue(x, index);
            int unit = unit__.unitUnit(x, index);
            SEXP data = unit__.unitData(x, index);
            Rinternals.Rf_protect((SEXP)data);
            double d = vpc.getAlignedDouble(1);
            double d2 = vpc.getDouble();
            result = unit__.transformLocation(result, unit, data, d2, d, gc, widthCM, heightCM, nullLMode, nullamode, dd);
            Rinternals.Rf_unprotect((int)1);
        }
        return result;
    }

    public static double transformLocation(double location, int unit, SEXP data, double scalemin, double scalemax, Ptr gc, double thisCM, double otherCM, int nullLMode, int nullAMode, Ptr dd) {
        double result = location;
        switch (unit) {
            case 4: {
                double d = result - scalemin;
                double d2 = scalemax - scalemin;
                result = d / d2 * thisCM / 2.54;
                break;
            }
            default: {
                result = unit__.transform(location, unit, data, scalemin, scalemax, gc, thisCM, otherCM, nullLMode, nullAMode, dd);
            }
        }
        return result;
    }

    public static double transform(double value, int unit, SEXP data, double scalemin, double scalemax, Ptr gc, double thisCM, double otherCM, int nullLMode, int nullAMode, Ptr dd) {
        double[] wid = new double[1];
        double[] dsc = new double[1];
        double[] asc = new double[1];
        wid[0] = 0.0;
        dsc[0] = 0.0;
        asc[0] = 0.0;
        double result = value;
        switch (unit) {
            case 0: {
                result = result * thisCM / 2.54;
                break;
            }
            case 1: {
                result /= 2.54;
                break;
            }
            case 2: {
                break;
            }
            case 18: 
            case 104: {
                double d = gc.getDouble(52) * result;
                double d2 = gc.getDouble(44);
                result = d * d2 / 72.0;
                break;
            }
            case 3: 
            case 103: {
                double d = gc.getDouble(52) * result;
                double d3 = gc.getDouble(44);
                double d4 = d * d3;
                double d5 = gc.getDouble(60);
                result = d4 * d5 / 72.0;
                break;
            }
            case 6: {
                if (thisCM <= otherCM) {
                    result = result * thisCM / 2.54;
                    break;
                }
                result = result * otherCM / 2.54;
                break;
            }
            case 7: {
                result = result / 10.0 / 2.54;
                break;
            }
            case 8: {
                result /= 72.27;
                break;
            }
            case 9: {
                result = result * 12.0 / 72.27;
                break;
            }
            case 10: {
                result /= 72.0;
                break;
            }
            case 11: {
                result = result / 1157.0 * 1238.0 / 72.27;
                break;
            }
            case 12: {
                result = result * 12.0 / 1157.0 * 1238.0 / 72.27;
                break;
            }
            case 13: {
                result = result / 65536.0 / 72.27;
                break;
            }
            case 14: 
            case 105: {
                if (Rinternals.Rf_isExpression((SEXP)data)) {
                    result = main_engine__.GEfromDeviceWidth((double)main_plotmath__.GEExpressionWidth((SEXP)Rinternals.VECTOR_ELT((SEXP)data, (int)0), (Ptr)gc, (Ptr)dd), (int)2, (Ptr)dd) * result;
                    break;
                }
                int n = Rinternals.Rf_getCharCE((SEXP)Rinternals.STRING_ELT((SEXP)data, (int)0));
                result = main_engine__.GEfromDeviceWidth((double)main_engine__.GEStrWidth((Ptr)Rinternals.R_CHAR((SEXP)Rinternals.STRING_ELT((SEXP)data, (int)0)), (int)n, (Ptr)gc, (Ptr)dd), (int)2, (Ptr)dd) * result;
                break;
            }
            case 15: 
            case 106: {
                if (Rinternals.Rf_isExpression((SEXP)data)) {
                    result = main_engine__.GEfromDeviceHeight((double)main_plotmath__.GEExpressionHeight((SEXP)Rinternals.VECTOR_ELT((SEXP)data, (int)0), (Ptr)gc, (Ptr)dd), (int)2, (Ptr)dd) * result;
                    break;
                }
                result = main_engine__.GEfromDeviceHeight((double)main_engine__.GEStrHeight((Ptr)Rinternals.R_CHAR((SEXP)Rinternals.STRING_ELT((SEXP)data, (int)0)), (int)-1, (Ptr)gc, (Ptr)dd), (int)2, (Ptr)dd) * result;
                break;
            }
            case 16: {
                if (Rinternals.Rf_isExpression((SEXP)data)) {
                    main_plotmath__.GEExpressionMetric((SEXP)Rinternals.VECTOR_ELT((SEXP)data, (int)0), (Ptr)gc, (Ptr)((Ptr)new DoublePtr(asc, 0)), (Ptr)((Ptr)new DoublePtr(dsc, 0)), (Ptr)((Ptr)new DoublePtr(wid, 0)), (Ptr)dd);
                } else {
                    int n = Rinternals.Rf_getCharCE((SEXP)Rinternals.STRING_ELT((SEXP)data, (int)0));
                    main_engine__.GEStrMetric((Ptr)Rinternals.R_CHAR((SEXP)Rinternals.STRING_ELT((SEXP)data, (int)0)), (int)n, (Ptr)gc, (Ptr)((Ptr)new DoublePtr(asc, 0)), (Ptr)((Ptr)new DoublePtr(dsc, 0)), (Ptr)((Ptr)new DoublePtr(wid, 0)), (Ptr)dd);
                }
                result = main_engine__.GEfromDeviceHeight((double)asc[0], (int)2, (Ptr)dd) * result;
                break;
            }
            case 17: {
                if (Rinternals.Rf_isExpression((SEXP)data)) {
                    main_plotmath__.GEExpressionMetric((SEXP)Rinternals.VECTOR_ELT((SEXP)data, (int)0), (Ptr)gc, (Ptr)((Ptr)new DoublePtr(asc, 0)), (Ptr)((Ptr)new DoublePtr(dsc, 0)), (Ptr)((Ptr)new DoublePtr(wid, 0)), (Ptr)dd);
                } else {
                    int n = Rinternals.Rf_getCharCE((SEXP)Rinternals.STRING_ELT((SEXP)data, (int)0));
                    main_engine__.GEStrMetric((Ptr)Rinternals.R_CHAR((SEXP)Rinternals.STRING_ELT((SEXP)data, (int)0)), (int)n, (Ptr)gc, (Ptr)((Ptr)new DoublePtr(asc, 0)), (Ptr)((Ptr)new DoublePtr(dsc, 0)), (Ptr)((Ptr)new DoublePtr(wid, 0)), (Ptr)dd);
                }
                result = main_engine__.GEfromDeviceHeight((double)dsc[0], (int)2, (Ptr)dd) * result;
                break;
            }
            case 19: {
                result = unit__.evaluateGrobXUnit(value, data, thisCM, otherCM, nullLMode, nullAMode, dd);
                break;
            }
            case 20: {
                result = unit__.evaluateGrobYUnit(value, data, otherCM, thisCM, nullLMode, nullAMode, dd);
                break;
            }
            case 21: {
                result = unit__.evaluateGrobWidthUnit(data, thisCM, otherCM, nullLMode, nullAMode, dd) * value;
                break;
            }
            case 22: {
                result = unit__.evaluateGrobHeightUnit(data, otherCM, thisCM, nullLMode, nullAMode, dd) * value;
                break;
            }
            case 23: {
                result = unit__.evaluateGrobAscentUnit(data, otherCM, thisCM, nullLMode, nullAMode, dd) * value;
                break;
            }
            case 24: {
                result = unit__.evaluateGrobDescentUnit(data, otherCM, thisCM, nullLMode, nullAMode, dd) * value;
                break;
            }
            case 5: {
                result = unit__.evaluateNullUnit(result, thisCM, nullLMode, nullAMode);
                break;
            }
            default: {
                Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("invalid unit or unit not yet implemented\u0000".getBytes(), 0)), (Object[])new Object[0]);
            }
        }
        switch (unit) {
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                result = Rinternals2.REAL((SEXP)state__.gridStateElement(dd, 15)).getDouble() * result;
                break;
            }
        }
        return result;
    }

    public static double evaluateGrobDescentUnit(SEXP grob, double vpheightCM, double vpwidthCM, int nullLMode, int nullAMode, Ptr dd) {
        return unit__.evaluateGrobUnit(1.0, grob, vpheightCM, vpwidthCM, nullLMode, nullAMode, 5, dd);
    }

    public static double evaluateGrobAscentUnit(SEXP grob, double vpheightCM, double vpwidthCM, int nullLMode, int nullAMode, Ptr dd) {
        return unit__.evaluateGrobUnit(1.0, grob, vpheightCM, vpwidthCM, nullLMode, nullAMode, 4, dd);
    }

    public static double evaluateGrobHeightUnit(SEXP grob, double vpheightCM, double vpwidthCM, int nullLMode, int nullAMode, Ptr dd) {
        return unit__.evaluateGrobUnit(1.0, grob, vpheightCM, vpwidthCM, nullLMode, nullAMode, 3, dd);
    }

    public static double evaluateGrobWidthUnit(SEXP grob, double vpheightCM, double vpwidthCM, int nullLMode, int nullAMode, Ptr dd) {
        return unit__.evaluateGrobUnit(1.0, grob, vpheightCM, vpwidthCM, nullLMode, nullAMode, 2, dd);
    }

    public static double evaluateGrobYUnit(double value, SEXP grob, double vpheightCM, double vpwidthCM, int nullLMode, int nullAMode, Ptr dd) {
        return unit__.evaluateGrobUnit(value, grob, vpheightCM, vpwidthCM, nullLMode, nullAMode, 1, dd);
    }

    public static double evaluateGrobXUnit(double value, SEXP grob, double vpheightCM, double vpwidthCM, int nullLMode, int nullAMode, Ptr dd) {
        return unit__.evaluateGrobUnit(value, grob, vpheightCM, vpwidthCM, nullLMode, nullAMode, 0, dd);
    }

    public static double evaluateGrobUnit(double value, SEXP grob, double vpwidthCM, double vpheightCM, int nullLMode, int nullAMode, int evalType, Ptr dd) {
        double[] invt = new double[9];
        double[] lout = new double[3];
        double[] lin = new double[3];
        double[] yy = new double[1];
        double[] xx = new double[1];
        double[] savedTransform = new double[9];
        double[] transform = new double[9];
        MixedPtr gc = MixedPtr.malloc((int)276);
        MixedPtr vpc = MixedPtr.malloc((int)32);
        double[] rotationAngle = new double[1];
        double[] vpHeightCM = new double[1];
        double[] vpWidthCM = new double[1];
        yy[0] = 0.0;
        xx[0] = 0.0;
        rotationAngle[0] = 0.0;
        vpHeightCM[0] = 0.0;
        vpWidthCM[0] = 0.0;
        SEXP evalFnx = Rinternals.R_NilValue;
        SEXP evalFny = Rinternals.R_NilValue;
        SEXP unitx = Rinternals.R_NilValue;
        SEXP unity = Rinternals.R_NilValue;
        double result = 0.0;
        boolean protectedGrob = false;
        int record = dd.getAlignedInt(6);
        dd.setAlignedInt(6, 0);
        SEXP currentvp = state__.gridStateElement(dd, 7);
        grid__.getViewportTransform(currentvp, dd, (Ptr)new DoublePtr(vpWidthCM, 0), (Ptr)new DoublePtr(vpHeightCM, 0), (Ptr)new DoublePtr(savedTransform, 0), (Ptr)new DoublePtr(rotationAngle, 0));
        SEXP savedgpar = state__.gridStateElement(dd, 5);
        Rinternals.Rf_protect((SEXP)savedgpar);
        SEXP savedgrob = state__.gridStateElement(dd, 12);
        Rinternals.Rf_protect((SEXP)savedgrob);
        SEXP R_gridEvalEnv$3 = grid__.R_gridEvalEnv;
        SEXP preFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("preDraw\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$3);
        Rinternals.Rf_protect((SEXP)preFn);
        switch (evalType) {
            case 0: 
            case 1: {
                SEXP R_gridEvalEnv$4 = grid__.R_gridEvalEnv;
                evalFnx = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("xDetails\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$4);
                Rinternals.Rf_protect((SEXP)evalFnx);
                SEXP R_gridEvalEnv$5 = grid__.R_gridEvalEnv;
                evalFny = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("yDetails\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$5);
                Rinternals.Rf_protect((SEXP)evalFny);
                break;
            }
            case 2: {
                SEXP R_gridEvalEnv$6 = grid__.R_gridEvalEnv;
                evalFnx = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("width\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$6);
                Rinternals.Rf_protect((SEXP)evalFnx);
                break;
            }
            case 3: {
                SEXP R_gridEvalEnv$7 = grid__.R_gridEvalEnv;
                evalFny = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("height\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$7);
                Rinternals.Rf_protect((SEXP)evalFny);
                break;
            }
            case 4: {
                SEXP R_gridEvalEnv$8 = grid__.R_gridEvalEnv;
                evalFny = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("ascentDetails\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$8);
                Rinternals.Rf_protect((SEXP)evalFny);
                break;
            }
            case 5: {
                SEXP R_gridEvalEnv$9 = grid__.R_gridEvalEnv;
                evalFny = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("descentDetails\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$9);
                Rinternals.Rf_protect((SEXP)evalFny);
            }
        }
        SEXP R_gridEvalEnv$10 = grid__.R_gridEvalEnv;
        SEXP postFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("postDraw\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$10);
        Rinternals.Rf_protect((SEXP)postFn);
        if (Rinternals.Rf_inherits((SEXP)grob, (BytePtr)new BytePtr("gPath\u0000".getBytes(), 0))) {
            if (Rinternals.Rf_isNull((SEXP)savedgrob)) {
                SEXP R_gridEvalEnv$11 = grid__.R_gridEvalEnv;
                SEXP findGrobFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("findGrobinDL\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$11);
                Rinternals.Rf_protect((SEXP)findGrobFn);
                SEXP sEXP = util__.getListElement(grob, (Ptr)new BytePtr("name\u0000".getBytes(), 0));
                SEXP R_fcall0 = Rinternals.Rf_lang2((SEXP)findGrobFn, (SEXP)sEXP);
                Rinternals.Rf_protect((SEXP)R_fcall0);
                SEXP R_gridEvalEnv$12 = grid__.R_gridEvalEnv;
                grob = Rinternals.Rf_eval((SEXP)R_fcall0, (SEXP)R_gridEvalEnv$12);
                Rinternals.Rf_protect((SEXP)grob);
            } else {
                SEXP R_gridEvalEnv$13 = grid__.R_gridEvalEnv;
                SEXP findGrobFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("findGrobinChildren\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$13);
                Rinternals.Rf_protect((SEXP)findGrobFn);
                SEXP sEXP = util__.getListElement(savedgrob, (Ptr)new BytePtr("children\u0000".getBytes(), 0));
                SEXP sEXP2 = util__.getListElement(grob, (Ptr)new BytePtr("name\u0000".getBytes(), 0));
                SEXP R_fcall0 = Rinternals.Rf_lang3((SEXP)findGrobFn, (SEXP)sEXP2, (SEXP)sEXP);
                Rinternals.Rf_protect((SEXP)R_fcall0);
                SEXP R_gridEvalEnv$14 = grid__.R_gridEvalEnv;
                grob = Rinternals.Rf_eval((SEXP)R_fcall0, (SEXP)R_gridEvalEnv$14);
                Rinternals.Rf_protect((SEXP)grob);
            }
            protectedGrob = true;
        }
        SEXP R_fcall1 = Rinternals.Rf_lang2((SEXP)preFn, (SEXP)grob);
        Rinternals.Rf_protect((SEXP)R_fcall1);
        SEXP R_gridEvalEnv$15 = grid__.R_gridEvalEnv;
        SEXP updatedgrob = Rinternals.Rf_eval((SEXP)R_fcall1, (SEXP)R_gridEvalEnv$15);
        Rinternals.Rf_protect((SEXP)updatedgrob);
        currentvp = state__.gridStateElement(dd, 7);
        SEXP currentgp = state__.gridStateElement(dd, 5);
        grid__.getViewportTransform(currentvp, dd, (Ptr)new DoublePtr(vpWidthCM, 0), (Ptr)new DoublePtr(vpHeightCM, 0), (Ptr)new DoublePtr(transform, 0), (Ptr)new DoublePtr(rotationAngle, 0));
        viewport__.fillViewportContextFromViewport(currentvp, (Ptr)vpc);
        switch (evalType) {
            case 0: 
            case 1: {
                SEXP val = Rinternals.Rf_ScalarReal((double)value);
                Rinternals.Rf_protect((SEXP)val);
                SEXP R_fcall2x = Rinternals.Rf_lang3((SEXP)evalFnx, (SEXP)updatedgrob, (SEXP)val);
                Rinternals.Rf_protect((SEXP)R_fcall2x);
                SEXP R_gridEvalEnv$16 = grid__.R_gridEvalEnv;
                unitx = Rinternals.Rf_eval((SEXP)R_fcall2x, (SEXP)R_gridEvalEnv$16);
                Rinternals.Rf_protect((SEXP)unitx);
                SEXP R_fcall2y = Rinternals.Rf_lang3((SEXP)evalFny, (SEXP)updatedgrob, (SEXP)val);
                Rinternals.Rf_protect((SEXP)R_fcall2y);
                SEXP R_gridEvalEnv$17 = grid__.R_gridEvalEnv;
                unity = Rinternals.Rf_eval((SEXP)R_fcall2y, (SEXP)R_gridEvalEnv$17);
                Rinternals.Rf_protect((SEXP)unity);
                break;
            }
            case 2: {
                SEXP R_fcall2x = Rinternals.Rf_lang2((SEXP)evalFnx, (SEXP)updatedgrob);
                Rinternals.Rf_protect((SEXP)R_fcall2x);
                SEXP R_gridEvalEnv$18 = grid__.R_gridEvalEnv;
                unitx = Rinternals.Rf_eval((SEXP)R_fcall2x, (SEXP)R_gridEvalEnv$18);
                Rinternals.Rf_protect((SEXP)unitx);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                SEXP R_fcall2y = Rinternals.Rf_lang2((SEXP)evalFny, (SEXP)updatedgrob);
                Rinternals.Rf_protect((SEXP)R_fcall2y);
                SEXP R_gridEvalEnv$19 = grid__.R_gridEvalEnv;
                unity = Rinternals.Rf_eval((SEXP)R_fcall2y, (SEXP)R_gridEvalEnv$19);
                Rinternals.Rf_protect((SEXP)unity);
            }
        }
        gpar__.gcontextFromgpar(currentgp, 0, (Ptr)gc, dd);
        switch (evalType) {
            case 0: 
            case 1: {
                double yy$27;
                double xx$26;
                if (evalType != 0 && unit__.pureNullUnit(unity, 0, dd) != 0) {
                    double vpWidthCM$20 = vpWidthCM[0];
                    result = unit__.evaluateNullUnit(unit__.pureNullUnitValue(unity, 0), vpWidthCM$20, nullLMode, nullAMode);
                    break;
                }
                if (unit__.pureNullUnit(unitx, 0, dd) != 0) {
                    double vpWidthCM$21 = vpWidthCM[0];
                    result = unit__.evaluateNullUnit(unit__.pureNullUnitValue(unitx, 0), vpWidthCM$21, nullLMode, nullAMode);
                    break;
                }
                matrix__.invTransform((Ptr)new DoublePtr(savedTransform, 0), (Ptr)new DoublePtr(invt, 0));
                double vpHeightCM$22 = vpHeightCM[0];
                double vpWidthCM$23 = vpWidthCM[0];
                unit__.transformLocn(unitx, unity, 0, vpc.copyOf(32), (Ptr)gc, vpWidthCM$23, vpHeightCM$22, dd, (Ptr)new DoublePtr(transform, 0), (Ptr)new DoublePtr(xx, 0), (Ptr)new DoublePtr(yy, 0));
                double yy$24 = yy[0];
                matrix__.location(xx[0], yy$24, (Ptr)new DoublePtr(lin, 0));
                matrix__.trans((Ptr)new DoublePtr(lin, 0), (Ptr)new DoublePtr(invt, 0), (Ptr)new DoublePtr(lout, 0));
                xx[0] = xx$26 = matrix__.locationX((Ptr)new DoublePtr(lout, 0));
                yy[0] = yy$27 = matrix__.locationY((Ptr)new DoublePtr(lout, 0));
                if (evalType != 0) {
                    result = yy[0];
                    break;
                }
                result = xx[0];
                break;
            }
            case 2: {
                if (unit__.pureNullUnit(unitx, 0, dd) != 0) {
                    double vpWidthCM$28 = vpWidthCM[0];
                    result = unit__.evaluateNullUnit(unit__.pureNullUnitValue(unitx, 0), vpWidthCM$28, nullLMode, nullAMode);
                    break;
                }
                double vpHeightCM$29 = vpHeightCM[0];
                double vpWidthCM$30 = vpWidthCM[0];
                result = unit__.transformWidthtoINCHES(unitx, 0, vpc.copyOf(32), (Ptr)gc, vpWidthCM$30, vpHeightCM$29, dd);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (unit__.pureNullUnit(unity, 0, dd) != 0) {
                    double vpWidthCM$31 = vpWidthCM[0];
                    result = unit__.evaluateNullUnit(unit__.pureNullUnitValue(unity, 0), vpWidthCM$31, nullLMode, nullAMode);
                    break;
                }
                double vpHeightCM$32 = vpHeightCM[0];
                double vpWidthCM$33 = vpWidthCM[0];
                result = unit__.transformHeighttoINCHES(unity, 0, vpc.copyOf(32), (Ptr)gc, vpWidthCM$33, vpHeightCM$32, dd);
            }
        }
        SEXP R_fcall3 = Rinternals.Rf_lang2((SEXP)postFn, (SEXP)updatedgrob);
        Rinternals.Rf_protect((SEXP)R_fcall3);
        SEXP R_gridEvalEnv$34 = grid__.R_gridEvalEnv;
        Rinternals.Rf_eval((SEXP)R_fcall3, (SEXP)R_gridEvalEnv$34);
        state__.setGridStateElement(dd, 5, savedgpar);
        state__.setGridStateElement(dd, 12, savedgrob);
        if (protectedGrob) {
            Rinternals.Rf_unprotect((int)3);
        }
        switch (evalType) {
            case 0: 
            case 1: {
                Rinternals.Rf_unprotect((int)14);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Rinternals.Rf_unprotect((int)10);
            }
        }
        dd.setAlignedInt(6, record);
        return result;
    }

    public static int pureNullUnitArithmetic(SEXP unit, int index, Ptr dd) {
        int n = 0;
        int result = 0;
        if (unit__.addOp(unit) != 0 || unit__.minusOp(unit) != 0) {
            int iftmp$35 = unit__.pureNullUnit(unit__.arg1(unit), index, dd) != 0 && unit__.pureNullUnit(unit__.arg2(unit), index, dd) != 0 ? 1 : 0;
            result = iftmp$35;
        } else if (unit__.timesOp(unit) != 0) {
            result = unit__.pureNullUnit(unit__.arg2(unit), index, dd);
        } else if (unit__.minFunc(unit) != 0 || unit__.maxFunc(unit) != 0 || unit__.sumFunc(unit) != 0) {
            n = unit__.unitLength(unit__.arg1(unit));
            int i = 0;
            result = 1;
            while (result != 0 && i < n) {
                int iftmp$36 = result != 0 && unit__.pureNullUnit(unit__.arg1(unit), i, dd) != 0 ? 1 : 0;
                result = iftmp$36;
                ++i;
            }
        } else {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("unimplemented unit function\u0000".getBytes(), 0)), (Object[])new Object[0]);
        }
        return result;
    }

    public static int pureNullUnit(SEXP unit, int index, Ptr dd) {
        int result;
        if (unit__.isUnitArithmetic(unit) != 0) {
            result = unit__.pureNullUnitArithmetic(unit, index, dd);
        } else if (unit__.isUnitList(unit) != 0) {
            int n = unit__.unitLength(unit);
            int n2 = index % n;
            result = unit__.pureNullUnit(Rinternals.VECTOR_ELT((SEXP)unit, (int)n2), 0, dd);
        } else if (unit__.unitUnit(unit, index) == 21) {
            SEXP grob = unit__.unitData(unit, index);
            Rinternals.Rf_protect((SEXP)grob);
            SEXP savedgpar = state__.gridStateElement(dd, 5);
            Rinternals.Rf_protect((SEXP)savedgpar);
            SEXP savedgrob = state__.gridStateElement(dd, 12);
            Rinternals.Rf_protect((SEXP)savedgrob);
            SEXP R_gridEvalEnv$37 = grid__.R_gridEvalEnv;
            SEXP widthPreFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("preDraw\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$37);
            Rinternals.Rf_protect((SEXP)widthPreFn);
            SEXP R_gridEvalEnv$38 = grid__.R_gridEvalEnv;
            SEXP widthFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("width\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$38);
            Rinternals.Rf_protect((SEXP)widthFn);
            SEXP R_gridEvalEnv$39 = grid__.R_gridEvalEnv;
            SEXP widthPostFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("postDraw\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$39);
            Rinternals.Rf_protect((SEXP)widthPostFn);
            if (Rinternals.Rf_inherits((SEXP)grob, (BytePtr)new BytePtr("gPath\u0000".getBytes(), 0))) {
                if (Rinternals.Rf_isNull((SEXP)savedgrob)) {
                    SEXP R_gridEvalEnv$40 = grid__.R_gridEvalEnv;
                    SEXP findGrobFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("findGrobinDL\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$40);
                    Rinternals.Rf_protect((SEXP)findGrobFn);
                    SEXP sEXP = util__.getListElement(grob, (Ptr)new BytePtr("name\u0000".getBytes(), 0));
                    SEXP R_fcall0 = Rinternals.Rf_lang2((SEXP)findGrobFn, (SEXP)sEXP);
                    Rinternals.Rf_protect((SEXP)R_fcall0);
                    SEXP R_gridEvalEnv$41 = grid__.R_gridEvalEnv;
                    grob = Rinternals.Rf_eval((SEXP)R_fcall0, (SEXP)R_gridEvalEnv$41);
                } else {
                    SEXP R_gridEvalEnv$42 = grid__.R_gridEvalEnv;
                    SEXP findGrobFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("findGrobinChildren\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$42);
                    Rinternals.Rf_protect((SEXP)findGrobFn);
                    SEXP sEXP = util__.getListElement(savedgrob, (Ptr)new BytePtr("children\u0000".getBytes(), 0));
                    SEXP sEXP2 = util__.getListElement(grob, (Ptr)new BytePtr("name\u0000".getBytes(), 0));
                    SEXP R_fcall0 = Rinternals.Rf_lang3((SEXP)findGrobFn, (SEXP)sEXP2, (SEXP)sEXP);
                    Rinternals.Rf_protect((SEXP)R_fcall0);
                    SEXP R_gridEvalEnv$43 = grid__.R_gridEvalEnv;
                    grob = Rinternals.Rf_eval((SEXP)R_fcall0, (SEXP)R_gridEvalEnv$43);
                }
                Rinternals.Rf_unprotect((int)2);
            }
            SEXP R_fcall1 = Rinternals.Rf_lang2((SEXP)widthPreFn, (SEXP)grob);
            Rinternals.Rf_protect((SEXP)R_fcall1);
            SEXP R_gridEvalEnv$44 = grid__.R_gridEvalEnv;
            SEXP updatedgrob = Rinternals.Rf_eval((SEXP)R_fcall1, (SEXP)R_gridEvalEnv$44);
            Rinternals.Rf_protect((SEXP)updatedgrob);
            SEXP R_fcall2 = Rinternals.Rf_lang2((SEXP)widthFn, (SEXP)updatedgrob);
            Rinternals.Rf_protect((SEXP)R_fcall2);
            SEXP R_gridEvalEnv$45 = grid__.R_gridEvalEnv;
            SEXP width = Rinternals.Rf_eval((SEXP)R_fcall2, (SEXP)R_gridEvalEnv$45);
            Rinternals.Rf_protect((SEXP)width);
            result = unit__.pureNullUnit(width, 0, dd);
            SEXP R_fcall3 = Rinternals.Rf_lang2((SEXP)widthPostFn, (SEXP)updatedgrob);
            Rinternals.Rf_protect((SEXP)R_fcall3);
            SEXP R_gridEvalEnv$46 = grid__.R_gridEvalEnv;
            Rinternals.Rf_eval((SEXP)R_fcall3, (SEXP)R_gridEvalEnv$46);
            state__.setGridStateElement(dd, 5, savedgpar);
            state__.setGridStateElement(dd, 12, savedgrob);
            Rinternals.Rf_unprotect((int)11);
        } else if (unit__.unitUnit(unit, index) == 22) {
            SEXP grob = unit__.unitData(unit, index);
            Rinternals.Rf_protect((SEXP)grob);
            SEXP savedgpar = state__.gridStateElement(dd, 5);
            Rinternals.Rf_protect((SEXP)savedgpar);
            SEXP savedgrob = state__.gridStateElement(dd, 12);
            Rinternals.Rf_protect((SEXP)savedgrob);
            SEXP R_gridEvalEnv$47 = grid__.R_gridEvalEnv;
            SEXP heightPreFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("preDraw\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$47);
            Rinternals.Rf_protect((SEXP)heightPreFn);
            SEXP R_gridEvalEnv$48 = grid__.R_gridEvalEnv;
            SEXP heightFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("height\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$48);
            Rinternals.Rf_protect((SEXP)heightFn);
            SEXP R_gridEvalEnv$49 = grid__.R_gridEvalEnv;
            SEXP heightPostFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("postDraw\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$49);
            Rinternals.Rf_protect((SEXP)heightPostFn);
            if (Rinternals.Rf_inherits((SEXP)grob, (BytePtr)new BytePtr("gPath\u0000".getBytes(), 0))) {
                if (Rinternals.Rf_isNull((SEXP)savedgrob)) {
                    SEXP R_gridEvalEnv$50 = grid__.R_gridEvalEnv;
                    SEXP findGrobFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("findGrobinDL\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$50);
                    Rinternals.Rf_protect((SEXP)findGrobFn);
                    SEXP sEXP = util__.getListElement(grob, (Ptr)new BytePtr("name\u0000".getBytes(), 0));
                    SEXP R_fcall0 = Rinternals.Rf_lang2((SEXP)findGrobFn, (SEXP)sEXP);
                    Rinternals.Rf_protect((SEXP)R_fcall0);
                    SEXP R_gridEvalEnv$51 = grid__.R_gridEvalEnv;
                    grob = Rinternals.Rf_eval((SEXP)R_fcall0, (SEXP)R_gridEvalEnv$51);
                } else {
                    SEXP R_gridEvalEnv$52 = grid__.R_gridEvalEnv;
                    SEXP findGrobFn = Rinternals.Rf_findFun((SEXP)Rinternals.Rf_install((BytePtr)new BytePtr("findGrobinChildren\u0000".getBytes(), 0)), (SEXP)R_gridEvalEnv$52);
                    Rinternals.Rf_protect((SEXP)findGrobFn);
                    SEXP sEXP = util__.getListElement(savedgrob, (Ptr)new BytePtr("children\u0000".getBytes(), 0));
                    SEXP sEXP3 = util__.getListElement(grob, (Ptr)new BytePtr("name\u0000".getBytes(), 0));
                    SEXP R_fcall0 = Rinternals.Rf_lang3((SEXP)findGrobFn, (SEXP)sEXP3, (SEXP)sEXP);
                    Rinternals.Rf_protect((SEXP)R_fcall0);
                    SEXP R_gridEvalEnv$53 = grid__.R_gridEvalEnv;
                    grob = Rinternals.Rf_eval((SEXP)R_fcall0, (SEXP)R_gridEvalEnv$53);
                }
                Rinternals.Rf_unprotect((int)2);
            }
            SEXP R_fcall1 = Rinternals.Rf_lang2((SEXP)heightPreFn, (SEXP)grob);
            Rinternals.Rf_protect((SEXP)R_fcall1);
            SEXP R_gridEvalEnv$54 = grid__.R_gridEvalEnv;
            SEXP updatedgrob = Rinternals.Rf_eval((SEXP)R_fcall1, (SEXP)R_gridEvalEnv$54);
            Rinternals.Rf_protect((SEXP)updatedgrob);
            SEXP R_fcall2 = Rinternals.Rf_lang2((SEXP)heightFn, (SEXP)updatedgrob);
            Rinternals.Rf_protect((SEXP)R_fcall2);
            SEXP R_gridEvalEnv$55 = grid__.R_gridEvalEnv;
            SEXP height = Rinternals.Rf_eval((SEXP)R_fcall2, (SEXP)R_gridEvalEnv$55);
            Rinternals.Rf_protect((SEXP)height);
            result = unit__.pureNullUnit(height, 0, dd);
            SEXP R_fcall3 = Rinternals.Rf_lang2((SEXP)heightPostFn, (SEXP)updatedgrob);
            Rinternals.Rf_protect((SEXP)R_fcall3);
            SEXP R_gridEvalEnv$56 = grid__.R_gridEvalEnv;
            Rinternals.Rf_eval((SEXP)R_fcall3, (SEXP)R_gridEvalEnv$56);
            state__.setGridStateElement(dd, 5, savedgpar);
            state__.setGridStateElement(dd, 12, savedgrob);
            Rinternals.Rf_unprotect((int)11);
        } else {
            result = unit__.unitUnit(unit, index) != 5 ? 0 : 1;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static double pureNullUnitValue(SEXP unit, int index) {
        n = 0;
        n = 0;
        n = 0;
        result = 0.0;
        result = 0.0;
        if (unit__.isUnitArithmetic(unit) == 0) ** GOTO lbl60
        if (unit__.addOp(unit) != 0) {
            var56_6 = unit__.pureNullUnitValue(unit__.arg1(unit), index);
            var53_7 = unit__.pureNullUnitValue(unit__.arg2(unit), index);
            result = var56_6 + var53_7;
        } else if (unit__.minusOp(unit) != 0) {
            var49_8 = unit__.pureNullUnitValue(unit__.arg1(unit), index);
            var46_9 = unit__.pureNullUnitValue(unit__.arg2(unit), index);
            result = var49_8 - var46_9;
        } else if (unit__.timesOp(unit) != 0) {
            var42_10 = Rinternals2.REAL((SEXP)unit__.arg1(unit));
            var40_11 = index * 8;
            var38_12 = var42_10;
            var39_13 = 0 + var40_11;
            var36_14 = var38_12.getDouble(var39_13);
            var33_15 = unit__.pureNullUnitValue(unit__.arg2(unit), index);
            result = var36_14 * var33_15;
        } else if (unit__.minFunc(unit) != 0) {
            n = unit__.unitLength(unit__.arg1(unit));
            temp = 1.7976931348623157E308;
            result = unit__.pureNullUnitValue(unit__.arg1(unit), 0);
            i = 1;
            while (i < n) {
                temp = unit__.pureNullUnitValue(unit__.arg1(unit), i);
                if (temp < result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.maxFunc(unit) != 0) {
            n = unit__.unitLength(unit__.arg1(unit));
            temp = 2.2250738585072014E-308;
            result = unit__.pureNullUnitValue(unit__.arg1(unit), 0);
            i = 1;
            while (i < n) {
                temp = unit__.pureNullUnitValue(unit__.arg1(unit), i);
                if (temp > result) {
                    result = temp;
                }
                ++i;
            }
        } else if (unit__.sumFunc(unit) != 0) {
            n = unit__.unitLength(unit__.arg1(unit));
            result = 0.0;
            i = 0;
            while (i < n) {
                result = unit__.pureNullUnitValue(unit__.arg1(unit), i) + result;
                ++i;
            }
        } else {
            Error.Rf_error((BytePtr)GetText.dgettext((BytePtr)new BytePtr("grid\u0000".getBytes(), 0), (BytePtr)new BytePtr("unimplemented unit function\u0000".getBytes(), 0)), (Object[])new Object[0]);
lbl60:
            // 2 sources

            if (unit__.isUnitList(unit) != 0) {
                n = unit__.unitLength(unit);
                var16_22 = index % n;
                result = unit__.pureNullUnitValue(Rinternals.VECTOR_ELT((SEXP)unit, (int)var16_22), 0);
            } else {
                result = unit__.unitValue(unit, index);
            }
        }
        return result;
    }

    public static double evaluateNullUnit(double value, double thisCM, int nullLayoutMode, int nullArithmeticMode) {
        double result = value;
        if (nullLayoutMode == 0) {
            switch (nullArithmeticMode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    result = 0.0;
                    break;
                }
                case 7: {
                    result = 0.0;
                    break;
                }
                case 5: {
                    result = 0.0;
                    break;
                }
                case 6: {
                    result = thisCM;
                }
            }
        }
        return result;
    }

    public static int unitLength(SEXP u) {
        int result = 0;
        if (unit__.isUnitList(u) != 0) {
            result = Rinternals.LENGTH((SEXP)u);
        } else if (unit__.isUnitArithmetic(u) != 0) {
            if (unit__.fOp(u) != 0) {
                if (unit__.timesOp(u) != 0) {
                    int n1 = Rinternals.LENGTH((SEXP)unit__.arg1(u));
                    result = Math.max(unit__.unitLength(unit__.arg2(u)), n1);
                } else {
                    int n1 = unit__.unitLength(unit__.arg1(u));
                    result = Math.max(unit__.unitLength(unit__.arg2(u)), n1);
                }
            } else {
                result = 1;
            }
        } else {
            result = Rinternals.LENGTH((SEXP)u);
        }
        return result;
    }

    public static int sumFunc(SEXP ua) {
        return unit__.fNameMatch(ua, (Ptr)new BytePtr("sum\u0000".getBytes(), 0));
    }

    public static int maxFunc(SEXP ua) {
        return unit__.fNameMatch(ua, (Ptr)new BytePtr("max\u0000".getBytes(), 0));
    }

    public static int minFunc(SEXP ua) {
        return unit__.fNameMatch(ua, (Ptr)new BytePtr("min\u0000".getBytes(), 0));
    }

    public static int fOp(SEXP ua) {
        int iftmp$58 = unit__.addOp(ua) != 0 || unit__.minusOp(ua) != 0 || unit__.timesOp(ua) != 0 ? 1 : 0;
        return iftmp$58;
    }

    public static int timesOp(SEXP ua) {
        return unit__.fNameMatch(ua, (Ptr)new BytePtr("*\u0000".getBytes(), 0));
    }

    public static int minusOp(SEXP ua) {
        return unit__.fNameMatch(ua, (Ptr)new BytePtr("-\u0000".getBytes(), 0));
    }

    public static int addOp(SEXP ua) {
        return unit__.fNameMatch(ua, (Ptr)new BytePtr("+\u0000".getBytes(), 0));
    }

    public static int fNameMatch(SEXP ua, Ptr aString) {
        return Stdlib.strcmp((Ptr)unit__.fName(ua), (Ptr)aString) != 0 ? 0 : 1;
    }

    public static SEXP arg2(SEXP ua) {
        return util__.getListElement(ua, (Ptr)new BytePtr("arg2\u0000".getBytes(), 0));
    }

    public static SEXP arg1(SEXP ua) {
        return util__.getListElement(ua, (Ptr)new BytePtr("arg1\u0000".getBytes(), 0));
    }

    public static Ptr fName(SEXP ua) {
        return Rinternals.R_CHAR((SEXP)Rinternals.STRING_ELT((SEXP)util__.getListElement(ua, (Ptr)new BytePtr("fname\u0000".getBytes(), 0)), (int)0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SEXP unitData(SEXP unit, int index) {
        SEXP result;
        SEXP sEXP = Rinternals.Rf_install((BytePtr)new BytePtr("data\u0000".getBytes(), 0));
        SEXP data = Rinternals.Rf_getAttrib((SEXP)unit, (SEXP)sEXP);
        if (Rinternals.Rf_isNull((SEXP)data)) {
            result = Rinternals.R_NilValue;
            return result;
        } else if (Rinternals.TYPEOF((SEXP)data) == 19) {
            int n = Rinternals.LENGTH((SEXP)data);
            int n2 = index % n;
            result = Rinternals.VECTOR_ELT((SEXP)data, (int)n2);
            return result;
        } else {
            Error.Rf_warning((BytePtr)new BytePtr("unit attribute 'data' is of incorrect type\u0000".getBytes(), 0), (Object[])new Object[0]);
            return Rinternals.R_NilValue;
        }
    }

    public static int unitUnit(SEXP unit, int index) {
        SEXP sEXP = Rinternals.Rf_install((BytePtr)new BytePtr("valid.unit\u0000".getBytes(), 0));
        SEXP units = Rinternals.Rf_getAttrib((SEXP)unit, (SEXP)sEXP);
        int n = Rinternals.LENGTH((SEXP)units);
        Ptr ptr = Rinternals2.INTEGER((SEXP)units);
        int n2 = index % n * 4;
        Ptr ptr2 = ptr;
        int n3 = 0 + n2;
        return ptr2.getInt(n3);
    }

    public static double unitValue(SEXP unit, int index) {
        int n = Rinternals.LENGTH((SEXP)unit);
        int n2 = index % n;
        return util__.numeric(unit, n2);
    }

    public static SEXP unit(double value, int unit) {
        SEXP u = Rinternals.Rf_ScalarReal((double)value);
        Rinternals.Rf_protect((SEXP)u);
        SEXP units = Rinternals.Rf_ScalarInteger((int)unit);
        Rinternals.Rf_protect((SEXP)units);
        SEXP sEXP = Rinternals.Rf_install((BytePtr)new BytePtr("valid.unit\u0000".getBytes(), 0));
        Rinternals.Rf_setAttrib((SEXP)u, (SEXP)sEXP, (SEXP)units);
        SEXP R_NilValue$59 = Rinternals.R_NilValue;
        SEXP sEXP2 = Rinternals.Rf_install((BytePtr)new BytePtr("data\u0000".getBytes(), 0));
        Rinternals.Rf_setAttrib((SEXP)u, (SEXP)sEXP2, (SEXP)R_NilValue$59);
        SEXP classname = Rinternals.Rf_mkString((Ptr)((Ptr)new BytePtr("unit\u0000".getBytes(), 0)));
        Rinternals.Rf_protect((SEXP)classname);
        u = Rinternals.Rf_classgets((SEXP)u, (SEXP)classname);
        Rinternals.Rf_unprotect((int)3);
        return u;
    }

    public static int isUnitList(SEXP ul) {
        return Rinternals.Rf_inherits((SEXP)ul, (BytePtr)new BytePtr("unit.list\u0000".getBytes(), 0)) ? 1 : 0;
    }

    public static int isUnitArithmetic(SEXP ua) {
        return Rinternals.Rf_inherits((SEXP)ua, (BytePtr)new BytePtr("unit.arithmetic\u0000".getBytes(), 0)) ? 1 : 0;
    }

    static {
        unit__.UnitTable$$clinit();
    }

    static void UnitTable$$clinit() {
        MixedPtr mixedPtr = MixedPtr.malloc((int)344);
        mixedPtr.setPointer((Ptr)new BytePtr("npc\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(1, 0);
        mixedPtr.setAlignedPointer(2, (Ptr)new BytePtr("cm\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(3, 1);
        mixedPtr.setAlignedPointer(4, (Ptr)new BytePtr("inches\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(5, 2);
        mixedPtr.setAlignedPointer(6, (Ptr)new BytePtr("lines\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(7, 3);
        mixedPtr.setAlignedPointer(8, (Ptr)new BytePtr("native\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(9, 4);
        mixedPtr.setAlignedPointer(10, (Ptr)new BytePtr("null\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(11, 5);
        mixedPtr.setAlignedPointer(12, (Ptr)new BytePtr("snpc\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(13, 6);
        mixedPtr.setAlignedPointer(14, (Ptr)new BytePtr("mm\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(15, 7);
        mixedPtr.setAlignedPointer(16, (Ptr)new BytePtr("points\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(17, 8);
        mixedPtr.setAlignedPointer(18, (Ptr)new BytePtr("picas\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(19, 9);
        mixedPtr.setAlignedPointer(20, (Ptr)new BytePtr("bigpts\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(21, 10);
        mixedPtr.setAlignedPointer(22, (Ptr)new BytePtr("dida\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(23, 11);
        mixedPtr.setAlignedPointer(24, (Ptr)new BytePtr("cicero\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(25, 12);
        mixedPtr.setAlignedPointer(26, (Ptr)new BytePtr("scaledpts\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(27, 13);
        mixedPtr.setAlignedPointer(28, (Ptr)new BytePtr("strwidth\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(29, 14);
        mixedPtr.setAlignedPointer(30, (Ptr)new BytePtr("strheight\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(31, 15);
        mixedPtr.setAlignedPointer(32, (Ptr)new BytePtr("strascent\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(33, 16);
        mixedPtr.setAlignedPointer(34, (Ptr)new BytePtr("strdescent\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(35, 17);
        mixedPtr.setAlignedPointer(36, (Ptr)new BytePtr("char\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(37, 18);
        mixedPtr.setAlignedPointer(38, (Ptr)new BytePtr("grobx\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(39, 19);
        mixedPtr.setAlignedPointer(40, (Ptr)new BytePtr("groby\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(41, 20);
        mixedPtr.setAlignedPointer(42, (Ptr)new BytePtr("grobwidth\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(43, 21);
        mixedPtr.setAlignedPointer(44, (Ptr)new BytePtr("grobheight\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(45, 22);
        mixedPtr.setAlignedPointer(46, (Ptr)new BytePtr("grobascent\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(47, 23);
        mixedPtr.setAlignedPointer(48, (Ptr)new BytePtr("grobdescent\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(49, 24);
        mixedPtr.setAlignedPointer(50, (Ptr)new BytePtr("mylines\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(51, 103);
        mixedPtr.setAlignedPointer(52, (Ptr)new BytePtr("mychar\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(53, 104);
        mixedPtr.setAlignedPointer(54, (Ptr)new BytePtr("mystrwidth\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(55, 105);
        mixedPtr.setAlignedPointer(56, (Ptr)new BytePtr("mystrheight\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(57, 106);
        mixedPtr.setAlignedPointer(58, (Ptr)new BytePtr("centimetre\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(59, 1001);
        mixedPtr.setAlignedPointer(60, (Ptr)new BytePtr("centimetres\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(61, 1001);
        mixedPtr.setAlignedPointer(62, (Ptr)new BytePtr("centimeter\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(63, 1001);
        mixedPtr.setAlignedPointer(64, (Ptr)new BytePtr("centimeters\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(65, 1001);
        mixedPtr.setAlignedPointer(66, (Ptr)new BytePtr("in\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(67, 1002);
        mixedPtr.setAlignedPointer(68, (Ptr)new BytePtr("inch\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(69, 1002);
        mixedPtr.setAlignedPointer(70, (Ptr)new BytePtr("line\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(71, 1003);
        mixedPtr.setAlignedPointer(72, (Ptr)new BytePtr("millimetre\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(73, 1007);
        mixedPtr.setAlignedPointer(74, (Ptr)new BytePtr("millimetres\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(75, 1007);
        mixedPtr.setAlignedPointer(76, (Ptr)new BytePtr("millimeter\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(77, 1007);
        mixedPtr.setAlignedPointer(78, (Ptr)new BytePtr("millimeters\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(79, 1007);
        mixedPtr.setAlignedPointer(80, (Ptr)new BytePtr("point\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(81, 1008);
        mixedPtr.setAlignedPointer(82, (Ptr)new BytePtr("pt\u0000".getBytes(), 0));
        mixedPtr.setAlignedInt(83, 1008);
        mixedPtr.setAlignedPointer(84, BytePtr.of((int)0));
        mixedPtr.setAlignedInt(85, -1);
        UnitTable.memcpy((Ptr)mixedPtr, 344);
    }
}

