/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.util.Arrays;
import org.renjin.gnur.api.GnuCharSexp;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.StringVector;

public class GnuStringVector
extends StringVector {
    private GnuCharSexp[] values;

    public GnuStringVector(String string) {
        this(GnuCharSexp.valueOf(string));
    }

    public GnuStringVector(GnuCharSexp ... values) {
        this(values, AttributeMap.EMPTY);
    }

    public GnuStringVector(GnuCharSexp[] values, AttributeMap attributes) {
        super(attributes);
        this.values = values;
    }

    public static GnuStringVector copyOf(StringVector vector) {
        if (vector instanceof GnuStringVector) {
            return new GnuStringVector(Arrays.copyOf(((GnuStringVector)vector).values, vector.length()));
        }
        GnuCharSexp[] values = new GnuCharSexp[vector.length()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = GnuCharSexp.valueOf(vector.getElementAsString(i));
        }
        return new GnuStringVector(values);
    }

    public int length() {
        return this.values.length;
    }

    protected StringVector cloneWithNewAttributes(AttributeMap attributes) {
        return new GnuStringVector(this.values, attributes);
    }

    public String getElementAsString(int index) {
        GnuCharSexp value = this.values[index];
        if (value == GnuCharSexp.NA_STRING) {
            return null;
        }
        return value.getValue().nullTerminatedString();
    }

    public boolean isElementNA(int index) {
        return this.values[index] == null;
    }

    public boolean isConstantAccessTime() {
        return true;
    }

    public void set(int index, GnuCharSexp charValue) {
        this.values[index] = charValue;
    }

    public GnuCharSexp getElementAsCharSexp(int index) {
        return this.values[index];
    }
}

