/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.lang.invoke.MethodHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.FinalizationClosure;
import org.renjin.eval.FinalizationHandler;
import org.renjin.eval.Options;
import org.renjin.gcc.annotations.GlobalVar;
import org.renjin.gcc.annotations.Noop;
import org.renjin.gcc.format.FormatArrayInput;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.PointerPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.gnur.api.GnuCharSexp;
import org.renjin.gnur.api.GnuStringVector;
import org.renjin.gnur.api.UnimplementedGnuApiMethod;
import org.renjin.gnur.api.annotations.Allocator;
import org.renjin.gnur.api.annotations.Mutee;
import org.renjin.gnur.api.annotations.PotentialMutator;
import org.renjin.methods.MethodDispatch;
import org.renjin.methods.Methods;
import org.renjin.primitives.Environments;
import org.renjin.primitives.Identical;
import org.renjin.primitives.Native;
import org.renjin.primitives.R;
import org.renjin.primitives.Sort;
import org.renjin.primitives.Types;
import org.renjin.primitives.Vectors;
import org.renjin.primitives.Warning;
import org.renjin.primitives.match.Duplicates;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.primitives.packaging.Namespaces;
import org.renjin.primitives.subset.Subsetting;
import org.renjin.primitives.vector.RowNamesVector;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.CHARSEXP;
import org.renjin.sexp.Closure;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.Promise;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpType;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public final class Rinternals {
    @Deprecated
    public static SEXP R_GlobalEnv;
    public static SEXP R_EmptyEnv;
    @Deprecated
    public static SEXP R_BaseEnv;
    @Deprecated
    public static SEXP R_BaseNamespace;
    @Deprecated
    public static SEXP R_NamespaceRegistry;
    public static SEXP R_Srcref;
    public static final SEXP R_NilValue;
    public static final SEXP R_UnboundValue;
    public static final SEXP R_MissingArg;
    public static SEXP R_RestartToken;
    public static final SEXP R_baseSymbol;
    public static final SEXP R_BaseSymbol;
    public static final SEXP R_BraceSymbol;
    public static final SEXP R_Bracket2Symbol;
    public static final SEXP R_BracketSymbol;
    public static final SEXP R_ClassSymbol;
    public static final SEXP R_DeviceSymbol;
    public static final SEXP R_DimNamesSymbol;
    public static final SEXP R_DimSymbol;
    public static final SEXP R_DollarSymbol;
    public static final SEXP R_DotsSymbol;
    public static final SEXP R_DoubleColonSymbol;
    public static final SEXP R_DropSymbol;
    public static final SEXP R_LastvalueSymbol;
    public static final SEXP R_LevelsSymbol;
    public static final SEXP R_ModeSymbol;
    public static final SEXP R_NaRmSymbol;
    public static final SEXP R_NameSymbol;
    public static final SEXP R_NamesSymbol;
    public static final SEXP R_NamespaceEnvSymbol;
    public static final SEXP R_PackageSymbol;
    public static final SEXP R_PreviousSymbol;
    public static final SEXP R_QuoteSymbol;
    public static final SEXP R_RowNamesSymbol;
    public static final SEXP R_SeedsSymbol;
    public static final SEXP R_SortListSymbol;
    public static final SEXP R_SourceSymbol;
    public static final SEXP R_SpecSymbol;
    public static final SEXP R_TripleColonSymbol;
    public static final SEXP R_TspSymbol;
    public static final SEXP R_dot_defined;
    public static final SEXP R_dot_Method;
    public static final SEXP R_dot_packageName;
    public static final SEXP R_dot_target;
    public static final SEXP R_NaString;
    public static final SEXP R_BlankString;
    public static final SEXP R_BlankScalarString;
    public static final int CE_NATIVE = 0;
    public static final int CE_UTF8 = 1;
    public static final int CE_LATIN1 = 2;
    public static final int CE_BYTES = 3;
    public static final int CE_SYMBOL = 5;
    public static final int CE_ANY = 99;

    private Rinternals() {
    }

    @GlobalVar
    public static SEXP R_GlobalEnv() {
        return Native.currentContext().getGlobalEnvironment();
    }

    @GlobalVar
    public static SEXP R_BaseEnv() {
        return Native.currentContext().getBaseEnvironment();
    }

    @GlobalVar
    public static SEXP R_BaseNamespace() {
        return Native.currentContext().getNamespaceRegistry().getBaseNamespaceEnv();
    }

    @GlobalVar
    public static SEXP R_NamespaceRegistry() {
        return Namespaces.getNamespaceRegistry((NamespaceRegistry)Native.currentContext().getNamespaceRegistry());
    }

    public static BytePtr R_CHAR(SEXP x) {
        GnuCharSexp charSexp = (GnuCharSexp)x;
        return charSexp.getValue();
    }

    public static boolean Rf_isNull(SEXP s) {
        return Types.isNull((SEXP)s);
    }

    public static boolean Rf_isSymbol(SEXP s) {
        return Types.isSymbol((SEXP)s);
    }

    public static boolean Rf_isLogical(SEXP s) {
        return Types.isLogical((SEXP)s);
    }

    public static boolean Rf_isReal(SEXP s) {
        return Types.isReal((SEXP)s);
    }

    public static boolean Rf_isComplex(SEXP s) {
        return Types.isComplex((SEXP)s);
    }

    public static boolean Rf_isExpression(SEXP s) {
        return Types.isExpression((SEXP)s);
    }

    public static boolean Rf_isEnvironment(SEXP s) {
        return Types.isEnvironment((SEXP)s);
    }

    public static boolean Rf_isString(SEXP s) {
        return s instanceof StringVector;
    }

    public static boolean Rf_isObject(SEXP s) {
        return Types.isObject((SEXP)s);
    }

    public static SEXP ATTRIB(SEXP x) {
        return x.getAttributes().asPairList();
    }

    public static boolean OBJECT(SEXP x) {
        return x.isObject();
    }

    public static int MARK(SEXP x) {
        throw new UnimplementedGnuApiMethod("MARK");
    }

    public static int TYPEOF(SEXP s) {
        if (s == Null.INSTANCE) {
            return 0;
        }
        if (s instanceof ExpressionVector) {
            return 20;
        }
        if (s instanceof ListVector) {
            return 19;
        }
        if (s instanceof StringVector) {
            return 16;
        }
        if (s instanceof DoubleVector) {
            return 14;
        }
        if (s instanceof IntVector) {
            return 13;
        }
        if (s instanceof LogicalVector) {
            return 10;
        }
        if (s instanceof RawVector) {
            return 24;
        }
        if (s instanceof Environment) {
            return 4;
        }
        if (s instanceof ComplexVector) {
            return 15;
        }
        if (s instanceof Closure) {
            return 3;
        }
        if (s instanceof FunctionCall) {
            return 6;
        }
        if (s instanceof PairList) {
            return 2;
        }
        if (s instanceof S4Object) {
            return 25;
        }
        if (s instanceof Promise) {
            return 5;
        }
        if (s instanceof Symbol) {
            return 1;
        }
        if (s instanceof GnuCharSexp) {
            return 9;
        }
        if (s instanceof SpecialFunction) {
            return 7;
        }
        if (s instanceof Function) {
            return 8;
        }
        if (s instanceof ExternalPtr) {
            return 22;
        }
        throw new UnsupportedOperationException("Unknown SEXP Type: " + s.getClass().getName());
    }

    public static int NAMED(SEXP sexp) {
        return 2;
    }

    @Noop
    public static void SET_NAMED(SEXP sexp, int value) {
    }

    public static int REFCNT(SEXP x) {
        throw new UnimplementedGnuApiMethod("REFCNT");
    }

    public static void SET_OBJECT(SEXP x, int v) {
        if (x.isObject() && v == 0) {
            throw new EvalException("SET_OBJECT: value SEXP Object field doesn't match expected value", new Object[0]);
        }
    }

    public static void SET_TYPEOF(@Mutee SEXP x, int v) {
        if (Rinternals.TYPEOF(x) != v) {
            throw new UnimplementedGnuApiMethod(String.format("Cannot change SEXP of type '%s' to '%s'", SexpType.typeName((int)Rinternals.TYPEOF(x)), SexpType.typeName((int)v)));
        }
    }

    public static void SET_ATTRIB(SEXP x, SEXP v) {
        if (v instanceof PairList) {
            ((AbstractSEXP)x).unsafeSetAttributes(AttributeMap.fromPairList((PairList)((PairList)v)));
        } else {
            ((AbstractSEXP)x).unsafeSetAttributes(v.getAttributes());
        }
    }

    public static void DUPLICATE_ATTRIB(SEXP to, SEXP from) {
        AbstractSEXP abstractSEXP = (AbstractSEXP)to;
        if (Types.isS4((SEXP)from) && !Types.isS4((SEXP)to)) {
            abstractSEXP.unsafeSetAttributes(from.getAttributes().copy().setS4(true));
        } else {
            abstractSEXP.unsafeSetAttributes(from.getAttributes().copy());
        }
    }

    public static int IS_S4_OBJECT(SEXP x) {
        return Types.isS4((SEXP)x) ? 1 : 0;
    }

    public static void SET_S4_OBJECT(SEXP x) {
        AbstractSEXP abstractSEXP = (AbstractSEXP)x;
        abstractSEXP.unsafeSetAttributes(x.getAttributes().copy().setS4(true));
    }

    public static void UNSET_S4_OBJECT(SEXP x) {
        AbstractSEXP abstractSEXP = (AbstractSEXP)x;
        abstractSEXP.unsafeSetAttributes(x.getAttributes().copy().setS4(false));
    }

    public static int LENGTH(SEXP x) {
        return x.length();
    }

    public static int TRUELENGTH(SEXP x) {
        return 0;
    }

    public static void SETLENGTH(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SETLENGTH");
    }

    public static void SET_TRUELENGTH(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_TRUELENGTH");
    }

    public static int XLENGTH(SEXP x) {
        return x.length();
    }

    public static int XTRUELENGTH(SEXP x) {
        throw new UnimplementedGnuApiMethod("XTRUELENGTH");
    }

    public static int IS_LONG_VEC(SEXP x) {
        return 0;
    }

    public static int LEVELS(SEXP x) {
        SEXP levels = x.getAttribute(Symbols.LEVELS);
        if (Null.INSTANCE == levels) {
            return Integer.MIN_VALUE;
        }
        return levels.asInt();
    }

    public static int SETLEVELS(SEXP x, int v) {
        AbstractSEXP abstractSEXP = (AbstractSEXP)x;
        abstractSEXP.unsafeSetAttributes(x.getAttributes().copy().set(Symbols.LEVELS, (SEXP)IntVector.valueOf((int)v)));
        return Rinternals.LEVELS(x);
    }

    public static Object DATAPTR(SEXP x) {
        if (x instanceof IntVector || x instanceof LogicalVector) {
            return Rinternals.INTEGER(x);
        }
        if (x instanceof DoubleVector) {
            return Rinternals.REAL(x);
        }
        if (x instanceof ComplexVector) {
            return Rinternals.COMPLEX(x);
        }
        if (x instanceof RawVector) {
            return Rinternals.RAW(x);
        }
        throw new UnsupportedOperationException("DATAPTR on type " + x.getClass().getName());
    }

    public static IntPtr LOGICAL(SEXP x) {
        if (x instanceof LogicalArrayVector) {
            return new IntPtr(((LogicalArrayVector)x).toIntArrayUnsafe());
        }
        if (x instanceof LogicalVector) {
            return new IntPtr(((LogicalVector)x).toIntArray());
        }
        throw new EvalException("LOGICAL(): expected logical vector, found %s", new Object[]{x.getTypeName()});
    }

    @Deprecated
    public static IntPtr INTEGER(SEXP x) {
        if (x instanceof IntArrayVector) {
            return new IntPtr(((IntArrayVector)x).toIntArrayUnsafe());
        }
        if (x instanceof LogicalArrayVector) {
            return new IntPtr(((LogicalArrayVector)x).toIntArrayUnsafe());
        }
        if (x instanceof DoubleVector) {
            return new IntPtr(((DoubleVector)x).toIntArray());
        }
        if (x instanceof IntVector) {
            return new IntPtr(((IntVector)x).toIntArray());
        }
        if (x instanceof LogicalVector) {
            return new IntPtr(((LogicalVector)x).toIntArray());
        }
        if (x == Null.INSTANCE) {
            return new IntPtr(new int[]{0});
        }
        throw new EvalException("INTEGER(): expected integer vector, found %s", new Object[]{x.getTypeName()});
    }

    public static BytePtr RAW(SEXP x) {
        if (x instanceof RawVector) {
            return new BytePtr(((RawVector)x).toByteArrayUnsafe());
        }
        throw new EvalException("RAW(): Expected raw vector, found %s", new Object[]{x.getTypeName()});
    }

    @Deprecated
    public static DoublePtr REAL(SEXP x) {
        if (x instanceof DoubleArrayVector) {
            return new DoublePtr(((DoubleArrayVector)x).toDoubleArrayUnsafe());
        }
        if (x instanceof DoubleVector) {
            return new DoublePtr(((DoubleVector)x).toDoubleArray());
        }
        throw new EvalException("REAL(): expected numeric vector, found %s", new Object[]{x.getTypeName()});
    }

    public static DoublePtr COMPLEX(SEXP x) {
        if (x instanceof ComplexArrayVector) {
            return new DoublePtr(((ComplexArrayVector)x).toComplexArrayVectorUnsafe());
        }
        throw new EvalException("COMPLEX(): expected complex vector, found %s", new Object[]{x.getTypeName()});
    }

    public static SEXP STRING_ELT(SEXP x, int i) {
        if (x instanceof GnuStringVector) {
            return ((GnuStringVector)x).getElementAsCharSexp(i);
        }
        StringVector stringVector = (StringVector)x;
        String string = stringVector.getElementAsString(i);
        return GnuCharSexp.valueOf(string);
    }

    public static SEXP VECTOR_ELT(SEXP x, int i) {
        if (x instanceof FunctionCall || x instanceof PairList) {
            return ((PairList)x).getElementAsSEXP(i);
        }
        return ((ListVector)x).getElementAsSEXP(i);
    }

    public static void SET_STRING_ELT(@Mutee SEXP x, int i, SEXP v) {
        if (!(x instanceof GnuStringVector)) {
            throw new IllegalStateException("Attempt to modify a shared SEXP");
        }
        GnuStringVector stringVector = (GnuStringVector)x;
        GnuCharSexp charValue = (GnuCharSexp)v;
        stringVector.set(i, charValue);
    }

    public static SEXP SET_VECTOR_ELT(SEXP x, int i, SEXP v) {
        ListVector listVector = (ListVector)x;
        SEXP[] elements = listVector.toArrayUnsafe();
        elements[i] = v;
        return v;
    }

    public static SEXP TAG(SEXP e) {
        return ((PairList.Node)e).getRawTag();
    }

    public static SEXP CAR(SEXP e) {
        if (e == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        if (e instanceof Symbol) {
            return new GnuCharSexp((Symbol)e);
        }
        if (e instanceof Closure) {
            return ((Closure)e).getFormals();
        }
        return ((PairList.Node)e).getValue();
    }

    public static SEXP CDR(SEXP e) {
        if (e instanceof Null) {
            return Null.INSTANCE;
        }
        return ((PairList.Node)e).getNext();
    }

    public static SEXP CAAR(SEXP e) {
        return Rinternals.CAR(Rinternals.CAR(e));
    }

    public static SEXP CDAR(SEXP e) {
        return Rinternals.CDR(Rinternals.CAR(e));
    }

    public static SEXP CADR(SEXP e) {
        return Rinternals.CAR(Rinternals.CDR(e));
    }

    public static SEXP CDDR(SEXP e) {
        return Rinternals.CDR(Rinternals.CDR(e));
    }

    public static SEXP CDDDR(SEXP e) {
        return Rinternals.CDR(Rinternals.CDR(Rinternals.CDR(e)));
    }

    public static SEXP CADDR(SEXP e) {
        return Rinternals.CAR(Rinternals.CDR(Rinternals.CDR(e)));
    }

    public static SEXP CADDDR(SEXP e) {
        return Rinternals.CAR(Rinternals.CDR(Rinternals.CDR(Rinternals.CDR(e))));
    }

    public static SEXP CAD4R(SEXP e) {
        return Rinternals.CAR(Rinternals.CDR(Rinternals.CDR(Rinternals.CDR(Rinternals.CDR(e)))));
    }

    public static SEXP CD4R(SEXP x) {
        return Rinternals.CDR(Rinternals.CDR(Rinternals.CDR(Rinternals.CDR(x))));
    }

    public static int MISSING(SEXP x) {
        throw new UnimplementedGnuApiMethod("MISSING");
    }

    public static void SET_MISSING(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_MISSING");
    }

    public static void SET_TAG(SEXP x, SEXP y) {
        ((PairList)x).setTag(y);
    }

    public static SEXP SETCAR(SEXP x, SEXP y) {
        if (x == null || x == R_NilValue) {
            throw new EvalException("bad value", new Object[0]);
        }
        ((PairList.Node)x).setValue(y);
        return y;
    }

    public static SEXP SETCDR(SEXP x, SEXP y) {
        if (x == null || x == R_NilValue) {
            throw new EvalException("bad value", new Object[0]);
        }
        ((PairList.Node)x).setNextNode((PairList)y);
        return y;
    }

    public static SEXP SETCADR(SEXP x, SEXP y) {
        if (x == null || x == R_NilValue || Rinternals.CDR(x) == null || Rinternals.CDR(x) == R_NilValue) {
            throw new EvalException("bad value", new Object[0]);
        }
        SEXP cell = Rinternals.CDR(x);
        ((PairList.Node)cell).setValue(y);
        return y;
    }

    public static SEXP CHK(SEXP sexp) {
        return sexp;
    }

    public static SEXP SETCADDR(SEXP x, SEXP y) {
        if (x == null || x == R_NilValue || Rinternals.CDR(x) == null || Rinternals.CDR(x) == R_NilValue || Rinternals.CDDR(x) == null || Rinternals.CDDR(x) == R_NilValue) {
            throw new EvalException("bad value", new Object[0]);
        }
        SEXP cell = Rinternals.CDDR(x);
        ((PairList.Node)cell).setValue(y);
        return y;
    }

    public static SEXP SETCADDDR(SEXP x, SEXP y) {
        if (Rinternals.CHK(x) == null || x == R_NilValue || Rinternals.CHK(Rinternals.CDR(x)) == null || Rinternals.CDR(x) == R_NilValue || Rinternals.CHK(Rinternals.CDDR(x)) == null || Rinternals.CDDR(x) == R_NilValue || Rinternals.CHK(Rinternals.CDDDR(x)) == null || Rinternals.CDDDR(x) == R_NilValue) {
            throw new EvalException("bad value", new Object[0]);
        }
        SEXP cell = Rinternals.CDDDR(x);
        ((PairList.Node)cell).setValue(y);
        return y;
    }

    public static SEXP SETCAD4R(SEXP x, SEXP y) {
        if (Rinternals.CHK(x) == null || x == R_NilValue || Rinternals.CHK(Rinternals.CDR(x)) == null || Rinternals.CDR(x) == R_NilValue || Rinternals.CHK(Rinternals.CDDR(x)) == null || Rinternals.CDDR(x) == R_NilValue || Rinternals.CHK(Rinternals.CDDDR(x)) == null || Rinternals.CDDDR(x) == R_NilValue || Rinternals.CHK(Rinternals.CD4R(x)) == null || Rinternals.CD4R(x) == R_NilValue) {
            throw new EvalException("bad value", new Object[0]);
        }
        SEXP cell = Rinternals.CD4R(x);
        ((PairList.Node)cell).setValue(y);
        return y;
    }

    public static SEXP CONS_NR(SEXP a, SEXP b) {
        throw new UnimplementedGnuApiMethod("CONS_NR");
    }

    public static SEXP FORMALS(SEXP x) {
        return ((Closure)x).getFormals();
    }

    public static SEXP BODY(SEXP x) {
        return ((Closure)x).getBody();
    }

    public static SEXP CLOENV(SEXP x) {
        return ((Closure)x).getEnclosingEnvironment();
    }

    public static int RDEBUG(SEXP x) {
        throw new UnimplementedGnuApiMethod("RDEBUG");
    }

    public static int RSTEP(SEXP x) {
        throw new UnimplementedGnuApiMethod("RSTEP");
    }

    public static int RTRACE(SEXP x) {
        throw new UnimplementedGnuApiMethod("RTRACE");
    }

    public static void SET_RDEBUG(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_RDEBUG");
    }

    public static void SET_RSTEP(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_RSTEP");
    }

    public static void SET_RTRACE(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_RTRACE");
    }

    public static void SET_FORMALS(SEXP x, SEXP v) {
        ((Closure)x).unsafeSetFormals((PairList)v);
    }

    public static void SET_BODY(SEXP x, SEXP v) {
        ((Closure)x).unsafeSetBody(v);
    }

    public static int IS_CACHED(SEXP x) {
        return 0;
    }

    public static void SET_CLOENV(SEXP x, SEXP v) {
        ((Closure)x).unsafeSetEnclosingEnvironment((Environment)v);
    }

    public static SEXP PRINTNAME(SEXP x) {
        return GnuCharSexp.valueOf(((Symbol)x).getPrintName());
    }

    public static SEXP SYMVALUE(SEXP x) {
        throw new UnimplementedGnuApiMethod("SYMVALUE");
    }

    public static SEXP INTERNAL(SEXP x) {
        throw new UnimplementedGnuApiMethod("INTERNAL");
    }

    public static int DDVAL(SEXP x) {
        throw new UnimplementedGnuApiMethod("DDVAL");
    }

    public static void SET_DDVAL(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_DDVAL");
    }

    public static void SET_PRINTNAME(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRINTNAME");
    }

    public static void SET_SYMVALUE(SEXP x, SEXP val) {
        throw new UnimplementedGnuApiMethod("SET_SYMVALUE");
    }

    public static void SET_INTERNAL(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_INTERNAL");
    }

    public static SEXP FRAME(SEXP x) {
        throw new UnimplementedGnuApiMethod("FRAME");
    }

    public static SEXP ENCLOS(SEXP x) {
        return ((Environment)x).getParent();
    }

    public static SEXP HASHTAB(SEXP x) {
        throw new UnimplementedGnuApiMethod("HASHTAB");
    }

    public static int ENVFLAGS(SEXP x) {
        throw new UnimplementedGnuApiMethod("ENVFLAGS");
    }

    public static void SET_ENVFLAGS(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_ENVFLAGS");
    }

    public static void SET_FRAME(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_FRAME");
    }

    public static void SET_ENCLOS(SEXP env, SEXP parent) {
        ((Environment)env).setParent((Environment)parent);
    }

    public static void SET_HASHTAB(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_HASHTAB");
    }

    public static SEXP PRCODE(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRCODE");
    }

    public static SEXP PRENV(SEXP x) {
        Promise promise = (Promise)x;
        if (promise.isEvaluated()) {
            return Null.INSTANCE;
        }
        return promise.getEnvironment();
    }

    public static SEXP PRVALUE(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRVALUE");
    }

    public static int PRSEEN(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRSEEN");
    }

    public static void SET_PRSEEN(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_PRSEEN");
    }

    public static void SET_PRENV(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRENV");
    }

    public static void SET_PRVALUE(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRVALUE");
    }

    public static void SET_PRCODE(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRCODE");
    }

    public static int HASHASH(SEXP x) {
        throw new UnimplementedGnuApiMethod("HASHASH");
    }

    public static int HASHVALUE(SEXP x) {
        throw new UnimplementedGnuApiMethod("HASHVALUE");
    }

    public static void SET_HASHASH(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_HASHASH");
    }

    public static void SET_HASHVALUE(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_HASHVALUE");
    }

    public static SEXP R_GetCurrentSrcref(int p0) {
        throw new UnimplementedGnuApiMethod("R_GetCurrentSrcref");
    }

    public static SEXP R_GetSrcFilename(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_GetSrcFilename");
    }

    public static SEXP Rf_asChar(SEXP p0) {
        if (p0.length() == 0) {
            return R_NaString;
        }
        return GnuCharSexp.valueOf(((AtomicVector)p0).getElementAsString(0));
    }

    public static SEXP Rf_coerceVector(SEXP p0, int type) {
        switch (type) {
            case 2: {
                return PairList.Node.fromVector((Vector)((Vector)p0));
            }
            case 10: {
                return Vectors.asLogical((Vector)((Vector)p0)).setAttributes(p0.getAttributes());
            }
            case 13: {
                return Rinternals.asIntArrayVector((Vector)p0);
            }
            case 14: {
                return Rinternals.asDoubleArrayVector((Vector)p0);
            }
            case 15: {
                return Vectors.asComplex((Vector)((Vector)p0)).setAttributes(p0.getAttributes());
            }
            case 16: {
                return Vectors.asCharacter((Context)Native.currentContext(), (Vector)((Vector)p0)).setAttributes(p0.getAttributes());
            }
            case 20: {
                return Rinternals.toExpressionList(p0);
            }
        }
        throw new UnimplementedGnuApiMethod("Rf_coerceVector: " + type);
    }

    private static SEXP asIntArrayVector(Vector vector) {
        Vectors.checkForListThatCannotBeCoercedToAtomicVector((Vector)vector, (String)"integer");
        IntArrayVector.Builder builder = new IntArrayVector.Builder(0, vector.length());
        Vector integerVector = Vectors.convertToAtomicVector((Vector.Builder)builder, (Vector)vector);
        return integerVector.setAttributes(vector.getAttributes());
    }

    private static SEXP asDoubleArrayVector(Vector vector) {
        Vectors.checkForListThatCannotBeCoercedToAtomicVector((Vector)vector, (String)"double");
        DoubleArrayVector.Builder builder = new DoubleArrayVector.Builder(0, vector.length());
        Vector integerVector = Vectors.convertToAtomicVector((Vector.Builder)builder, (Vector)vector);
        return integerVector.setAttributes(vector.getAttributes());
    }

    private static SEXP toExpressionList(SEXP sexp) {
        if (sexp instanceof Vector) {
            return Vectors.asVector((Vector)((Vector)sexp), (String)"expression");
        }
        if (sexp instanceof PairList) {
            return Rinternals.toExpressionList((SEXP)((PairList)sexp).toVector());
        }
        throw new UnsupportedOperationException("Rf_coerceVector: from: " + sexp.getTypeName() + " to EXPRSXP");
    }

    public static SEXP Rf_PairToVectorList(SEXP x) {
        PairList pairList = (PairList)x;
        return pairList.toVector();
    }

    public static SEXP Rf_VectorToPairList(SEXP x) {
        return PairList.Node.fromVector((Vector)((Vector)x));
    }

    public static SEXP Rf_asCharacterFactor(SEXP x) {
        throw new UnimplementedGnuApiMethod("Rf_asCharacterFactor");
    }

    public static int Rf_asLogical(SEXP x) {
        boolean warn = false;
        if (Rinternals.Rf_isVectorAtomic(x)) {
            if (Rinternals.XLENGTH(x) < 1) {
                return Integer.MIN_VALUE;
            }
            return ((AtomicVector)x).getElementAsRawLogical(0);
        }
        if (x instanceof GnuCharSexp) {
            return StringVector.logicalFromString((String)((GnuCharSexp)x).getValue().nullTerminatedString());
        }
        return LogicalVector.NA;
    }

    public static int Rf_asInteger(SEXP x) {
        boolean warn = false;
        if (Rinternals.Rf_isVectorAtomic(x) && Rinternals.XLENGTH(x) >= 1) {
            if (x instanceof AtomicVector) {
                return ((AtomicVector)x).getElementAsInt(0);
            }
            throw Rinternals.UNIMPLEMENTED_TYPE("asInteger", x);
        }
        if (x instanceof CHARSEXP) {
            throw new UnsupportedOperationException();
        }
        return Integer.MIN_VALUE;
    }

    public static double Rf_asReal(SEXP x) {
        boolean warn = false;
        if (Rinternals.Rf_isVectorAtomic(x) && Rinternals.XLENGTH(x) >= 1) {
            if (x instanceof AtomicVector) {
                return ((AtomicVector)x).getElementAsDouble(0);
            }
            throw Rinternals.UNIMPLEMENTED_TYPE("asReal", x);
        }
        if (x instanceof CHARSEXP) {
            throw new UnsupportedOperationException();
        }
        return DoubleVector.NA;
    }

    private static EvalException UNIMPLEMENTED_TYPE(String s, SEXP t) {
        return new EvalException("unimplemented type '%s' in '%s'\n", new Object[]{t.getTypeName(), s});
    }

    public static BytePtr Rf_acopy_string(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("Rf_acopy_string");
    }

    public static void Rf_addMissingVarsToNewEnv(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_addMissingVarsToNewEnv");
    }

    public static SEXP Rf_alloc3DArray(int p0, int p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_alloc3DArray");
    }

    public static SEXP Rf_allocArray(int p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_allocArray");
    }

    public static SEXP Rf_allocFormalsList2(SEXP sym1, SEXP sym2) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList2");
    }

    public static SEXP Rf_allocFormalsList3(SEXP sym1, SEXP sym2, SEXP sym3) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList3");
    }

    public static SEXP Rf_allocFormalsList4(SEXP sym1, SEXP sym2, SEXP sym3, SEXP sym4) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList4");
    }

    public static SEXP Rf_allocFormalsList5(SEXP sym1, SEXP sym2, SEXP sym3, SEXP sym4, SEXP sym5) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList5");
    }

    public static SEXP Rf_allocFormalsList6(SEXP sym1, SEXP sym2, SEXP sym3, SEXP sym4, SEXP sym5, SEXP sym6) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList6");
    }

    public static SEXP Rf_allocMatrix(int type, int numRows, int numCols) {
        AttributeMap attributes = AttributeMap.builder().setDim(numRows, numCols).build();
        switch (type) {
            case 13: {
                return new IntArrayVector(new int[numRows * numCols], attributes);
            }
            case 14: {
                return new DoubleArrayVector(new double[numRows * numCols], attributes);
            }
            case 10: {
                return new LogicalArrayVector(new int[numRows * numCols], attributes);
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    @Allocator
    public static SEXP Rf_allocList(int n) {
        PairList.Builder list = new PairList.Builder();
        for (int i = 0; i < n; ++i) {
            list.add(R_NilValue, R_NilValue);
        }
        return list.build();
    }

    @Allocator
    public static SEXP Rf_allocLang(int n) {
        FunctionCall.Builder lang = new FunctionCall.Builder();
        for (int i = 0; i < n; ++i) {
            lang.add(R_NilValue, R_NilValue);
        }
        return lang.build();
    }

    @Allocator
    public static SEXP Rf_allocS4Object() {
        throw new UnimplementedGnuApiMethod("Rf_allocS4Object");
    }

    @Allocator
    public static SEXP Rf_allocSExp(int type) {
        switch (type) {
            case 3: {
                return new Closure((Environment)Environment.EMPTY, (PairList)Null.INSTANCE, (SEXP)Null.INSTANCE);
            }
        }
        throw new UnimplementedGnuApiMethod("Rf_allocSExp: " + type);
    }

    public static int Rf_any_duplicated(SEXP x, boolean from_last) {
        return Duplicates.anyDuplicated((Vector)((Vector)x), (AtomicVector)LogicalVector.FALSE, (boolean)from_last);
    }

    public static int Rf_any_duplicated3(SEXP x, SEXP incomp, boolean from_last) {
        return Duplicates.anyDuplicated((Vector)((Vector)x), (AtomicVector)((AtomicVector)incomp), (boolean)from_last);
    }

    public static SEXP Rf_applyClosure(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4) {
        throw new UnimplementedGnuApiMethod("Rf_applyClosure");
    }

    @PotentialMutator
    public static SEXP Rf_classgets(@Mutee SEXP object, SEXP classNames) {
        return Native.currentContext().evaluate((SEXP)FunctionCall.newCall((SEXP)Symbol.get((String)"class<-"), (SEXP[])new SEXP[]{object, classNames}));
    }

    public static SEXP Rf_cons(SEXP cr, SEXP tail) {
        assert (tail instanceof PairList) : "tail argument must be a pairlist";
        return new PairList.Node(cr, (PairList)tail);
    }

    public static void Rf_copyMatrix(SEXP s, SEXP t, boolean byrow) {
        int nr = Rinternals.Rf_nrows(s);
        int nc = Rinternals.Rf_ncols(s);
        int nt = Rinternals.XLENGTH(t);
        if (byrow) {
            throw new UnimplementedGnuApiMethod("copyMatrix(byrow=TRUE)");
        }
        Rinternals.Rf_copyVector(s, t);
    }

    public static void Rf_copyListMatrix(SEXP p0, SEXP p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_copyListMatrix");
    }

    public static void Rf_copyMostAttrib(SEXP inp, SEXP ans) {
        AttributeMap inpAttrib = inp.getAttributes().copy().removeDim().removeDimnames().remove(Symbols.NAMES).build();
        ((AbstractSEXP)ans).unsafeSetAttributes(ans.getAttributes().copy().combineFrom(inpAttrib));
    }

    public static void Rf_copyVector(SEXP s, SEXP t) {
        int tT;
        int sT = Rinternals.TYPEOF(s);
        if (sT != (tT = Rinternals.TYPEOF(t))) {
            throw new EvalException("vector types do not match in copyVector", new Object[0]);
        }
        int ns = Rinternals.XLENGTH(s);
        int nt = Rinternals.XLENGTH(t);
        switch (sT) {
            case 16: {
                Rinternals.xcopyStringWithRecycle(s, t, 0, ns, nt);
                break;
            }
            case 10: {
                Rinternals.xcopyLogicalWithRecycle(s, t, 0, ns, nt);
                break;
            }
            case 13: {
                Rinternals.xcopyIntegerWithRecycle(s, t, 0, ns, nt);
                break;
            }
            case 14: {
                Rinternals.xcopyRealWithRecycle(s, t, 0, ns, nt);
                break;
            }
            case 15: {
                Rinternals.xcopyComplexWithRecycle(s, t, 0, ns, nt);
                break;
            }
            case 19: 
            case 20: {
                Rinternals.xcopyVectorWithRecycle(s, t, 0, ns, nt);
                break;
            }
            case 24: {
                Rinternals.xcopyRawWithRecycle(s, t, 0, ns, nt);
                break;
            }
            default: {
                Rinternals.UNIMPLEMENTED_TYPE("copyVector", s);
            }
        }
    }

    private static void xcopyRawWithRecycle(SEXP s, SEXP t, int i, int ns, int nt) {
        throw new UnimplementedGnuApiMethod("xcopyRawWithRecycle");
    }

    private static void xcopyVectorWithRecycle(SEXP s, SEXP t, int i, int ns, int nt) {
        throw new UnimplementedGnuApiMethod("xcopyVectorWithRecycle");
    }

    private static void xcopyComplexWithRecycle(SEXP s, SEXP t, int i, int ns, int nt) {
        throw new UnimplementedGnuApiMethod("xcopyComplexWithRecycle");
    }

    private static void xcopyRealWithRecycle(SEXP dst, SEXP src, int dstart, int n, int nsrc) {
        DoubleVector sv = (DoubleVector)src;
        if (!(dst instanceof DoubleArrayVector)) {
            throw new EvalException("Illegal modification of target vector: " + src.getClass().getName(), new Object[0]);
        }
        DoubleArrayVector dv = (DoubleArrayVector)dst;
        double[] da = dv.toDoubleArrayUnsafe();
        double[] sa = sv instanceof DoubleArrayVector ? ((DoubleArrayVector)sv).toDoubleArrayUnsafe() : sv.toDoubleArray();
        if (nsrc >= n) {
            System.arraycopy(sa, 0, da, dstart, n);
        } else if (nsrc == 1) {
            Arrays.fill(da, dstart, dstart + n, sa[0]);
        } else {
            int sidx = 0;
            int i = 0;
            while (i < n) {
                if (sidx == nsrc) {
                    sidx = 0;
                }
                da[dstart + i] = sa[sidx];
                ++i;
                ++sidx;
            }
        }
    }

    private static void xcopyIntegerWithRecycle(SEXP dst, SEXP src, int dstart, int n, int nsrc) {
        IntVector sv = (IntVector)src;
        if (!(dst instanceof IntArrayVector)) {
            throw new EvalException("Illegal modification of target vector: " + src.getClass().getName(), new Object[0]);
        }
        IntArrayVector dv = (IntArrayVector)dst;
        int[] da = dv.toIntArrayUnsafe();
        int[] sa = sv instanceof IntArrayVector ? ((IntArrayVector)sv).toIntArrayUnsafe() : sv.toIntArray();
        Rinternals.copy(sa, da, dstart, n, nsrc);
    }

    private static void xcopyLogicalWithRecycle(SEXP dst, SEXP src, int dstart, int n, int nsrc) {
        LogicalVector sv = (LogicalVector)src;
        if (!(dst instanceof LogicalArrayVector)) {
            throw new EvalException("Illegal modification of target vector: " + dst.getClass().getName(), new Object[0]);
        }
        LogicalArrayVector dv = (LogicalArrayVector)dst;
        int[] da = dv.toIntArrayUnsafe();
        int[] sa = sv instanceof LogicalArrayVector ? ((LogicalArrayVector)sv).toIntArrayUnsafe() : sv.toIntArray();
        Rinternals.copy(sa, da, dstart, n, nsrc);
    }

    private static void copy(int[] sa, int[] da, int dstart, int n, int nsrc) {
        if (nsrc >= n) {
            System.arraycopy(sa, 0, da, dstart, n);
        } else if (nsrc == 1) {
            Arrays.fill(da, dstart, dstart + n, sa[0]);
        } else {
            int sidx = 0;
            int i = 0;
            while (i < n) {
                if (sidx == nsrc) {
                    sidx = 0;
                }
                da[dstart + i] = sa[sidx];
                ++i;
                ++sidx;
            }
        }
    }

    private static void xcopyStringWithRecycle(SEXP s, SEXP t, int i, int ns, int nt) {
        throw new UnsupportedOperationException("xcopyStringWithRecycle: not yet supported by Renjin");
    }

    public static int Rf_countContexts(int p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_countContexts");
    }

    public static SEXP Rf_CreateTag(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_CreateTag");
    }

    public static void Rf_defineVar(SEXP nameSexp, SEXP value, SEXP rhoSexp) {
        Symbol name = (Symbol)nameSexp;
        Environment rho = (Environment)rhoSexp;
        rho.setVariable(Native.currentContext(), name, value);
    }

    public static SEXP Rf_dimgets(SEXP sexp, SEXP dim) {
        return sexp.setAttributes(sexp.getAttributes().copy().setDim(dim));
    }

    public static SEXP Rf_dimnamesgets(SEXP sexp, SEXP dimnames) {
        return sexp.setAttributes(sexp.getAttributes().copy().setDimNames(dimnames));
    }

    public static SEXP Rf_DropDims(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_DropDims");
    }

    public static SEXP Rf_duplicate(SEXP sexp) {
        return Rinternals.duplicate(sexp, true);
    }

    private static SEXP duplicate(SEXP sexp, boolean deep) {
        if (sexp == Null.INSTANCE) {
            return sexp;
        }
        if (sexp instanceof DoubleVector) {
            return new DoubleArrayVector((AtomicVector)((DoubleVector)sexp));
        }
        if (sexp instanceof IntVector) {
            return new IntArrayVector((AtomicVector)((IntVector)sexp));
        }
        if (sexp instanceof ComplexVector) {
            return new ComplexArrayVector((ComplexVector)sexp);
        }
        if (sexp instanceof StringVector) {
            return GnuStringVector.copyOf((StringVector)sexp);
        }
        if (sexp instanceof LogicalVector) {
            return new LogicalArrayVector(((LogicalArrayVector)sexp).toIntArray(), sexp.getAttributes());
        }
        if (sexp instanceof RawVector) {
            return new RawVector(((RawVector)sexp).toByteArrayUnsafe(), sexp.getAttributes());
        }
        if (sexp instanceof S4Object) {
            return new S4Object(Rinternals.duplicate(sexp.getAttributes()));
        }
        if (sexp instanceof ListVector) {
            SEXP[] elements = ((ListVector)sexp).toArrayUnsafe();
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = deep ? Rinternals.duplicate(elements[i], deep) : elements[i];
            }
            return new ListVector(elements, sexp.getAttributes());
        }
        if (sexp instanceof FunctionCall) {
            return Rinternals.duplicateCall((FunctionCall)sexp, deep);
        }
        if (sexp instanceof PairList) {
            return Rinternals.duplicatePairList((PairList)sexp, deep);
        }
        if (sexp instanceof Symbol | sexp instanceof PrimitiveFunction | sexp instanceof ExternalPtr | sexp instanceof Environment | sexp instanceof Promise) {
            return sexp;
        }
        throw new UnimplementedGnuApiMethod("Rf_duplicate: " + sexp.getTypeName());
    }

    private static AttributeMap duplicate(AttributeMap attributes) {
        AttributeMap.Builder copy = AttributeMap.builder();
        for (Symbol symbol : attributes.names()) {
            copy.set(symbol, Rinternals.Rf_duplicate(attributes.get(symbol)));
        }
        return copy.build();
    }

    private static SEXP duplicatePairList(PairList pairlist, boolean deep) {
        PairList.Builder copy = new PairList.Builder();
        for (PairList.Node node : pairlist.nodes()) {
            copy.add(node.getRawTag(), deep ? Rinternals.Rf_duplicate(node.getValue()) : node.getValue());
        }
        return copy.build();
    }

    private static SEXP duplicateCall(FunctionCall call, boolean deep) {
        FunctionCall.Builder copy = new FunctionCall.Builder();
        for (PairList.Node node : call.nodes()) {
            copy.add(node.getRawTag(), deep ? Rinternals.Rf_duplicate(node.getValue()) : node.getValue());
        }
        return copy.build();
    }

    public static SEXP Rf_shallow_duplicate(SEXP p0) {
        return Rinternals.duplicate(p0, false);
    }

    public static SEXP Rf_lazy_duplicate(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_lazy_duplicate");
    }

    public static SEXP Rf_duplicated(SEXP p0, boolean p1) {
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        if (!(p0.getElementAsSEXP(0) instanceof IntArrayVector)) {
            throw new UnsupportedOperationException("argument to internal function 'Rf_duplicated' is not of type 'IntArrayVector'");
        }
        HashSet<IntArrayVector> elementsHash = new HashSet<IntArrayVector>();
        for (int i = 0; i < p0.length(); ++i) {
            IntArrayVector element = (IntArrayVector)p0.getElementAsSEXP(i);
            if (elementsHash.contains(element)) {
                result.add((SEXP)LogicalVector.TRUE);
                continue;
            }
            result.add((SEXP)LogicalVector.FALSE);
            elementsHash.add(element);
        }
        return result.build();
    }

    public static boolean R_envHasNoSpecialSymbols(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_envHasNoSpecialSymbols");
    }

    public static SEXP Rf_eval(SEXP e, SEXP rho) {
        return Native.currentContext().evaluate(e, (Environment)rho);
    }

    public static SEXP Rf_findFun(SEXP symbol, SEXP rho) {
        return ((Environment)rho).findFunction(Native.currentContext(), (Symbol)symbol);
    }

    public static SEXP Rf_findVar(SEXP symbol, SEXP rho) {
        return ((Environment)rho).findVariable(Native.currentContext(), (Symbol)symbol);
    }

    public static SEXP Rf_findVarInFrame(SEXP rho, SEXP symbol) {
        return Rinternals.Rf_findVarInFrame3(rho, symbol, true);
    }

    public static SEXP Rf_findVarInFrame3(SEXP rho, SEXP symbol, boolean doGet) {
        return ((Environment)rho).getVariable(Native.currentContext(), (Symbol)symbol);
    }

    public static SEXP Rf_getAttrib(SEXP vec, SEXP name) {
        return vec.getAttribute((Symbol)name);
    }

    public static SEXP Rf_GetArrayDimnames(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_GetArrayDimnames");
    }

    public static SEXP Rf_GetColNames(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_GetColNames");
    }

    public static SEXP Rf_GetOption(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_GetOption");
    }

    public static SEXP Rf_GetOption1(SEXP optionNameSexp) {
        Symbol optionName = (Symbol)optionNameSexp;
        Options options = (Options)Native.currentContext().getSession().getSingleton(Options.class);
        return options.get(optionName.getPrintName());
    }

    public static int Rf_GetOptionDigits() {
        throw new UnimplementedGnuApiMethod("Rf_GetOptionDigits");
    }

    public static int Rf_GetOptionWidth() {
        throw new UnimplementedGnuApiMethod("Rf_GetOptionWidth");
    }

    public static SEXP Rf_GetRowNames(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_GetRowNames");
    }

    public static void Rf_gsetVar(SEXP symbolName, SEXP value, SEXP environment) {
        if (environment == Null.INSTANCE) {
            environment = Native.currentContext().getBaseEnvironment();
        }
        ((Environment)environment).setVariable(Native.currentContext(), (Symbol)symbolName, value);
    }

    public static SEXP Rf_install(BytePtr name) {
        return Symbol.get((String)name.nullTerminatedString());
    }

    public static SEXP Rf_installChar(SEXP charSexp) {
        return Rinternals.Rf_install(((GnuCharSexp)charSexp).getValue());
    }

    public static SEXP Rf_installDDVAL(int i) {
        throw new UnimplementedGnuApiMethod("Rf_installDDVAL");
    }

    public static SEXP Rf_installS3Signature(BytePtr p0, BytePtr p1) {
        throw new UnimplementedGnuApiMethod("Rf_installS3Signature");
    }

    public static boolean Rf_isFree(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isFree");
    }

    public static boolean Rf_isOrdered(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isOrdered");
    }

    public static boolean Rf_isUnordered(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isUnordered");
    }

    public static boolean Rf_isUnsorted(SEXP p0, boolean p1) {
        throw new UnimplementedGnuApiMethod("Rf_isUnsorted");
    }

    public static SEXP Rf_xlengthgets(SEXP p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_xlengthgets");
    }

    public static SEXP R_lsInternal(SEXP env, boolean allNames) {
        return Environments.ls((Environment)((Environment)env), (boolean)allNames);
    }

    public static SEXP R_lsInternal3(SEXP env, boolean allNames, boolean sorted) {
        StringVector names = Environments.ls((Environment)((Environment)env), (boolean)allNames);
        if (sorted) {
            return Sort.sort((StringVector)names, (boolean)false);
        }
        return names;
    }

    public static SEXP Rf_match(SEXP p0, SEXP p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_match");
    }

    public static SEXP Rf_matchE(SEXP p0, SEXP p1, int p2, SEXP p3) {
        throw new UnimplementedGnuApiMethod("Rf_matchE");
    }

    public static SEXP Rf_namesgets(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_namesgets");
    }

    @Deprecated
    public static SEXP Rf_mkChar(BytePtr string) {
        return Rinternals.Rf_mkChar((Ptr)string);
    }

    public static SEXP Rf_mkChar(Ptr string) {
        if (string.isNull()) {
            return GnuCharSexp.NA_STRING;
        }
        return Rinternals.Rf_mkCharLen(string, Stdlib.strlen((Ptr)string));
    }

    @Deprecated
    public static SEXP Rf_mkCharLen(BytePtr string, int length) {
        return Rinternals.Rf_mkCharLen((Ptr)string, length);
    }

    public static SEXP Rf_mkCharLen(Ptr string, int length) {
        if (string.isNull()) {
            return GnuCharSexp.NA_STRING;
        }
        if (length == 0) {
            return R_BlankString;
        }
        BytePtr copy = BytePtr.malloc((int)(length + 1));
        copy.memcpy(string, length);
        return new GnuCharSexp(copy.array);
    }

    public static boolean Rf_NonNullStringMatch(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_NonNullStringMatch");
    }

    public static int Rf_ncols(SEXP s) {
        if (Rinternals.Rf_isVector(s) || Rinternals.Rf_isList(s)) {
            Vector dim = s.getAttributes().getDim();
            if (dim.length() >= 2) {
                return dim.getElementAsInt(1);
            }
            return 1;
        }
        if (Rinternals.Rf_isFrame(s)) {
            return Rinternals.Rf_length(s);
        }
        throw new EvalException("object is not a matrix", new Object[0]);
    }

    public static int Rf_nrows(SEXP s) {
        if (Rinternals.Rf_isVector(s) || Rinternals.Rf_isList(s)) {
            Vector dim = s.getAttributes().getDim();
            if (dim == Null.INSTANCE) {
                return s.length();
            }
            return dim.getElementAsInt(0);
        }
        if (Rinternals.Rf_isFrame(s)) {
            return Rinternals.Rf_nrows(s.getElementAsSEXP(0));
        }
        throw new EvalException("object is not a matrix", new Object[0]);
    }

    public static SEXP Rf_nthcdr(SEXP p0, int p1) {
        if (Rinternals.Rf_isList(p0) || Rinternals.Rf_isLanguage(p0) || Rinternals.Rf_isFrame(p0) || Rinternals.TYPEOF(p0) == 17) {
            while (p1-- > 0) {
                if (p0 == R_NilValue) {
                    throw new EvalException(String.format("'nthcdr' list shorter than %d", p1), new Object[0]);
                }
                p0 = Rinternals.CDR(p0);
            }
            return p0;
        }
        throw new EvalException("'nthcdr' needs a list to CDR down", new Object[0]);
    }

    public static boolean Rf_pmatch(SEXP p0, SEXP p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_pmatch");
    }

    public static boolean Rf_psmatch(BytePtr p0, BytePtr p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_psmatch");
    }

    public static void Rf_PrintValue(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_PrintValue");
    }

    public static SEXP Rf_setAttrib(@Mutee SEXP vec, SEXP name, SEXP val) {
        if (name == null) {
            throw new IllegalArgumentException("attributeName is NULL");
        }
        if (name == R_RowNamesSymbol && (RowNamesVector.isOldCompactForm((SEXP)val) || RowNamesVector.isCompactForm((SEXP)val))) {
            val = new RowNamesVector(Math.abs(val.getElementAsSEXP(1).asInt()));
        }
        Symbol attributeSymbol = name instanceof StringVector ? Symbol.get((String)((StringVector)name).getElementAsString(0)) : (Symbol)name;
        AbstractSEXP abstractSEXP = (AbstractSEXP)vec;
        abstractSEXP.unsafeSetAttributes(vec.getAttributes().copy().set(attributeSymbol, val));
        return vec;
    }

    public static void Rf_setVar(SEXP p0, SEXP p1, SEXP p2) {
        throw new UnimplementedGnuApiMethod("Rf_setVar");
    }

    public static SEXP Rf_stringSuffix(SEXP p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_stringSuffix");
    }

    @Deprecated
    public static int Rf_str2type(BytePtr p0) {
        return Rinternals.Rf_str2type((Ptr)p0);
    }

    public static int Rf_str2type(Ptr string) {
        switch (Stdlib.nullTerminatedString((Ptr)string)) {
            case "NULL": {
                return 0;
            }
            case "pairlist": {
                return 2;
            }
            case "language": {
                return 6;
            }
            case "list": {
                return 19;
            }
            case "character": {
                return 16;
            }
            case "integer": {
                return 13;
            }
            case "double": {
                return 14;
            }
            case "raw": {
                return 24;
            }
            case "logical": {
                return 10;
            }
            case "environment": {
                return 4;
            }
            case "promise": {
                return 5;
            }
            case "symbol": {
                return 1;
            }
        }
        throw new UnimplementedGnuApiMethod("Rf_str2type: " + Stdlib.nullTerminatedString((Ptr)string));
    }

    public static boolean Rf_StringBlank(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_StringBlank");
    }

    public static SEXP Rf_substitute(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_substitute");
    }

    public static BytePtr Rf_translateChar(SEXP p0) {
        return ((GnuCharSexp)p0).getValue();
    }

    public static BytePtr Rf_translateChar0(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_translateChar0");
    }

    public static BytePtr Rf_translateCharUTF8(SEXP x) {
        GnuCharSexp charsexp = (GnuCharSexp)x;
        return charsexp.getValue();
    }

    public static BytePtr Rf_type2char(int st) {
        return BytePtr.nullTerminatedString((String)SexpType.typeName((int)st), (Charset)StandardCharsets.UTF_8);
    }

    public static SEXP Rf_type2rstr(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_type2rstr");
    }

    public static SEXP Rf_type2str(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_type2str");
    }

    public static SEXP Rf_type2str_nowarn(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_type2str_nowarn");
    }

    @Noop
    public static void Rf_unprotect_ptr(SEXP p0) {
    }

    public static void R_signal_protect_error() {
        throw new UnimplementedGnuApiMethod("R_signal_protect_error");
    }

    public static void R_signal_unprotect_error() {
        throw new UnimplementedGnuApiMethod("R_signal_unprotect_error");
    }

    public static void R_signal_reprotect_error(int i) {
        throw new UnimplementedGnuApiMethod("R_signal_reprotect_error");
    }

    public static SEXP R_tryEval(SEXP p0, SEXP p1, IntPtr p2) {
        throw new UnimplementedGnuApiMethod("R_tryEval");
    }

    public static SEXP R_tryEvalSilent(SEXP p0, SEXP p1, IntPtr p2) {
        throw new UnimplementedGnuApiMethod("R_tryEvalSilent");
    }

    public static BytePtr R_curErrorBuf() {
        throw new UnimplementedGnuApiMethod("R_curErrorBuf");
    }

    public static boolean Rf_isS4(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isS4");
    }

    public static SEXP Rf_asS4(SEXP p0, boolean p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_asS4");
    }

    public static SEXP Rf_S3Class(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_S3Class");
    }

    public static int Rf_isBasicClass(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("Rf_isBasicClass");
    }

    public static boolean R_cycle_detected(SEXP s, SEXP child) {
        throw new UnimplementedGnuApiMethod("R_cycle_detected");
    }

    public static int Rf_getCharCE(SEXP s) {
        return 1;
    }

    @Deprecated
    public static SEXP Rf_mkCharCE(BytePtr str, int encoding) {
        return Rinternals.Rf_mkCharCE((Ptr)str, encoding);
    }

    @Deprecated
    public static SEXP Rf_mkCharLenCE(BytePtr text, int length, int encoding) {
        return Rinternals.Rf_mkCharLenCE((Ptr)text, length, encoding);
    }

    public static SEXP Rf_mkCharCE(Ptr str, int encoding) {
        return Rinternals.Rf_mkCharLenCE(str, Stdlib.strlen((Ptr)str), encoding);
    }

    public static SEXP Rf_mkCharLenCE(Ptr text, int length, int encoding) {
        if (text.isNull()) {
            return GnuCharSexp.NA_STRING;
        }
        if (length == 0) {
            return R_BlankString;
        }
        if (encoding != 1) {
            throw new UnsupportedOperationException("encoding: " + encoding);
        }
        BytePtr copy = BytePtr.malloc((int)(length + 1));
        copy.memcpy(text, length);
        return new GnuCharSexp(copy.array);
    }

    public static Ptr Rf_reEnc(BytePtr x, int ce_in, int ce_out, int subst) {
        if (ce_in == ce_out) {
            return x;
        }
        if (ce_in == -1 && ce_out == 1) {
            return x;
        }
        if (ce_in == 0 && ce_out == 1) {
            return x;
        }
        if (ce_in == 99 && ce_out == 1) {
            return x;
        }
        throw new UnsupportedOperationException(String.format("Rf_reEnc: from %d to %d", ce_in, ce_out));
    }

    public static SEXP R_forceAndCall(SEXP e, int n, SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_forceAndCall");
    }

    public static SEXP R_MakeExternalPtr(Object p, SEXP tag, SEXP prot) {
        return new ExternalPtr(p, tag, prot);
    }

    public static Object R_ExternalPtrAddr(SEXP s) {
        return ((ExternalPtr)s).getInstance();
    }

    public static SEXP R_ExternalPtrTag(SEXP s) {
        return ((ExternalPtr)s).getTag();
    }

    public static SEXP R_ExternalPtrProtected(SEXP s) {
        return ((ExternalPtr)s).getProtected();
    }

    public static void R_ClearExternalPtr(SEXP s) {
        ((ExternalPtr)s).unsafeSetAddress(null);
    }

    public static void R_SetExternalPtrAddr(SEXP s, Object p) {
        ((ExternalPtr)s).unsafeSetAddress(p);
    }

    public static void R_SetExternalPtrTag(SEXP s, SEXP tag) {
        ((ExternalPtr)s).unsafeSetTag(tag);
    }

    public static void R_SetExternalPtrProtected(SEXP s, SEXP p) {
        ((ExternalPtr)s).unsafeSetProtected(p);
    }

    public static void R_RegisterFinalizer(SEXP s, SEXP fun) {
        throw new UnimplementedGnuApiMethod("R_RegisterFinalizer");
    }

    public static void R_RegisterFinalizerEx(SEXP s, SEXP fun, boolean onexit) {
        Native.currentContext().getSession().registerFinalizer(s, (FinalizationHandler)new FinalizationClosure((Closure)fun), onexit);
    }

    public static void R_RegisterCFinalizer(SEXP s, MethodHandle fun) {
        Rinternals.R_RegisterCFinalizerEx(s, fun, false);
    }

    public static void R_RegisterCFinalizerEx(SEXP s, final MethodHandle fun, boolean onexit) {
        FinalizationHandler handler = new FinalizationHandler(){

            public void finalizeSexp(Context context, SEXP sexp) {
                try {
                    fun.invoke(sexp);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        };
        Native.currentContext().getSession().registerFinalizer(s, handler, onexit);
    }

    public static void R_RunPendingFinalizers() {
        Native.currentContext().getSession().runFinalizers();
    }

    public static SEXP R_MakeWeakRef(SEXP key, SEXP val, SEXP fin, boolean onexit) {
        throw new UnimplementedGnuApiMethod("R_MakeWeakRef");
    }

    public static SEXP R_WeakRefKey(SEXP w) {
        throw new UnimplementedGnuApiMethod("R_WeakRefKey");
    }

    public static SEXP R_WeakRefValue(SEXP w) {
        throw new UnimplementedGnuApiMethod("R_WeakRefValue");
    }

    public static void R_RunWeakRefFinalizer(SEXP w) {
        throw new UnimplementedGnuApiMethod("R_RunWeakRefFinalizer");
    }

    public static SEXP R_PromiseExpr(SEXP x) {
        return ((Promise)x).getExpression();
    }

    public static SEXP R_ClosureExpr(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_ClosureExpr");
    }

    public static void R_initialize_bcode() {
        throw new UnimplementedGnuApiMethod("R_initialize_bcode");
    }

    public static SEXP R_bcEncode(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_bcEncode");
    }

    public static SEXP R_bcDecode(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_bcDecode");
    }

    public static boolean R_ToplevelExec(MethodHandle fun, Ptr data) throws Throwable {
        fun.invoke(data);
        return true;
    }

    public static void R_RestoreHashCount(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_RestoreHashCount");
    }

    public static boolean R_IsPackageEnv(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_IsPackageEnv");
    }

    public static SEXP R_PackageEnvName(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_PackageEnvName");
    }

    public static SEXP R_FindPackageEnv(SEXP info) {
        throw new UnimplementedGnuApiMethod("R_FindPackageEnv");
    }

    public static boolean R_IsNamespaceEnv(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_IsNamespaceEnv");
    }

    public static SEXP R_NamespaceEnvSpec(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_NamespaceEnvSpec");
    }

    public static SEXP R_FindNamespace(SEXP namespaceExp) throws Exception {
        Context context = Native.currentContext();
        return R.primitive.getNamespace.doApply((Context)context, (Environment)context.getEnvironment(), (SEXP)namespaceExp);
    }

    public static void R_LockEnvironment(SEXP env, boolean bindings) {
        throw new UnimplementedGnuApiMethod("R_LockEnvironment");
    }

    public static boolean R_EnvironmentIsLocked(SEXP env) {
        throw new UnimplementedGnuApiMethod("R_EnvironmentIsLocked");
    }

    public static void R_LockBinding(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_LockBinding");
    }

    public static void R_unLockBinding(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_unLockBinding");
    }

    public static void R_MakeActiveBinding(SEXP sym, SEXP fun, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_MakeActiveBinding");
    }

    public static boolean R_BindingIsLocked(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_BindingIsLocked");
    }

    public static boolean R_BindingIsActive(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_BindingIsActive");
    }

    public static boolean R_HasFancyBindings(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_HasFancyBindings");
    }

    public static void Rf_errorcall(SEXP call, Ptr format, Object ... args) {
        String errorMessage = Stdlib.format((Ptr)format, (Object[])args);
        throw new EvalException(errorMessage, new Object[0]);
    }

    public static void Rf_warningcall(SEXP call, Ptr format, Object ... args) {
        Warning.warning((Context)Native.currentContext(), (SEXP)call, (boolean)false, (String)Stdlib.format((Ptr)format, (Object[])new Object[]{new FormatArrayInput(args)}));
    }

    public static void Rf_warningcall_immediate(SEXP call, Ptr format, Object ... args) {
        Warning.warning((Context)Native.currentContext(), (SEXP)call, (boolean)true, (String)Stdlib.format((Ptr)format, (Object[])new Object[]{new FormatArrayInput(args)}));
    }

    public static void R_XDREncodeDouble(double d, Object buf) {
        throw new UnimplementedGnuApiMethod("R_XDREncodeDouble");
    }

    public static double R_XDRDecodeDouble(Object buf) {
        throw new UnimplementedGnuApiMethod("R_XDRDecodeDouble");
    }

    public static void R_XDREncodeInteger(int i, Object buf) {
        throw new UnimplementedGnuApiMethod("R_XDREncodeInteger");
    }

    public static int R_XDRDecodeInteger(Object buf) {
        throw new UnimplementedGnuApiMethod("R_XDRDecodeInteger");
    }

    public static SEXP R_do_slot(SEXP obj, SEXP name) {
        Context context = Native.currentContext();
        MethodDispatch methodDispatch = (MethodDispatch)context.getSingleton(MethodDispatch.class);
        return Subsetting.getSlotValue((Context)context, (MethodDispatch)methodDispatch, (SEXP)obj, (Symbol)((Symbol)name));
    }

    public static SEXP R_do_slot_assign(SEXP obj, SEXP name, SEXP value) {
        if (name instanceof StringVector && Rinternals.LENGTH(name) == 1) {
            name = Symbol.get((String)name.asString());
        } else if (name instanceof GnuCharSexp) {
            name = Symbol.get((String)((GnuCharSexp)name).getValue().nullTerminatedString());
        }
        if (!(name instanceof Symbol)) {
            throw new EvalException("invalid type or length for slot name", new Object[0]);
        }
        if (name.asString().equals(".Data")) {
            return Native.currentContext().evaluate((SEXP)FunctionCall.newCall((SEXP)Symbol.get((String)"setDataPart"), (SEXP[])new SEXP[]{obj, value}), ((MethodDispatch)Native.currentContext().getSingleton(MethodDispatch.class)).getMethodsNamespace());
        }
        Symbol slotValue = value == Null.INSTANCE ? Symbols.S4_NULL : value;
        ((AbstractSEXP)obj).unsafeSetAttributes(obj.getAttributes().copy().set(name.asString(), (SEXP)slotValue));
        return obj;
    }

    public static int R_has_slot(SEXP obj, SEXP name) {
        return Methods.R_has_slot((SEXP)obj, (SEXP)name);
    }

    public static SEXP R_do_MAKE_CLASS(BytePtr what) {
        if (what == null || what.array == null) {
            throw new EvalException("C level MAKE_CLASS macro called with NULL string pointer", new Object[0]);
        }
        Context context = Native.currentContext();
        return Methods.getClass((Context)context, (SEXP)StringVector.valueOf((String)what.nullTerminatedString()), (boolean)false, (SEXP)Null.INSTANCE);
    }

    public static SEXP R_getClassDef(BytePtr what) {
        if (what == null || what.array == null) {
            throw new EvalException("R_getClassDef(.) called with NULL string pointer", new Object[0]);
        }
        return Rinternals.R_getClassDef_R(StringArrayVector.valueOf((String)what.nullTerminatedString()));
    }

    public static SEXP R_getClassDef_R(StringVector what) {
        Context context = Native.currentContext();
        return Methods.getClassDef((Context)context, (StringVector)what, (SEXP)Null.INSTANCE, (SEXP)Null.INSTANCE, (boolean)true);
    }

    public static boolean R_has_methods_attached() {
        throw new UnimplementedGnuApiMethod("R_has_methods_attached");
    }

    public static boolean R_isVirtualClass(SEXP class_def, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_isVirtualClass");
    }

    public static boolean R_extends(SEXP class1, SEXP class2, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_extends");
    }

    public static SEXP R_do_new_object(SEXP class_def) {
        if (class_def == null) {
            throw new EvalException("C level NEW macro called with null class definition pointer", new Object[0]);
        }
        SEXP virtual = Rinternals.R_do_slot(class_def, (SEXP)Symbol.get((String)"virtual"));
        SEXP className = Rinternals.R_do_slot(class_def, (SEXP)Symbol.get((String)"className"));
        if (virtual.asLogical() != Logical.FALSE) {
            throw new EvalException("trying to generate an object from a virtual class (\"%s\")", new Object[]{className.asString()});
        }
        SEXP value = Rinternals.Rf_duplicate(Rinternals.R_do_slot(class_def, (SEXP)Symbol.get((String)"prototype")));
        if (value instanceof S4Object || Rinternals.Rf_getAttrib(className, R_PackageSymbol) != R_NilValue) {
            Rinternals.Rf_setAttrib(value, R_ClassSymbol, className);
            Rinternals.SET_S4_OBJECT(value);
        }
        return value;
    }

    @Deprecated
    public static int R_check_class_and_super(SEXP x, ObjectPtr<BytePtr> valid, SEXP rho) {
        return Rinternals.R_check_class_and_super(x, (Ptr)new PointerPtr((Ptr[])valid.array, valid.offset), rho);
    }

    public static int R_check_class_and_super(SEXP x, Ptr valid, SEXP rho) {
        SEXP cl = Rinternals.Rf_asChar(Rinternals.Rf_getAttrib(x, R_ClassSymbol));
        BytePtr class_ = Rinternals.R_CHAR(cl);
        int ans = 0;
        while (Stdlib.strlen((Ptr)valid.getAlignedPointer(ans)) != 0) {
            if (Stdlib.strcmp((Ptr)class_, (Ptr)valid.getAlignedPointer(ans)) == 0) {
                return ans;
            }
            ++ans;
        }
        if (Rinternals.IS_S4_OBJECT(x) != 0) {
            Symbol s_contains = Symbol.get((String)"contains");
            Symbol s_selectSuperCl = Symbol.get((String)".selectSuperClasses");
            SEXP classDef = Rinternals.R_getClassDef(class_);
            SEXP classExts = Rinternals.R_do_slot(classDef, (SEXP)s_contains);
            SEXP _call = Rinternals.Rf_lang3((SEXP)s_selectSuperCl, classExts, Rinternals.Rf_ScalarLogical(1));
            SEXP superCl = Rinternals.Rf_eval(_call, rho);
            for (int i = 0; i < Rinternals.LENGTH(superCl); ++i) {
                BytePtr s_class = Rinternals.R_CHAR(Rinternals.STRING_ELT(superCl, i));
                ans = 0;
                while (Stdlib.strlen((Ptr)valid.getAlignedPointer(ans)) != 0) {
                    if (Stdlib.strcmp((Ptr)s_class, (Ptr)valid.getAlignedPointer(ans)) == 0) {
                        return ans;
                    }
                    ++ans;
                }
            }
        }
        return -1;
    }

    @Deprecated
    public static int R_check_class_etc(SEXP x, ObjectPtr<BytePtr> valid) {
        return Rinternals.R_check_class_etc(x, (Ptr)new PointerPtr((Ptr[])valid.array, valid.offset));
    }

    public static int R_check_class_etc(SEXP x, Ptr valid) {
        SEXP clEnvCall;
        SEXP cl = Rinternals.Rf_getAttrib(x, R_ClassSymbol);
        SEXP rho = Rinternals.R_GlobalEnv();
        Symbol meth_classEnv = Symbol.get((String)".classEnv");
        SEXP pkg = Rinternals.Rf_getAttrib(cl, R_PackageSymbol);
        if (!Rinternals.Rf_isNull(pkg) && !Rinternals.Rf_isEnvironment(rho = Rinternals.Rf_eval(clEnvCall = Rinternals.Rf_lang2((SEXP)meth_classEnv, cl), (SEXP)Rinternals.methodsNamespace()))) {
            throw new EvalException("could not find correct environment; please report!", new Object[0]);
        }
        return Rinternals.R_check_class_and_super(x, valid, rho);
    }

    private static Environment methodsNamespace() {
        return ((Namespace)Native.currentContext().getNamespaceRegistry().getNamespaceIfPresent(Symbol.get((String)"methods")).get()).getNamespaceEnvironment();
    }

    @Noop
    public static void R_PreserveObject(SEXP p0) {
    }

    @Noop
    public static void R_ReleaseObject(SEXP p0) {
    }

    public static void R_dot_Last() {
        throw new UnimplementedGnuApiMethod("R_dot_Last");
    }

    public static void R_RunExitFinalizers() {
        throw new UnimplementedGnuApiMethod("R_RunExitFinalizers");
    }

    public static int R_system(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("R_system");
    }

    private static final boolean NUM_EQ(int flags) {
        return (flags & 1) == 0;
    }

    private static final boolean SINGLE_NA(int flags) {
        return (flags & 2) == 0;
    }

    private static final boolean ATTR_AS_SET(int flags) {
        return (flags & 4) == 0;
    }

    private static final boolean IGNORE_BYTECODE(int flags) {
        return (flags & 8) == 0;
    }

    public static boolean R_compute_identical(SEXP x, SEXP y, int flags) {
        return Identical.identical((SEXP)x, (SEXP)y, (boolean)Rinternals.NUM_EQ(flags), (boolean)Rinternals.SINGLE_NA(flags), (boolean)Rinternals.ATTR_AS_SET(flags), (boolean)Rinternals.IGNORE_BYTECODE(flags));
    }

    public static void R_orderVector(IntPtr indx, int n, SEXP arglist, boolean nalast, boolean decreasing) {
        throw new UnimplementedGnuApiMethod("R_orderVector");
    }

    @Allocator
    public static SEXP Rf_allocVector(int stype, int length) {
        switch (stype) {
            case 13: {
                return new IntArrayVector(new int[length]);
            }
            case 14: {
                return new DoubleArrayVector(new double[length]);
            }
            case 10: {
                return new LogicalArrayVector(new int[length]);
            }
            case 19: {
                Object[] elements = new SEXP[length];
                Arrays.fill(elements, Null.INSTANCE);
                return new ListVector((SEXP[])elements);
            }
            case 16: {
                GnuCharSexp[] strings = new GnuCharSexp[length];
                Arrays.fill((Object[])strings, (Object)GnuCharSexp.NA_STRING);
                return new GnuStringVector(strings);
            }
            case 2: {
                return new ListVector(Rinternals.elements(length));
            }
            case 20: {
                return new ExpressionVector(Rinternals.elements(length));
            }
            case 24: {
                return new RawVector(new byte[length]);
            }
        }
        throw new UnimplementedGnuApiMethod("Rf_allocVector: type = " + stype);
    }

    private static SEXP[] elements(int length) {
        Object[] array = new SEXP[length];
        Arrays.fill(array, Null.INSTANCE);
        return array;
    }

    public static boolean Rf_conformable(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_conformable");
    }

    public static SEXP Rf_elt(SEXP vector, int index) {
        return vector.getElementAsSEXP(index);
    }

    public static boolean Rf_inherits(SEXP p0, BytePtr p1) {
        return p0.inherits(p1.nullTerminatedString());
    }

    public static boolean Rf_isArray(SEXP p0) {
        return Types.isArray((SEXP)p0);
    }

    public static boolean Rf_isFactor(SEXP p0) {
        return Types.isFactor((SEXP)p0);
    }

    public static boolean Rf_isFrame(SEXP s) {
        return s.inherits("data.frame");
    }

    public static boolean Rf_isFunction(SEXP sexp) {
        return sexp instanceof Function;
    }

    public static boolean Rf_isInteger(SEXP p0) {
        return p0 instanceof IntVector;
    }

    public static boolean Rf_isLanguage(SEXP p0) {
        return p0 instanceof FunctionCall;
    }

    public static boolean Rf_isList(SEXP s) {
        return s == Null.INSTANCE || s instanceof PairList.Node;
    }

    public static boolean Rf_isMatrix(SEXP p0) {
        return Types.isMatrix((SEXP)p0);
    }

    public static boolean Rf_isNewList(SEXP p0) {
        return p0 instanceof ListVector;
    }

    public static boolean Rf_isNumber(SEXP p0) {
        if (p0 instanceof IntVector) {
            return !p0.inherits("factor");
        }
        return p0 instanceof LogicalVector || p0 instanceof DoubleVector || p0 instanceof ComplexVector;
    }

    public static boolean Rf_isNumeric(SEXP p0) {
        return Types.isNumeric((SEXP)p0);
    }

    public static boolean Rf_isPairList(SEXP p0) {
        return Types.isPairList((SEXP)p0);
    }

    public static boolean Rf_isPrimitive(SEXP p0) {
        return p0 instanceof PrimitiveFunction;
    }

    public static boolean Rf_isTs(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isTs");
    }

    public static boolean Rf_isUserBinop(SEXP p0) {
        if (Rinternals.TYPEOF(p0) == 1) {
            BytePtr str = Rinternals.R_CHAR(Rinternals.PRINTNAME(p0));
            int strlen = str.nullTerminatedStringLength();
            return strlen >= 2 && str.getChar(0) == '%' && str.getChar(strlen - 1) == '%';
        }
        return false;
    }

    public static boolean Rf_isValidString(SEXP p0) {
        return Rinternals.TYPEOF(p0) == 16 && Rinternals.LENGTH(p0) > 0 && Rinternals.TYPEOF(Rinternals.STRING_ELT(p0, 0)) != 0;
    }

    public static boolean Rf_isValidStringF(SEXP p0) {
        return Rinternals.Rf_isValidString(p0) && Rinternals.R_CHAR(Rinternals.STRING_ELT(p0, 0)).getChar(0) != '\u0000';
    }

    public static boolean Rf_isVector(SEXP s) {
        return s instanceof Vector;
    }

    public static boolean Rf_isVectorAtomic(SEXP s) {
        return s instanceof AtomicVector;
    }

    public static boolean Rf_isVectorList(SEXP s) {
        return s instanceof ListVector;
    }

    public static boolean Rf_isVectorizable(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isVectorizable");
    }

    public static SEXP Rf_lang1(SEXP p0) {
        return FunctionCall.newCall((SEXP)p0, (SEXP[])new SEXP[0]);
    }

    public static SEXP Rf_lang2(SEXP p0, SEXP p1) {
        return FunctionCall.newCall((SEXP)p0, (SEXP[])new SEXP[]{p1});
    }

    public static SEXP Rf_lang3(SEXP p0, SEXP p1, SEXP p2) {
        return FunctionCall.newCall((SEXP)p0, (SEXP[])new SEXP[]{p1, p2});
    }

    public static SEXP Rf_lang4(SEXP p0, SEXP p1, SEXP p2, SEXP p3) {
        return FunctionCall.newCall((SEXP)p0, (SEXP[])new SEXP[]{p1, p2, p3});
    }

    public static SEXP Rf_lang5(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4) {
        return FunctionCall.newCall((SEXP)p0, (SEXP[])new SEXP[]{p1, p2, p3, p4});
    }

    public static SEXP Rf_lang6(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4, SEXP p5) {
        return FunctionCall.newCall((SEXP)p0, (SEXP[])new SEXP[]{p1, p2, p3, p4, p5});
    }

    public static SEXP Rf_lastElt(SEXP list) {
        Null result = Null.INSTANCE;
        while (list != Null.INSTANCE) {
            result = list;
            list = Rinternals.CDR(list);
        }
        return result;
    }

    public static SEXP Rf_lcons(SEXP cr, SEXP tl) {
        return new FunctionCall(cr, (PairList)tl);
    }

    public static int Rf_length(SEXP sexp) {
        return sexp.length();
    }

    public static SEXP Rf_lengthgets(SEXP sexp, int length) {
        return Vectors.setLength((Vector)((Vector)sexp), (int)length);
    }

    public static SEXP Rf_list1(SEXP p0) {
        return new PairList.Node(p0, (PairList)Null.INSTANCE);
    }

    public static SEXP Rf_list2(SEXP p0, SEXP p1) {
        return new PairList.Node(p0, (PairList)new PairList.Node(p1, (PairList)Null.INSTANCE));
    }

    public static SEXP Rf_list3(SEXP p0, SEXP p1, SEXP p2) {
        return new PairList.Node(p0, (PairList)new PairList.Node(p1, (PairList)new PairList.Node(p2, (PairList)Null.INSTANCE)));
    }

    public static SEXP Rf_list4(SEXP p0, SEXP p1, SEXP p2, SEXP p3) {
        return new PairList.Node(p0, (PairList)new PairList.Node(p1, (PairList)new PairList.Node(p2, (PairList)new PairList.Node(p3, (PairList)Null.INSTANCE))));
    }

    public static SEXP Rf_list5(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4) {
        return new PairList.Node(p0, (PairList)new PairList.Node(p1, (PairList)new PairList.Node(p2, (PairList)new PairList.Node(p3, (PairList)new PairList.Node(p4, (PairList)Null.INSTANCE)))));
    }

    public static SEXP Rf_listAppend(SEXP s, SEXP t) {
        if (s == R_NilValue) {
            return t;
        }
        SEXP r = s;
        while (Rinternals.CDR(r) != R_NilValue) {
            r = Rinternals.CDR(r);
        }
        Rinternals.SETCDR(r, t);
        return s;
    }

    @Deprecated
    public static SEXP Rf_mkNamed(int sexpType, ObjectPtr<BytePtr> names) {
        return Rinternals.Rf_mkNamed(sexpType, (Ptr)new PointerPtr((Ptr[])names.array, names.offset));
    }

    public static SEXP Rf_mkNamed(int sexpType, Ptr names) {
        if (sexpType == 19) {
            String name;
            ListVector.NamedBuilder list = new ListVector.NamedBuilder();
            int i = 0;
            while (!(name = Stdlib.nullTerminatedString((Ptr)names.getAlignedPointer(i))).isEmpty()) {
                list.add(name, (SEXP)Null.INSTANCE);
                ++i;
            }
            return list.build();
        }
        throw new UnsupportedOperationException("mkNamed: type = " + sexpType);
    }

    @Deprecated
    public static SEXP Rf_mkString(BytePtr string) {
        return Rinternals.Rf_mkString((Ptr)string);
    }

    public static SEXP Rf_mkString(Ptr string) {
        return new StringArrayVector(new String[]{Stdlib.nullTerminatedString((Ptr)string)});
    }

    public static int Rf_nlevels(SEXP p0) {
        if (!Types.isFactor((SEXP)p0)) {
            return 0;
        }
        return Rinternals.LENGTH(p0.getAttribute(Symbol.get((String)"levels")));
    }

    public static int Rf_stringPositionTr(SEXP p0, BytePtr p1) {
        throw new UnimplementedGnuApiMethod("Rf_stringPositionTr");
    }

    public static SEXP Rf_ScalarInteger(int p0) {
        return new IntArrayVector(new int[]{p0});
    }

    public static SEXP Rf_ScalarLogical(int p0) {
        if (p0 == LogicalVector.NA) {
            return LogicalVector.NA_VECTOR;
        }
        if (p0 == 0) {
            return LogicalVector.FALSE;
        }
        return LogicalVector.TRUE;
    }

    public static SEXP Rf_ScalarReal(double p0) {
        return new DoubleArrayVector(new double[]{p0});
    }

    public static SEXP Rf_ScalarString(SEXP p0) {
        return new GnuStringVector((GnuCharSexp)p0);
    }

    public static int Rf_xlength(SEXP p0) {
        return p0.length();
    }

    public static SEXP Rf_protect(SEXP node) {
        return node;
    }

    @Noop
    public static void Rf_unprotect(int count) {
    }

    @Deprecated
    public static void R_ProtectWithIndex(SEXP node, IntPtr iptr) {
    }

    @Noop
    public static void R_ProtectWithIndex(SEXP node, Ptr iptr) {
    }

    @Noop
    public static void R_Reprotect(SEXP node, int index) {
    }

    public static SEXP R_FixupRHS(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("R_FixupRHS");
    }

    static {
        R_EmptyEnv = Environment.EMPTY;
        R_NilValue = Null.INSTANCE;
        R_UnboundValue = Symbol.UNBOUND_VALUE;
        R_MissingArg = Symbol.MISSING_ARG;
        R_baseSymbol = Symbol.get((String)"base");
        R_BaseSymbol = Symbol.get((String)"base");
        R_BraceSymbol = Symbol.get((String)"{");
        R_Bracket2Symbol = Symbol.get((String)"[[");
        R_BracketSymbol = Symbol.get((String)"[");
        R_ClassSymbol = Symbol.get((String)"class");
        R_DeviceSymbol = Symbol.get((String)".Device");
        R_DimNamesSymbol = Symbol.get((String)"dimnames");
        R_DimSymbol = Symbol.get((String)"dim");
        R_DollarSymbol = Symbol.get((String)"$");
        R_DotsSymbol = Symbol.get((String)"...");
        R_DoubleColonSymbol = Symbol.get((String)"::");
        R_DropSymbol = Symbol.get((String)"drop");
        R_LastvalueSymbol = Symbol.get((String)".Last.value");
        R_LevelsSymbol = Symbol.get((String)"levels");
        R_ModeSymbol = Symbol.get((String)"mode");
        R_NaRmSymbol = Symbol.get((String)"na.rm");
        R_NameSymbol = Symbol.get((String)"name");
        R_NamesSymbol = Symbol.get((String)"names");
        R_NamespaceEnvSymbol = Symbol.get((String)".__NAMESPACE__.");
        R_PackageSymbol = Symbol.get((String)"package");
        R_PreviousSymbol = Symbol.get((String)"previous");
        R_QuoteSymbol = Symbol.get((String)"quote");
        R_RowNamesSymbol = Symbol.get((String)"row.names");
        R_SeedsSymbol = Symbol.get((String)".Random.seed");
        R_SortListSymbol = Symbol.get((String)"sort.list");
        R_SourceSymbol = Symbol.get((String)"source");
        R_SpecSymbol = Symbol.get((String)"spec");
        R_TripleColonSymbol = Symbol.get((String)":::");
        R_TspSymbol = Symbol.get((String)"tsp");
        R_dot_defined = Symbol.get((String)".defined");
        R_dot_Method = Symbol.get((String)".Method");
        R_dot_packageName = Symbol.get((String)".packageName");
        R_dot_target = Symbol.get((String)".target");
        R_NaString = GnuCharSexp.NA_STRING;
        R_BlankString = GnuCharSexp.BLANK_STRING;
        R_BlankScalarString = new GnuStringVector(GnuCharSexp.BLANK_STRING);
    }
}

