/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.nio.charset.Charset;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class GnuCharSexp
extends AbstractSEXP {
    public static final GnuCharSexp NA_STRING = new GnuCharSexp(new byte[]{78, 65, 0});
    public static final GnuCharSexp BLANK_STRING = new GnuCharSexp(new byte[]{0});
    private byte[] value;

    public GnuCharSexp(byte[] value) {
        this.value = value;
    }

    public GnuCharSexp(Symbol symbol) {
        this(symbol.getPrintName().getBytes(Charsets.UTF_8));
    }

    public static GnuCharSexp valueOf(String value) {
        if (StringVector.isNA((String)value)) {
            return NA_STRING;
        }
        if (value.isEmpty()) {
            return BLANK_STRING;
        }
        return new GnuCharSexp(BytePtr.nullTerminatedString((String)value, (Charset)Charsets.UTF_8).array);
    }

    public int length() {
        return Stdlib.strlen((Ptr)new BytePtr(this.value));
    }

    public String getTypeName() {
        return "char";
    }

    public void accept(SexpVisitor visitor) {
    }

    public BytePtr getValue() {
        return new BytePtr(this.value, 0);
    }
}

