/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.sexp.AtomicVector;

public final class IntVectorPtr
extends AbstractPtr {
    private AtomicVector vector;
    private int offset;

    public IntVectorPtr(AtomicVector vector, int offset) {
        this.vector = vector;
        this.offset = offset;
    }

    public Object getArray() {
        return this.vector;
    }

    public final int getOffsetInBytes() {
        return this.offset * 4;
    }

    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        if (bytes % 4 == 0) {
            return new IntVectorPtr(this.vector, this.offset + bytes / 4);
        }
        return new OffsetPtr((Ptr)this, bytes);
    }

    public int getAlignedInt(int index) {
        return this.vector.getElementAsInt(this.offset + index);
    }

    public int getInt(int offset) {
        if (offset % 4 == 0) {
            return this.getAlignedInt(offset / 4);
        }
        return super.getInt(offset);
    }

    public byte getByte(int offset) {
        return this.getByteViaInt(offset);
    }

    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("Illegal modification of a shared vector! Mis-behaving C/C++ code has tried to modify a vector that it should not.");
    }

    public int toInt() {
        return this.offset * 4;
    }

    public boolean isNull() {
        return false;
    }
}

