/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.sexp.AtomicVector;

public class DoubleVectorPtr
extends AbstractPtr {
    private AtomicVector vector;
    private int offset;

    public DoubleVectorPtr(AtomicVector vector, int offset) {
        this.vector = vector;
        this.offset = offset;
    }

    public Object getArray() {
        return this.vector;
    }

    public final int getOffsetInBytes() {
        return this.offset * 8;
    }

    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        if (bytes % 8 == 0) {
            return new DoubleVectorPtr(this.vector, this.offset + bytes / 8);
        }
        return new OffsetPtr((Ptr)this, bytes);
    }

    public double getAlignedDouble(int index) {
        return this.vector.getElementAsDouble(this.offset + index);
    }

    public double getDouble(int offset) {
        if (offset % 8 == 0) {
            return this.getAlignedDouble(offset / 8);
        }
        return super.getDouble(offset);
    }

    public byte getByte(int bytes) {
        return this.getByteViaDouble(bytes);
    }

    public void setByte(int offset, byte value) {
        throw new UnsupportedOperationException("Illegal modification of a shared vector! Mis-behaving C/C++ code has tried to modify a vector that it should not.");
    }

    public int toInt() {
        return this.offset * 8;
    }

    public boolean isNull() {
        return false;
    }
}

