/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.parser.RParser;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;

public final class Parse {
    private static final int PARSE_NULL = 0;
    private static final int PARSE_OK = 1;
    private static final int PARSE_INCOMPLETE = 2;
    private static final int PARSE_ERROR = 3;
    private static final int PARSE_EOF = 4;

    private Parse() {
    }

    public static SEXP R_ParseVector(SEXP text, int n, Ptr status, SEXP srcfile) {
        StringVector textVector = (StringVector)text;
        StringBuilder source = new StringBuilder();
        for (String line : textVector) {
            source.append(line);
            if (source.length() <= 0 || source.charAt(source.length() - 1) == '\n') continue;
            source.append('\n');
        }
        StringReader reader = new StringReader(source.toString());
        RParser parser = new RParser((Reader)reader);
        ArrayList exprList = Lists.newArrayList();
        try {
            while (!parser.isEof()) {
                if (!parser.parse()) {
                    switch (parser.getResultStatus()) {
                        case EMPTY: {
                            status.setInt(0);
                            break;
                        }
                        case OK: {
                            status.setInt(1);
                            break;
                        }
                        case INCOMPLETE: {
                            status.setInt(2);
                            break;
                        }
                        case ERROR: {
                            status.setInt(3);
                            break;
                        }
                        case EOF: {
                            status.setInt(4);
                        }
                    }
                    return Null.INSTANCE;
                }
                exprList.add(parser.getResult());
            }
        }
        catch (IOException e) {
            status.setInt(3);
            return Null.INSTANCE;
        }
        if (exprList.size() > 0) {
            status.setInt(1);
        }
        return new ExpressionVector((List)exprList);
    }
}

