/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.renjin.eval.Context;
import org.renjin.gcc.runtime.AbstractFileHandle;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.FileHandle;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.RecordUnitPtr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.gnur.api.UnimplementedGnuApiMethod;
import org.renjin.primitives.Native;

public class RenjinFiles {
    public static Ptr R_fopen(Ptr filename, Ptr mode) {
        return RenjinFiles.fopen(filename, mode);
    }

    public static Ptr R_gzopen(Ptr path, Ptr mode) throws IOException {
        FileContent content;
        FileObject fileObject = RenjinFiles.resolveFileObject(path);
        if (fileObject == null) {
            return BytePtr.NULL;
        }
        try {
            content = fileObject.getContent();
        }
        catch (FileSystemException e) {
            return BytePtr.NULL;
        }
        try {
            switch (Stdlib.nullTerminatedString((Ptr)mode)) {
                case "r": 
                case "rb": {
                    return new RecordUnitPtr((Object)new InputStreamHandle(() -> RenjinFiles.openGzInputStream(content)));
                }
            }
            throw new UnsupportedOperationException("mode: " + mode);
        }
        catch (FileSystemException e) {
            return BytePtr.NULL;
        }
    }

    private static InputStream openGzInputStream(FileContent content) throws IOException {
        boolean gzip;
        InputStream in = content.getInputStream();
        if (in.markSupported()) {
            in.mark(2);
        }
        int b1 = in.read();
        int b2 = in.read();
        boolean bl = gzip = b1 == 31 && b2 == 139;
        if (in.markSupported()) {
            in.reset();
        } else {
            in.close();
            in = content.getInputStream();
        }
        if (gzip) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    public static Ptr R_gzgets(Ptr file, Ptr buf, int len) {
        return Stdlib.fgets((Ptr)buf, (int)len, (Ptr)file);
    }

    public static int R_gzclose(Ptr file) throws IOException {
        FileHandle handle = (FileHandle)file.getArray();
        handle.close();
        return 0;
    }

    public static Ptr R_popen(Ptr filename, Ptr mode) {
        throw new UnsupportedOperationException("R_popen");
    }

    public static int pclose(Ptr stream) {
        throw new UnsupportedOperationException("pclose");
    }

    public static Ptr fopen64(Ptr filename, Ptr mode) {
        return RenjinFiles.fopen(filename, mode);
    }

    public static Ptr fopen(Ptr filename, Ptr mode) {
        String modeString = Stdlib.nullTerminatedString((Ptr)mode);
        FileObject fileObject = RenjinFiles.resolveFileObject(filename);
        if (fileObject == null) {
            return BytePtr.NULL;
        }
        try {
            return new RecordUnitPtr((Object)RenjinFiles.fopen(fileObject, modeString));
        }
        catch (IOException e) {
            return BytePtr.NULL;
        }
    }

    private static FileObject resolveFileObject(Ptr filename) {
        FileObject fileObject;
        String filenameString = Stdlib.nullTerminatedString((Ptr)filename);
        try {
            Context context = Native.currentContext();
            String homeDirectory = context.getSession().getHomeDirectory();
            String libraryDirectory = homeDirectory + "/library/";
            if (filenameString.startsWith(libraryDirectory)) {
                String relativePath = filenameString.substring(libraryDirectory.length()).replace('\\', '/');
                int packageEnd = relativePath.indexOf(47);
                String packageName = relativePath.substring(0, packageEnd);
                String packageFile = relativePath.substring(packageEnd + 1);
                fileObject = context.getNamespaceRegistry().getNamespace(context, packageName).getPackage().resolvePackageResource(context.getFileSystemManager(), packageFile);
            } else {
                fileObject = context.resolveFile(filenameString);
            }
        }
        catch (FileSystemException e) {
            fileObject = null;
        }
        return fileObject;
    }

    public static void unlink(Ptr fname) throws FileSystemException {
        FileObject fileObject = Native.currentContext().resolveFile(Stdlib.nullTerminatedString((Ptr)fname));
        fileObject.delete();
    }

    public static Ptr realpath(Ptr path, Ptr resolvedPath) {
        throw new UnimplementedGnuApiMethod("realpath");
    }

    public static int compress(Ptr dest, Ptr destLength, Ptr source, int sourceLength) {
        if (dest instanceof BytePtr && source instanceof BytePtr) {
            BytePtr sourceBytePtr = (BytePtr)source;
            BytePtr destBytePtr = (BytePtr)dest;
            Deflater deflater = new Deflater();
            deflater.setInput(sourceBytePtr.array, source.getOffsetInBytes(), sourceLength);
            deflater.finish();
            destLength.setInt(deflater.deflate(destBytePtr.array, destBytePtr.offset, destBytePtr.array.length - destBytePtr.offset));
            return 0;
        }
        throw new UnimplementedGnuApiMethod("compress: " + source.getClass().getName() + " => " + dest.getClass().getName());
    }

    public static int chdir(Ptr path) {
        throw new UnimplementedGnuApiMethod("chdir");
    }

    public static Ptr getcwd(Ptr ptr, int size) {
        throw new UnimplementedGnuApiMethod("getcwd");
    }

    private static FileHandle fopen(FileObject fileObject, String mode) throws IOException {
        if (fileObject instanceof LocalFile) {
            String localFile = fileObject.getURL().getFile();
            return Stdlib.openFile((String)localFile, (String)mode);
        }
        switch (mode) {
            case "r": 
            case "rb": {
                return new InputStreamHandle(() -> fileObject.getContent().getInputStream());
            }
            case "w": 
            case "wb": {
                return new OutputStreamHandle(fileObject.getContent().getOutputStream());
            }
            case "w+b": {
                return new OutputStreamHandle(fileObject.getContent().getOutputStream(true));
            }
        }
        throw new UnsupportedOperationException("mode: " + mode);
    }

    private static class OutputStreamHandle
    extends AbstractFileHandle {
        private OutputStream outputStream;
        private long position;

        public OutputStreamHandle(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public int read() throws IOException {
            throw new UnsupportedOperationException("Cannot read from output stream handle.");
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
            ++this.position;
        }

        public void rewind() throws IOException {
            throw new UnsupportedOperationException("TODO");
        }

        public void flush() throws IOException {
            this.outputStream.flush();
        }

        public void close() throws IOException {
            this.outputStream.close();
        }

        public void seekSet(long offset) throws IOException {
            throw new UnsupportedOperationException("TODO");
        }

        public void seekCurrent(long offset) throws IOException {
            throw new UnsupportedOperationException("TODO");
        }

        public void seekEnd(long offset) {
            throw new UnsupportedOperationException("TODO");
        }

        public boolean isEof() {
            return false;
        }

        public long position() throws IOException {
            return this.position;
        }
    }

    private static class InputStreamHandle
    extends AbstractFileHandle {
        private final StreamSupplier<InputStream> supplier;
        private InputStream inputStream;
        private long position = 0L;
        private boolean eof;

        public InputStreamHandle(StreamSupplier<InputStream> supplier) throws IOException {
            this.supplier = supplier;
            this.inputStream = supplier.get();
        }

        public int read() throws IOException {
            int b = this.inputStream.read();
            if (b == -1) {
                this.eof = true;
            } else {
                ++this.position;
            }
            return b;
        }

        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("Cannot write on input stream handle.");
        }

        public void rewind() throws IOException {
            this.inputStream.close();
            this.inputStream = this.supplier.get();
            this.position = 0L;
            this.eof = false;
        }

        public void flush() throws IOException {
            throw new UnsupportedOperationException("Cannot flush an input stream handle.");
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public void seekSet(long offset) throws IOException {
            if (offset < this.position) {
                throw new IOException("Cannot rewind the stream");
            }
            long toSkip = offset - this.position;
            long skipped = this.inputStream.skip(toSkip);
            if (skipped < toSkip) {
                throw new EOFException();
            }
        }

        public void seekCurrent(long offset) throws IOException {
            long skipped = this.inputStream.skip(offset);
            if (skipped < offset) {
                throw new EOFException();
            }
        }

        public void seekEnd(long offset) {
            throw new UnsupportedOperationException("TODO");
        }

        public boolean isEof() {
            return this.eof;
        }

        public long position() throws IOException {
            return this.position;
        }
    }

    private static interface StreamSupplier<T> {
        public T get() throws IOException;
    }
}

