/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.cache;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import org.renjin.repackaged.guava.annotations.GwtIncompatible;
import org.renjin.repackaged.guava.cache.AbstractCache;
import org.renjin.repackaged.guava.cache.LoadingCache;
import org.renjin.repackaged.guava.collect.ImmutableMap;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.util.concurrent.UncheckedExecutionException;

@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

