/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.graph;

import org.renjin.repackaged.guava.graph.AbstractGraphBuilder;
import org.renjin.repackaged.guava.graph.BaseGraph;
import org.renjin.repackaged.guava.graph.ConfigurableMutableValueGraph;
import org.renjin.repackaged.guava.graph.EndpointPair;
import org.renjin.repackaged.guava.graph.ForwardingGraph;
import org.renjin.repackaged.guava.graph.GraphConstants;
import org.renjin.repackaged.guava.graph.MutableGraph;
import org.renjin.repackaged.guava.graph.MutableValueGraph;

final class ConfigurableMutableGraph<N>
extends ForwardingGraph<N>
implements MutableGraph<N> {
    private final MutableValueGraph<N, GraphConstants.Presence> backingValueGraph;

    ConfigurableMutableGraph(AbstractGraphBuilder<? super N> builder) {
        this.backingValueGraph = new ConfigurableMutableValueGraph<N, GraphConstants.Presence>(builder);
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingValueGraph;
    }

    @Override
    public boolean addNode(N node) {
        return this.backingValueGraph.addNode(node);
    }

    @Override
    public boolean putEdge(N nodeU, N nodeV) {
        return this.backingValueGraph.putEdgeValue(nodeU, nodeV, GraphConstants.Presence.EDGE_EXISTS) == null;
    }

    @Override
    public boolean putEdge(EndpointPair<N> endpoints) {
        this.validateEndpoints(endpoints);
        return this.putEdge(endpoints.nodeU(), endpoints.nodeV());
    }

    @Override
    public boolean removeNode(N node) {
        return this.backingValueGraph.removeNode(node);
    }

    @Override
    public boolean removeEdge(N nodeU, N nodeV) {
        return this.backingValueGraph.removeEdge(nodeU, nodeV) != null;
    }

    @Override
    public boolean removeEdge(EndpointPair<N> endpoints) {
        this.validateEndpoints(endpoints);
        return this.removeEdge(endpoints.nodeU(), endpoints.nodeV());
    }
}

