/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.graph;

import java.util.AbstractSet;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.ImmutableSet;
import org.renjin.repackaged.guava.collect.Iterators;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;

final class EdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<?, E> nodeToOutEdge;
    private final Object targetNode;

    EdgesConnecting(Map<?, E> nodeToEdgeMap, Object targetNode) {
        this.nodeToOutEdge = Preconditions.checkNotNull(nodeToEdgeMap);
        this.targetNode = Preconditions.checkNotNull(targetNode);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator(connectingEdge);
    }

    @Override
    public int size() {
        return this.getConnectingEdge() == null ? 0 : 1;
    }

    @Override
    public boolean contains(@Nullable Object edge) {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge != null && connectingEdge.equals(edge);
    }

    private @Nullable E getConnectingEdge() {
        return this.nodeToOutEdge.get(this.targetNode);
    }
}

