/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.graph;

import org.renjin.repackaged.guava.annotations.Beta;
import org.renjin.repackaged.guava.base.Optional;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.graph.AbstractGraphBuilder;
import org.renjin.repackaged.guava.graph.ConfigurableMutableGraph;
import org.renjin.repackaged.guava.graph.ElementOrder;
import org.renjin.repackaged.guava.graph.Graph;
import org.renjin.repackaged.guava.graph.Graphs;
import org.renjin.repackaged.guava.graph.ImmutableGraph;
import org.renjin.repackaged.guava.graph.MutableGraph;

@Beta
public final class GraphBuilder<N>
extends AbstractGraphBuilder<N> {
    private GraphBuilder(boolean directed) {
        super(directed);
    }

    public static GraphBuilder<Object> directed() {
        return new GraphBuilder<Object>(true);
    }

    public static GraphBuilder<Object> undirected() {
        return new GraphBuilder<Object>(false);
    }

    public static <N> GraphBuilder<N> from(Graph<N> graph) {
        return new GraphBuilder<N>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder());
    }

    public <N1 extends N> ImmutableGraph.Builder<N1> immutable() {
        GraphBuilder<N1> castBuilder = this.cast();
        return new ImmutableGraph.Builder<N1>(castBuilder);
    }

    public GraphBuilder<N> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    public GraphBuilder<N> expectedNodeCount(int expectedNodeCount) {
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative(expectedNodeCount));
        return this;
    }

    public <N1 extends N> GraphBuilder<N1> nodeOrder(ElementOrder<N1> nodeOrder) {
        GraphBuilder<N1> newBuilder = this.cast();
        newBuilder.nodeOrder = Preconditions.checkNotNull(nodeOrder);
        return newBuilder;
    }

    public <N1 extends N> MutableGraph<N1> build() {
        return new ConfigurableMutableGraph(this);
    }

    private <N1 extends N> GraphBuilder<N1> cast() {
        return this;
    }
}

