/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.graph;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import org.renjin.repackaged.guava.annotations.Beta;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.base.Functions;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.ImmutableMap;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.graph.BaseGraph;
import org.renjin.repackaged.guava.graph.ConfigurableValueGraph;
import org.renjin.repackaged.guava.graph.DirectedGraphConnections;
import org.renjin.repackaged.guava.graph.EndpointPair;
import org.renjin.repackaged.guava.graph.ForwardingGraph;
import org.renjin.repackaged.guava.graph.Graph;
import org.renjin.repackaged.guava.graph.GraphBuilder;
import org.renjin.repackaged.guava.graph.GraphConnections;
import org.renjin.repackaged.guava.graph.GraphConstants;
import org.renjin.repackaged.guava.graph.MutableGraph;
import org.renjin.repackaged.guava.graph.UndirectedGraphConnections;

@Immutable(containerOf={"N"})
@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new ConfigurableValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors((Object)node), Maps.asMap(graph.successors((Object)node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingGraph;
    }

    public static class Builder<N> {
        private final MutableGraph<N> mutableGraph;

        Builder(GraphBuilder<N> graphBuilder) {
            this.mutableGraph = graphBuilder.build();
        }

        @CanIgnoreReturnValue
        public Builder<N> addNode(N node) {
            this.mutableGraph.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(N nodeU, N nodeV) {
            this.mutableGraph.putEdge(nodeU, nodeV);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N> putEdge(EndpointPair<N> endpoints) {
            this.mutableGraph.putEdge(endpoints);
            return this;
        }

        public ImmutableGraph<N> build() {
            return ImmutableGraph.copyOf(this.mutableGraph);
        }
    }
}

