/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.math;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.math.Errors;
import org.renjin.math.dlamch__;
import org.renjin.math.dlansy__;
import org.renjin.math.dlascl__;
import org.renjin.math.dorgtr__;
import org.renjin.math.dscal__;
import org.renjin.math.dsteqr__;
import org.renjin.math.dsterf__;
import org.renjin.math.dsytrd__;
import org.renjin.math.ilaenv__;
import org.renjin.math.lsame__;

public class dsyev__ {
    private dsyev__() {
    }

    public static void dsyev_(Ptr jobz, Ptr uplo, Ptr n, Ptr a, Ptr lda, Ptr w, Ptr work, Ptr lwork, Ptr info, int _jobz, int _uplo) {
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        double[] sigma = new double[1];
        int[] llwork = new int[1];
        int[] imax = new int[1];
        int[] iinfo = new int[1];
        sigma[0] = 0.0;
        int lwkopt = 0;
        iinfo[0] = 0;
        int stride$1 = lda.getInt();
        stride$1 = Math.max(stride$1, 0);
        int offset$2 = ~stride$1;
        boolean wantz = lsame__.lsame_(jobz, (Ptr)new BytePtr("V".getBytes(), 0), 1, 1);
        boolean lower = lsame__.lsame_(uplo, (Ptr)new BytePtr("L".getBytes(), 0), 1, 1);
        boolean lquery = lwork.getInt() == -1;
        info.setInt(0);
        if (wantz ^ true && lsame__.lsame_(jobz, (Ptr)new BytePtr("N".getBytes(), 0), 1, 1) ^ true) {
            info.setInt(-1);
        } else if (lower ^ true && lsame__.lsame_(uplo, (Ptr)new BytePtr("U".getBytes(), 0), 1, 1) ^ true) {
            info.setInt(-2);
        } else if (n.getInt() < 0) {
            info.setInt(-3);
        } else {
            int M$3 = 1;
            int n2 = n.getInt();
            if (n2 > M$3) {
                M$3 = n2;
            }
            if (lda.getInt() < M$3) {
                info.setInt(-5);
            }
        }
        if (info.getInt() == 0) {
            int nb = ilaenv__.ilaenv_((Ptr)new IntPtr(new int[]{1}, 0), (Ptr)new BytePtr("DSYTRD".getBytes(), 0), uplo, n, (Ptr)new IntPtr(new int[]{-1}, 0), (Ptr)new IntPtr(new int[]{-1}, 0), (Ptr)new IntPtr(new int[]{-1}, 0), 6, 1);
            int M$4 = 1;
            int n3 = nb + 2;
            int n4 = n.getInt();
            int n5 = n3 * n4;
            if (n5 > M$4) {
                M$4 = n5;
            }
            lwkopt = M$4;
            double d = lwkopt;
            work.setDouble(d);
            int M$5 = 1;
            int n6 = n.getInt() * 3 + -1;
            if (n6 > M$5) {
                M$5 = n6;
            }
            if (lwork.getInt() < M$5 && lquery ^ true) {
                info.setInt(-8);
            }
        }
        if (info.getInt() != 0) {
            int n7;
            nArray[0] = n7 = -info.getInt();
            Errors.xerbla_((BytePtr)new BytePtr("DSYEV ".getBytes(), 0), (IntPtr)new IntPtr(nArray, 0), (int)6);
        } else if (!lquery && n.getInt() != 0) {
            if (n.getInt() == 1) {
                int n8 = offset$2 + stride$1 + 1;
                double d = a.getAlignedDouble(n8);
                w.setDouble(d);
                work.setDouble(2.0);
                if (wantz) {
                    int n9 = offset$2 + stride$1 + 1;
                    a.setAlignedDouble(n9, 1.0);
                }
            } else {
                int llwork$8;
                double safmin = dlamch__.dlamch_((Ptr)new BytePtr("Safe minimum".getBytes(), 0), 12);
                double eps = dlamch__.dlamch_((Ptr)new BytePtr("Precision".getBytes(), 0), 9);
                double smlnum = safmin / eps;
                double bignum = 1.0 / smlnum;
                double rmin = Mathlib.sqrt((double)smlnum);
                double rmax = Mathlib.sqrt((double)bignum);
                double anrm = dlansy__.dlansy_((Ptr)new BytePtr("M".getBytes(), 0), uplo, n, a, lda, work, 1, 1);
                boolean iscale = false;
                if (anrm > 0.0 && anrm < rmin) {
                    double sigma$6;
                    iscale = true;
                    sigma[0] = sigma$6 = rmin / anrm;
                } else if (anrm > rmax) {
                    double sigma$7;
                    iscale = true;
                    sigma[0] = sigma$7 = rmax / anrm;
                }
                if (iscale) {
                    Ptr ptr = n;
                    dlascl__.dlascl_(uplo, (Ptr)new IntPtr(new int[]{0}, 0), (Ptr)new IntPtr(new int[]{0}, 0), (Ptr)new DoublePtr(new double[]{1.0}, 0), (Ptr)new DoublePtr(sigma, 0), ptr, ptr, a, lda, info, 1);
                }
                int indtau = n.getInt() + 1;
                int indwrk = n.getInt() + indtau;
                llwork[0] = llwork$8 = lwork.getInt() - indwrk + 1;
                int n10 = indwrk + -1;
                Ptr ptr = work;
                int n11 = n10 * 8;
                int n12 = indtau + -1;
                Ptr ptr2 = work;
                int n13 = n12 * 8;
                Ptr ptr3 = work;
                dsytrd__.dsytrd_(uplo, n, a, lda, w, ptr3, ptr2.pointerPlus(n13), ptr.pointerPlus(n11), (Ptr)new IntPtr(llwork, 0), (Ptr)new IntPtr(iinfo, 0), 1);
                if (wantz ^ true) {
                    Ptr ptr4 = work;
                    dsterf__.dsterf_(n, w, ptr4, info);
                } else {
                    int n14 = indwrk + -1;
                    Ptr ptr5 = work;
                    int n15 = n14 * 8;
                    int n16 = indtau + -1;
                    Ptr ptr6 = work;
                    int n17 = n16 * 8;
                    dorgtr__.dorgtr_(uplo, n, a, lda, ptr6.pointerPlus(n17), ptr5.pointerPlus(n15), (Ptr)new IntPtr(llwork, 0), (Ptr)new IntPtr(iinfo, 0), 1);
                    int n18 = indtau + -1;
                    Ptr ptr7 = work;
                    int n19 = n18 * 8;
                    Ptr ptr8 = work;
                    dsteqr__.dsteqr_(jobz, n, w, ptr8, a, lda, ptr7.pointerPlus(n19), info, 1);
                }
                if (iscale) {
                    double d;
                    int imax$10;
                    int imax$9;
                    imax[0] = info.getInt() == 0 ? (imax$9 = n.getInt()) : (imax$10 = info.getInt() + -1);
                    double sigma$11 = sigma[0];
                    dArray[0] = d = 1.0 / sigma$11;
                    dscal__.dscal_((Ptr)new IntPtr(imax, 0), (Ptr)new DoublePtr(dArray, 0), w, (Ptr)new IntPtr(new int[]{1}, 0));
                }
                double d = lwkopt;
                work.setDouble(d);
            }
        }
    }
}

