/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;

public class cospi {
    private cospi() {
    }

    public static double cospi(double d) {
        if (Builtins.__isnan((double)d) != 0) {
        } else if (Builtins.__finite((double)d) == 0) {
            d = Double.NaN;
        } else {
            d = Mathlib.fmod((double)Math.abs(d), (double)2.0);
            d = Mathlib.fmod((double)d, (double)1.0) == 0.5 ? 0.0 : (d == 1.0 ? -1.0 : (d == 0.0 ? 1.0 : Mathlib.cos((double)(d * Math.PI))));
        }
        return d;
    }

    public static double sinpi(double d) {
        if (Builtins.__isnan((double)d) != 0) {
        } else if (Builtins.__finite((double)d) == 0) {
            d = Double.NaN;
        } else {
            d = Mathlib.fmod((double)d, (double)2.0);
            if (d <= -1.0) {
                d += 2.0;
            } else if (d > 1.0) {
                d -= 2.0;
            }
            d = d == 0.0 || d == 1.0 ? 0.0 : (d == 0.5 ? 1.0 : (d == -0.5 ? -1.0 : Mathlib.sin((double)(d * Math.PI))));
        }
        return d;
    }

    public static double tanpi(double d) {
        if (Builtins.__isnan((double)d) != 0) {
        } else if (Builtins.__finite((double)d) == 0) {
            d = Double.NaN;
        } else {
            d = Mathlib.fmod((double)d, (double)1.0);
            if (d <= -0.5) {
                d += 1.0;
            } else if (d > 0.5) {
                d -= 1.0;
            }
            d = d != 0.0 ? (d != 0.5 ? Mathlib.tan((double)(d * Math.PI)) : Double.NaN) : 0.0;
        }
        return d;
    }
}

