/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.stirlerr;

public class dbinom {
    private dbinom() {
    }

    public static double dbinom(double d, double d2, double d3, int n) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d = d + d2 + d3;
        } else if (d3 < 0.0 || d3 > 1.0 || d2 < 0.0 || Math.abs(d2 - Mathlib.round((double)d2)) > fmax2.fmax2(1.0, Math.abs(d2)) * 1.0E-7) {
            d = Double.NaN;
        } else if (Math.abs(d - Mathlib.round((double)d)) > fmax2.fmax2(1.0, Math.abs(d)) * 1.0E-7) {
            Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{d});
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d < 0.0 || Builtins.__finite((double)d) == 0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else {
            d2 = Mathlib.round((double)d2);
            d = dbinom.dbinom_raw(Mathlib.round((double)d), d2, d3, 1.0 - d3, n);
        }
        return d;
    }

    public static double dbinom_raw(double d, double d2, double d3, double d4, int n) {
        if (d3 == 0.0) {
            d = d == 0.0 ? (n != 0 ? 0.0 : 1.0) : (n != 0 ? Double.NEGATIVE_INFINITY : 0.0);
        } else if (d4 == 0.0) {
            d = d == d2 ? (n != 0 ? 0.0 : 1.0) : (n != 0 ? Double.NEGATIVE_INFINITY : 0.0);
        } else if (d == 0.0) {
            if (d2 == 0.0) {
                d = n != 0 ? 0.0 : 1.0;
            } else {
                d = d3 < 0.1 ? -bd0.Rf_bd0(d2, d2 * d4) - d2 * d3 : Math.log(d4) * d2;
                if (n == 0) {
                    d = Math.exp(d);
                }
            }
        } else if (d == d2) {
            d = d4 < 0.1 ? -bd0.Rf_bd0(d2, d2 * d3) - d2 * d4 : Math.log(d3) * d2;
            if (n == 0) {
                d = Math.exp(d);
            }
        } else if (d < 0.0 || d > d2) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else {
            d3 = stirlerr.Rf_stirlerr(d2) - stirlerr.Rf_stirlerr(d) - stirlerr.Rf_stirlerr(d2 - d) - bd0.Rf_bd0(d, d2 * d3) - bd0.Rf_bd0(d2 - d, d2 * d4);
            d = Math.log(d) + 1.8378770664093456 + Mathlib.log1p((double)(-d / d2));
            d = n != 0 ? d3 - d * 0.5 : Math.exp(d3 - d * 0.5);
        }
        return d;
    }
}

