/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.dpois;

public class dgamma {
    private dgamma() {
    }

    public static double dgamma(double d, double d2, double d3, int n) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d = d + d2 + d3;
        } else if (d2 < 0.0 || d3 <= 0.0) {
            d = Double.NaN;
        } else if (d < 0.0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d2 == 0.0) {
            d = d != 0.0 ? (n != 0 ? Double.NEGATIVE_INFINITY : 0.0) : Double.POSITIVE_INFINITY;
        } else if (d == 0.0) {
            d = d2 < 1.0 ? Double.POSITIVE_INFINITY : (d2 > 1.0 ? (n != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n != 0 ? -Math.log(d3) : 1.0 / d3));
        } else if (d2 < 1.0) {
            d3 = dpois.dpois_raw(d2, d / d3, n);
            d = n != 0 ? Math.log(d2 / d) + d3 : d3 * d2 / d;
        } else {
            d = dpois.dpois_raw(d2 - 1.0, d / d3, n);
            d = n != 0 ? (d -= Math.log(d3)) : (d /= d3);
        }
        return d;
    }
}

