/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.fmax2;

public class dhyper {
    private dhyper() {
    }

    public static double dhyper(double d, double d2, double d3, double d4, int n) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0 || Builtins.__isnan((double)d4) != 0) {
            d = d + d2 + d3 + d4;
        } else if (d2 < 0.0 || Math.abs(d2 - Mathlib.round((double)d2)) > fmax2.fmax2(1.0, Math.abs(d2)) * 1.0E-7 || d3 < 0.0 || Math.abs(d3 - Mathlib.round((double)d3)) > fmax2.fmax2(1.0, Math.abs(d3)) * 1.0E-7 || d4 < 0.0 || Math.abs(d4 - Mathlib.round((double)d4)) > fmax2.fmax2(1.0, Math.abs(d4)) * 1.0E-7 || d2 + d3 < d4) {
            d = Double.NaN;
        } else if (d < 0.0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (Math.abs(d - Mathlib.round((double)d)) > fmax2.fmax2(1.0, Math.abs(d)) * 1.0E-7) {
            Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{d});
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else {
            d = Mathlib.round((double)d);
            d2 = Mathlib.round((double)d2);
            double d5 = Mathlib.round((double)d3);
            double d6 = Mathlib.round((double)d4);
            if (d6 < d || d2 < d || d6 - d > d5) {
                d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
            } else if (d6 == 0.0) {
                d = d == 0.0 ? (n != 0 ? 0.0 : 1.0) : (n != 0 ? Double.NEGATIVE_INFINITY : 0.0);
            } else {
                double d7 = d6 / (d2 + d5);
                d4 = (d2 + d5 - d6) / (d2 + d5);
                d3 = dbinom.dbinom_raw(d, d2, d7, d4, n);
                d = dbinom.dbinom_raw(d6 - d, d5, d7, d4, n);
                d2 = dbinom.dbinom_raw(d6, d2 + d5, d7, d4, n);
                d = n != 0 ? d3 + d - d2 : d3 * d / d2;
            }
        }
        return d;
    }
}

