/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dgamma;
import org.renjin.nmath.dnbeta;
import org.renjin.nmath.dnchisq;

public class dnf {
    private dnf() {
    }

    public static double dnf(double d, double d2, double d3, double d4, int n) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0 || Builtins.__isnan((double)d4) != 0) {
            d = d + d3 + d2 + d4;
        } else if (d2 <= 0.0 || d3 <= 0.0 || d4 < 0.0) {
            d = Double.NaN;
        } else if (d < 0.0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (Builtins.__finite((double)d4) == 0) {
            d = Double.NaN;
        } else if (Builtins.__finite((double)d2) == 0 && Builtins.__finite((double)d3) == 0) {
            d = d == 1.0 ? Double.POSITIVE_INFINITY : (n != 0 ? Double.NEGATIVE_INFINITY : 0.0);
        } else if (Builtins.__finite((double)d3) == 0) {
            d = dnchisq.dnchisq(d * d2, d2, d4, n) * d2;
        } else if (d2 > 1.0E14 && d4 < 1.0E7) {
            d2 = d4 / d2 + 1.0;
            d3 = dgamma.dgamma(1.0 / d / d2, d3 / 2.0, 2.0 / d3, n);
            d = n != 0 ? d3 - Math.log(d) * 2.0 - Math.log(d2) : d3 / (d * d) / d2;
        } else {
            d = d2 / d3 * d;
            d4 = dnbeta.dnbeta(d / (d + 1.0), d2 / 2.0, d3 / 2.0, d4, n);
            d = n != 0 ? Math.log(d2) + d4 - Math.log(d3) - Mathlib.log1p((double)d) * 2.0 : d2 / d3 * d4 / (d + 1.0) / (d + 1.0);
        }
        return d;
    }
}

