/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.pbeta;
import org.renjin.nmath.pchisq;

public class pf {
    private pf() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double pf(double d, double d2, double d3, int n, int n2) {
        if (Builtins.__isnan((double)d) != 0) return d + d3 + d2;
        if (Builtins.__isnan((double)d2) != 0) return d + d3 + d2;
        if (Builtins.__isnan((double)d3) != 0) return d + d3 + d2;
        if (d2 <= 0.0) return Double.NaN;
        if (d3 <= 0.0) return Double.NaN;
        if (d <= 0.0) {
            if (n != 0) {
                if (n2 != 0) return Double.NEGATIVE_INFINITY;
                return 0.0;
            }
            if (n2 != 0) return 0.0;
            return 1.0;
        }
        if (d >= Double.POSITIVE_INFINITY) {
            if (n != 0) {
                if (n2 != 0) return 0.0;
                return 1.0;
            }
            if (n2 != 0) return Double.NEGATIVE_INFINITY;
            return 0.0;
        }
        if (d3 == Double.POSITIVE_INFINITY) {
            if (d2 != Double.POSITIVE_INFINITY) return pchisq.pchisq(d * d2, d2, n, n2);
            if (d < 1.0) {
                if (n != 0) {
                    if (n2 != 0) return Double.NEGATIVE_INFINITY;
                    return 0.0;
                }
                if (n2 != 0) return 0.0;
                return 1.0;
            }
            if (d == 1.0) {
                if (n2 != 0) return -0.6931471805599453;
                return 0.5;
            }
            if (!(d > 1.0)) return pchisq.pchisq(d * d2, d2, n, n2);
            if (n != 0) {
                if (n2 != 0) return 0.0;
                return 1.0;
            }
            if (n2 != 0) return Double.NEGATIVE_INFINITY;
            return 0.0;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            n = n != 0 ? 0 : 1;
            return pchisq.pchisq(d3 / d, d3, n, n2);
        }
        if (d2 * d > d3) {
            n = n != 0 ? 0 : 1;
            d = pbeta.pbeta(d3 / (d2 * d + d3), d3 / 2.0, d2 / 2.0, n, n2);
        } else {
            d = pbeta.pbeta(d2 * d / (d2 * d + d3), d2 / 2.0, d3 / 2.0, n, n2);
        }
        if (Builtins.__isnan((double)d) == 0) return d;
        return Double.NaN;
    }
}

