/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.nmath.imin2;

public class signrank {
    public static int allocated_n = 0;
    public static Ptr w = BytePtr.of((int)0);

    private signrank() {
    }

    public static double csignrank(int n, int n2) {
        double d;
        int n3 = (n2 + 1) * n2 / 2;
        int n4 = n3 / 2;
        if (n < 0 || n > n3) {
            d = 0.0;
        } else {
            if (n > n4) {
                n = n3 - n;
            }
            if (n2 == 1) {
                d = 1.0;
            } else if (w.getDouble() == 1.0) {
                d = w.getDouble(0 + n * 8);
            } else {
                Ptr ptr = w;
                ptr.setDouble(8, 1.0);
                w.setDouble(0, ptr.getDouble(8));
                n3 = 2;
                while (n2 + 1 > n3) {
                    int n5 = imin2.imin2((n3 + 1) * n3 / 2, n4);
                    while (n5 >= n3) {
                        w.setDouble(0 + n5 * 8, w.getDouble(0 + n5 * 8) + w.getDouble(0 + (n5 - n3) * 8));
                        --n5;
                    }
                    ++n3;
                }
                d = w.getDouble(0 + n * 8);
            }
        }
        return d;
    }

    public static double dsignrank(double d, double d2, int n) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d += d2;
        } else {
            d2 = Mathlib.round((double)d2);
            if (d2 <= 0.0) {
                d = Double.NaN;
            } else if (Math.abs(d - Mathlib.round((double)d)) > 1.0E-7) {
                d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
            } else if ((d = Mathlib.round((double)d)) < 0.0 || (d2 + 1.0) * d2 / 2.0 < d) {
                d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
            } else {
                int n2 = (int)d2;
                signrank.w_init_maybe(n2);
                d = n != 0 ? Math.log(signrank.csignrank((int)d, n2)) - d2 * 0.6931471805599453 : Math.exp(Math.log(signrank.csignrank((int)d, n2)) - d2 * 0.6931471805599453);
            }
        }
        return d;
    }

    public static double psignrank(double d, double d2, int n, int n2) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d += d2;
        } else if (Builtins.__finite((double)d2) == 0) {
            d = Double.NaN;
        } else {
            d2 = Mathlib.round((double)d2);
            if (d2 <= 0.0) {
                d = Double.NaN;
            } else {
                double d3 = Mathlib.round((double)(d + 1.0E-7));
                if (d3 < 0.0) {
                    d = n != 0 ? (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n2 != 0 ? 0.0 : 1.0);
                } else if ((d2 + 1.0) * d2 / 2.0 <= d3) {
                    d = n != 0 ? (n2 != 0 ? 0.0 : 1.0) : (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0);
                } else {
                    int n3 = (int)d2;
                    signrank.w_init_maybe(n3);
                    d = Math.exp(-d2 * 0.6931471805599453);
                    double d4 = 0.0;
                    if ((d2 + 1.0) * d2 / 4.0 >= d3) {
                        int n4 = 0;
                        while ((double)n4 <= d3) {
                            d4 = signrank.csignrank(n4, n3) * d + d4;
                            ++n4;
                        }
                    } else {
                        d2 = (d2 + 1.0) * d2 / 2.0 - d3;
                        int n5 = 0;
                        while ((double)n5 < d2) {
                            d4 = signrank.csignrank(n5, n3) * d + d4;
                            ++n5;
                        }
                        n = n != 0 ? 0 : 1;
                    }
                    d = n != 0 ? (n2 != 0 ? Math.log(d4) : d4) : (n2 != 0 ? Mathlib.log1p((double)(-d4)) : 0.5 - d4 + 0.5);
                }
            }
        }
        return d;
    }

    public static double qsignrank(double d, double d2, int n, int n2) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0) {
            d += d2;
        } else if (Builtins.__finite((double)d) == 0 || Builtins.__finite((double)d2) == 0) {
            d = Double.NaN;
        } else if (n2 != 0 && d > 0.0 || n2 == 0 && (d < 0.0 || d > 1.0)) {
            d = Double.NaN;
        } else if ((d2 = Mathlib.round((double)d2)) <= 0.0) {
            d = Double.NaN;
        } else {
            double d3 = n != 0 ? (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n2 != 0 ? 0.0 : 1.0);
            if (d3 == d) {
                d = 0.0;
            } else {
                d3 = n != 0 ? (n2 != 0 ? 0.0 : 1.0) : (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0);
                if (d3 == d) {
                    d = (d2 + 1.0) * d2 / 2.0;
                } else {
                    if (n2 != 0 || n == 0) {
                        if (n2 != 0) {
                            d = n != 0 ? Math.exp(d) : -Mathlib.expm1((double)d);
                        } else if (n == 0) {
                            d = 0.5 - d + 0.5;
                        }
                    }
                    n = (int)d2;
                    signrank.w_init_maybe(n);
                    d3 = Math.exp(-d2 * 0.6931471805599453);
                    double d4 = 0.0;
                    n2 = 0;
                    if (d <= 0.5) {
                        d -= 2.220446049250313E-15;
                        while (!((d4 = signrank.csignrank(n2, n) * d3 + d4) >= d)) {
                            ++n2;
                        }
                    } else {
                        d = 1.0 - d + 2.220446049250313E-15;
                        while (true) {
                            if ((d4 = signrank.csignrank(n2, n) * d3 + d4) > d) {
                                n2 = (int)((d2 + 1.0) * d2 / 2.0 - (double)n2);
                                break;
                            }
                            ++n2;
                        }
                    }
                    d = n2;
                }
            }
        }
        return d;
    }

    public static double rsignrank(MethodHandle methodHandle, double d) {
        if (Builtins.__isnan((double)d) != 0) {
        } else {
            d = Mathlib.round((double)d);
            if (d < 0.0) {
                d = Double.NaN;
            } else if (d == 0.0) {
                d = 0.0;
            } else {
                double d2 = 0.0;
                int n = (int)d;
                int n2 = 0;
                while (n2 < n) {
                    d2 = (double)(++n2) * Mathlib.floor((double)(methodHandle.invoke() + 0.5)) + d2;
                }
                d = d2;
            }
        }
        return d;
    }

    public static void signrank_free() {
        signrank.w_free();
    }

    public static void w_free() {
        if (!w.isNull()) {
            Ptr ptr = w;
            w = BytePtr.of((int)0);
            allocated_n = 0;
        }
    }

    public static void w_init_maybe(int n) {
        block5: {
            int n2;
            block4: {
                n2 = (n + 1) * n / 2 / 2;
                if (w.isNull()) break block4;
                if (n == allocated_n) break block5;
                signrank.w_free();
            }
            if (w.isNull()) {
                w = DoublePtr.malloc((int)((n2 + 1) * 8));
                allocated_n = n;
            }
        }
    }
}

