/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dbeta;
import org.renjin.nmath.dpois;

public class dnbeta {
    public static double eps$4333 = 1.0E-15;
    public static double $dnbeta$eps = 1.0E-15;

    private dnbeta() {
    }

    public static double dnbeta(double d, double d2, double d3, double d4, int n) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0 || Builtins.__isnan((double)d4) != 0) {
            d = d + d2 + d3 + d4;
        } else if (d4 < 0.0 || d2 <= 0.0 || d3 <= 0.0) {
            d = Double.NaN;
        } else if (Builtins.__finite((double)d2) == 0 || Builtins.__finite((double)d3) == 0 || Builtins.__finite((double)d4) == 0) {
            d = Double.NaN;
        } else if (d < 0.0 || d > 1.0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d4 == 0.0) {
            d = dbeta.dbeta(d, d2, d3, n);
        } else {
            int n2;
            double d5 = d4 * 0.5;
            d4 = d5 * d;
            double d6 = (d4 - d2 - 1.0) / 2.0;
            double d7 = d6 * d6 + (d2 + d3) * d4 - d2;
            if (d7 <= 0.0) {
                n2 = 0;
            } else {
                d6 = Mathlib.ceil((double)(Mathlib.sqrt((double)d7) + d6));
                n2 = d6 > 0.0 ? (int)d6 : 0;
            }
            d6 = dbeta.dbeta(d, (double)n2 + d2, d3, 1);
            d5 = dpois.dpois_raw(n2, d5, 1);
            if (d == 0.0 || Builtins.__finite((double)d6) == 0 || Builtins.__finite((double)d5) == 0) {
                d = n != 0 ? d5 + d6 : Math.exp(d5 + d6);
            } else {
                double d8;
                d = d5 + d6;
                d6 = 1.0;
                d5 = 1.0;
                d7 = n2;
                while (d7 > 0.0 && d5 * $dnbeta$eps < d6) {
                    d5 += (d6 *= ((d7 -= 1.0) + 1.0) * (d7 + d2) / (d7 + d2 + d3) / d4);
                }
                d6 = 1.0;
                d7 = n2;
                do {
                    d8 = (d7 + d2 + d3) * d4 / (d7 + d2) / (d7 + 1.0);
                    d7 += 1.0;
                } while ((d5 += (d6 *= d8)) * $dnbeta$eps < d6);
                d = n != 0 ? Math.log(d5) + d : Math.exp(Math.log(d5) + d);
            }
        }
        return d;
    }
}

