/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;

public class dweibull {
    private dweibull() {
    }

    public static double dweibull(double d, double d2, double d3, int n) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d = d + d2 + d3;
        } else if (d2 <= 0.0 || d3 <= 0.0) {
            d = Double.NaN;
        } else if (d < 0.0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (Builtins.__finite((double)d) == 0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d == 0.0 && d2 < 1.0) {
            d = Double.POSITIVE_INFINITY;
        } else {
            double d4 = Mathlib.pow((double)(d / d3), (double)(d2 - 1.0));
            d = d / d3 * d4;
            d = n != 0 ? Math.log(d2 * d4 / d3) - d : d2 * d4 * Math.exp(-d) / d3;
        }
        return d;
    }
}

