/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.chebyshev;
import org.renjin.nmath.cospi;
import org.renjin.nmath.lgammacor;
import org.renjin.nmath.stirlerr;

public class gamma {
    public static double[] gamcs$4329 = new double[42];
    public static double[] $gammafn$gamcs = new double[42];

    static {
        gamma.gamcs$4329$$clinit();
        double[] dArray = new double[]{0.00857119559098933, 0.004415381324841007, 0.05685043681599363, -0.00421983539641856, 0.0013268081812124603, -1.8930245297988805E-4, 3.606925327441245E-5, -6.056761904460864E-6, 1.0558295463022833E-6, -1.811967365542384E-7, 3.117724964715322E-8, -5.354219639019687E-9, 9.193275519859589E-10, -1.5779412802883398E-10, 2.7079806229349544E-11, -4.64681865382573E-12, 7.97335019200742E-13, -1.368078209830916E-13, 2.3473194865638007E-14, -4.027432614949067E-15, 6.910051747372101E-16, -1.185584500221993E-16, 2.034148542496374E-17, -3.490054341717406E-18, 5.987993856485306E-19, -1.027378057872228E-19, 1.7627028160605298E-20, -3.024320653735306E-21, 5.188914660218398E-22, -8.902770842456576E-23, 1.5274740684933426E-23, -2.620731256187363E-24, 4.496464047830539E-25, -7.714712731336878E-26, 1.323635453126044E-26, -2.2709994129429287E-27, 3.8964189980039913E-28, -6.685198115125953E-29, 1.1469986631400244E-29, -1.9679385863451348E-30, 3.376448816585338E-31, -5.793070335782136E-32};
        System.arraycopy(dArray, 0, $gammafn$gamcs, 0, 42);
    }

    private gamma() {
    }

    static void gamcs$4329$$clinit() {
        double[] dArray = new double[]{0.00857119559098933, 0.004415381324841007, 0.05685043681599363, -0.00421983539641856, 0.0013268081812124603, -1.8930245297988805E-4, 3.606925327441245E-5, -6.056761904460864E-6, 1.0558295463022833E-6, -1.811967365542384E-7, 3.117724964715322E-8, -5.354219639019687E-9, 9.193275519859589E-10, -1.5779412802883398E-10, 2.7079806229349544E-11, -4.64681865382573E-12, 7.97335019200742E-13, -1.368078209830916E-13, 2.3473194865638007E-14, -4.027432614949067E-15, 6.910051747372101E-16, -1.185584500221993E-16, 2.034148542496374E-17, -3.490054341717406E-18, 5.987993856485306E-19, -1.027378057872228E-19, 1.7627028160605298E-20, -3.024320653735306E-21, 5.188914660218398E-22, -8.902770842456576E-23, 1.5274740684933426E-23, -2.620731256187363E-24, 4.496464047830539E-25, -7.714712731336878E-26, 1.323635453126044E-26, -2.2709994129429287E-27, 3.8964189980039913E-28, -6.685198115125953E-29, 1.1469986631400244E-29, -1.9679385863451348E-30, 3.376448816585338E-31, -5.793070335782136E-32};
        System.arraycopy(dArray, 0, gamcs$4329, 0, 42);
    }

    public static double gammafn(double d) {
        if (Builtins.__isnan((double)d) != 0) {
        } else if (d == 0.0 || d < 0.0 && Mathlib.round((double)d) == d) {
            d = Double.NaN;
        } else {
            double d2 = Math.abs(d);
            if (d2 <= 10.0) {
                int n = (int)d;
                if (d < 0.0) {
                    --n;
                }
                d2 = d - (double)n;
                double d3 = chebyshev.Rf_chebyshev_eval(d2 * 2.0 - 1.0, (Ptr)new DoublePtr($gammafn$gamcs, 0), 22) + 0.9375;
                if (--n == 0) {
                    d = d3;
                } else if (n < 0) {
                    if (d < -0.5 && Math.abs(d - (double)((int)(d - 0.5)) / d) < 1.4901161193847656E-8) {
                        new BytePtr("\u0000".getBytes(), 0);
                        Stdlib.printf((BytePtr)((BytePtr)new BytePtr("full precision may not have been achieved in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("gammafn\u0000".getBytes(), 0)});
                    }
                    if (d2 < 2.2474362225598545E-308) {
                        new BytePtr("\u0000".getBytes(), 0);
                        Stdlib.printf((BytePtr)((BytePtr)new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("gammafn\u0000".getBytes(), 0)});
                        d = d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                    } else {
                        n = -n;
                        int n2 = 0;
                        while (n2 < n) {
                            d3 /= (double)n2 + d;
                            ++n2;
                        }
                        d = d3;
                    }
                } else {
                    int n3 = 1;
                    while (n3 <= n) {
                        d3 = ((double)n3 + d2) * d3;
                        ++n3;
                    }
                    d = d3;
                }
            } else if (d > 171.61447887182297) {
                new BytePtr("\u0000".getBytes(), 0);
                Stdlib.printf((BytePtr)((BytePtr)new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("gammafn\u0000".getBytes(), 0)});
                d = Double.POSITIVE_INFINITY;
            } else if (d < -170.5674972726612) {
                new BytePtr("\u0000".getBytes(), 0);
                Stdlib.printf((BytePtr)((BytePtr)new BytePtr("underflow occurred in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("gammafn\u0000".getBytes(), 0)});
                d = 0.0;
            } else {
                double d4;
                if (d2 <= 50.0 && (double)((int)d2) == d2) {
                    d4 = 1.0;
                    int n = 2;
                    while ((double)n < d2) {
                        d4 = (double)n * d4;
                        ++n;
                    }
                } else {
                    d4 = (d2 - 0.5) * Math.log(d2) - d2 + 0.9189385332046728;
                    double d5 = d2 * 2.0 == d2 * 2.0 ? stirlerr.Rf_stirlerr(d2) : lgammacor.Rf_lgammacor(d2);
                    d4 = Math.exp(d4 + d5);
                }
                if (d > 0.0) {
                    d = d4;
                } else {
                    if (Math.abs((d - (double)((int)(d - 0.5))) / d) < 1.4901161193847656E-8) {
                        new BytePtr("\u0000".getBytes(), 0);
                        Stdlib.printf((BytePtr)((BytePtr)new BytePtr("full precision may not have been achieved in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("gammafn\u0000".getBytes(), 0)});
                    }
                    d = cospi.sinpi(d2);
                    if (d == 0.0) {
                        new BytePtr("\u0000".getBytes(), 0);
                        Stdlib.printf((BytePtr)((BytePtr)new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("gammafn\u0000".getBytes(), 0)});
                        d = Double.POSITIVE_INFINITY;
                    } else {
                        d = -Math.PI / (d2 * d * d4);
                    }
                }
            }
        }
        return d;
    }
}

