/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.cospi;
import org.renjin.nmath.gamma;
import org.renjin.nmath.lgammacor;

public class lgamma {
    private lgamma() {
    }

    public static double lgammafn(double d) {
        return lgamma.lgammafn_sign(d, BytePtr.of((int)0));
    }

    public static double lgammafn_sign(double d, Ptr ptr) {
        if (!ptr.isNull()) {
            ptr.setInt(1);
        }
        if (Builtins.__isnan((double)d) != 0) {
        } else {
            if (!ptr.isNull() && d < 0.0 && Mathlib.fmod((double)Mathlib.floor((double)(-d)), (double)2.0) == 0.0) {
                ptr.setInt(-1);
            }
            if (d <= 0.0 && Mathlib.trunc((double)d) == d) {
                new BytePtr("\u0000".getBytes(), 0);
                Stdlib.printf((BytePtr)((BytePtr)new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                d = Double.POSITIVE_INFINITY;
            } else {
                double d2 = Math.abs(d);
                if (d2 < 1.0E-306) {
                    d = -Math.log(d2);
                } else if (d2 <= 10.0) {
                    d = Math.log(Math.abs(gamma.gammafn(d)));
                } else if (d2 > 2.5327372760800758E305) {
                    new BytePtr("\u0000".getBytes(), 0);
                    Stdlib.printf((BytePtr)((BytePtr)new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                    d = Double.POSITIVE_INFINITY;
                } else if (d > 0.0) {
                    d = d > 1.0E17 ? (Math.log(d) - 1.0) * d : (d > 4934720.0 ? (d - 0.5) * Math.log(d) + 0.9189385332046728 - d : (d - 0.5) * Math.log(d) + 0.9189385332046728 - d + lgammacor.Rf_lgammacor(d));
                } else {
                    double d3 = Math.abs(cospi.sinpi(d2));
                    if (d3 == 0.0) {
                        Stdlib.printf((BytePtr)new BytePtr(" ** should NEVER happen! *** [lgamma.c: Neg.int, y=%g]\n\u0000".getBytes(), 0), (Object[])new Object[]{d2});
                        d = Double.NaN;
                    } else {
                        d3 = (d - 0.5) * Math.log(d2) + 0.22579135264472744 - d - Math.log(d3) - lgammacor.Rf_lgammacor(d2);
                        if (Math.abs((d - Mathlib.trunc((double)(d - 0.5))) * d3 / d) < 1.4901161193847656E-8) {
                            new BytePtr("\u0000".getBytes(), 0);
                            Stdlib.printf((BytePtr)((BytePtr)new BytePtr("full precision may not have been achieved in '%s'\n\u0000".getBytes(), 0).pointerPlus(0)), (Object[])new Object[]{new BytePtr("lgamma\u0000".getBytes(), 0)});
                        }
                        d = d3;
                    }
                }
            }
        }
        return d;
    }
}

