/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.pbeta;

public class pbinom {
    private pbinom() {
    }

    public static double pbinom(double d, double d2, double d3, int n, int n2) {
        if (Builtins.__isnan((double)d) != 0 || Builtins.__isnan((double)d2) != 0 || Builtins.__isnan((double)d3) != 0) {
            d = d + d2 + d3;
        } else if (Builtins.__finite((double)d2) == 0 || Builtins.__finite((double)d3) == 0) {
            d = Double.NaN;
        } else if (Math.abs(d2 - Mathlib.round((double)d2)) > fmax2.fmax2(1.0, Math.abs(d2)) * 1.0E-7) {
            Stdlib.printf((BytePtr)new BytePtr("non-integer n = %f\u0000".getBytes(), 0), (Object[])new Object[]{d2});
            d = Double.NaN;
        } else {
            d2 = Mathlib.round((double)d2);
            if (d2 < 0.0 || d3 < 0.0 || d3 > 1.0) {
                d = Double.NaN;
            } else if (d < 0.0) {
                d = n != 0 ? (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n2 != 0 ? 0.0 : 1.0);
            } else if (d2 <= (d = Mathlib.floor((double)(d + 1.0E-7)))) {
                d = n != 0 ? (n2 != 0 ? 0.0 : 1.0) : (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0);
            } else {
                n = n != 0 ? 0 : 1;
                d = pbeta.pbeta(d3, d + 1.0, d2 - d, n, n2);
            }
        }
        return d;
    }
}

