/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;

public class qlogis {
    private qlogis() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qlogis(double d, double d2, double d3, int n, int n2) {
        if (Builtins.__isnan((double)d) != 0) return d + d2 + d3;
        if (Builtins.__isnan((double)d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan((double)d3) != 0) return d + d2 + d3;
        if (n2 != 0) {
            if (d > 0.0) return Double.NaN;
            if (d == 0.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return Double.NEGATIVE_INFINITY;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                if (n != 0) return Double.NEGATIVE_INFINITY;
                return Double.POSITIVE_INFINITY;
            }
        } else {
            if (d < 0.0) return Double.NaN;
            if (d > 1.0) return Double.NaN;
            if (d == 0.0) {
                if (n != 0) return Double.NEGATIVE_INFINITY;
                return Double.POSITIVE_INFINITY;
            }
            if (d == 1.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (d3 < 0.0) return Double.NaN;
        if (d3 == 0.0) return d2;
        if (n2 != 0) {
            if (n != 0) {
                double d4 = d > -0.6931471805599453 ? Math.log(-Mathlib.expm1((double)d)) : Mathlib.log1p((double)(-Math.exp(d)));
                d -= d4;
                return d3 * d + d2;
            } else {
                double d5 = d > -0.6931471805599453 ? Math.log(-Mathlib.expm1((double)d)) : Mathlib.log1p((double)(-Math.exp(d)));
                d = d5 - d;
            }
            return d3 * d + d2;
        } else {
            d = n != 0 ? (d /= 1.0 - d) : (1.0 - d) / d;
            d = Math.log(d);
        }
        return d3 * d + d2;
    }
}

