/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;

public class qweibull {
    private qweibull() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qweibull(double d, double d2, double d3, int n, int n2) {
        if (Builtins.__isnan((double)d) != 0) return d + d2 + d3;
        if (Builtins.__isnan((double)d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan((double)d3) != 0) return d + d2 + d3;
        if (d2 <= 0.0) return Double.NaN;
        if (d3 <= 0.0) return Double.NaN;
        if (n2 != 0) {
            if (d > 0.0) return Double.NaN;
            if (d == 0.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        } else {
            if (d < 0.0) return Double.NaN;
            if (d > 1.0) return Double.NaN;
            if (d == 0.0) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == 1.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        }
        d2 = 1.0 / d2;
        d = n != 0 ? (n2 != 0 ? (d > -0.6931471805599453 ? -Math.log(-Mathlib.expm1((double)d)) : -Mathlib.log1p((double)(-Math.exp(d)))) : -Mathlib.log1p((double)(-d))) : (n2 == 0 ? -Math.log(d) : -d);
        return Mathlib.pow((double)d, (double)d2) * d3;
    }
}

