/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bessel_j;
import org.renjin.nmath.cospi;

public class bessel_y {
    public static double pim5$4390;
    public static double fivpi$4389;
    public static double[] ch$4391;
    public static double[] $Y_bessel$ch;
    public static double $Y_bessel$pim5;
    public static double $Y_bessel$fivpi;

    private bessel_y() {
    }

    public static void Y_bessel(Ptr x, Ptr alpha, Ptr nb, Ptr by, Ptr ncalc) {
        double x2 = 0.0;
        double dmu = 0.0;
        double den = 0.0;
        double twobyx = 0.0;
        double ya1 = 0.0;
        double ya = 0.0;
        double ex = 0.0;
        double nu = 0.0;
        double q0 = 0.0;
        double s = 0.0;
        double r = 0.0;
        double e = 0.0;
        double d = 0.0;
        double c = 0.0;
        double b = 0.0;
        double sinmu = 0.0;
        double cosmu = 0.0;
        double ddiv = 0.0;
        int na = 0;
        int k = 0;
        double en1 = ya = (ya1 = 0.0);
        ex = x.getDouble();
        nu = alpha.getDouble();
        if (nb.getInt() > 0 && nu >= 0.0 && nu < 1.0) {
            if (ex < Double.MIN_NORMAL || ex > 1.0E8) {
                int n = nb.getInt();
                ncalc.setInt(n);
                if (ex > 1.0E8) {
                    by.setDouble(0.0);
                } else if (ex < Double.MIN_NORMAL) {
                    double d2 = -1.0 / 0.0;
                    by.setDouble(d2);
                }
                int i = 0;
                while (nb.getInt() > i) {
                    int n2 = i * 8;
                    Ptr ptr = by;
                    int n3 = n2;
                    double d3 = by.getDouble();
                    ptr.setDouble(n3, d3);
                    ++i;
                }
            } else {
                double h;
                double q;
                double g;
                double aye;
                int i;
                double en;
                double f;
                double p;
                double xna = Mathlib.trunc((double)(nu + 0.5));
                na = (int)xna;
                if (na == 1) {
                    nu -= xna;
                }
                if (nu == -0.5) {
                    double d4 = Mathlib.sqrt((double)ex);
                    p = 0.7978845608028654 / d4;
                    ya = Mathlib.sin((double)ex) * p;
                    double d5 = -p;
                    double d6 = Mathlib.cos((double)ex);
                    ya1 = d5 * d6;
                } else if (ex < 3.0) {
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    b = ex * 0.5;
                    d = -Mathlib.log((double)b);
                    f = nu * d;
                    double d11 = -nu;
                    e = Mathlib.pow((double)b, (double)d11);
                    if (Math.abs(nu) < 2.149E-8) {
                        c = 0.3183098861837907;
                    } else {
                        double d12 = cospi.sinpi(nu);
                        c = nu / d12;
                    }
                    if (Math.abs(f) < 1.0) {
                        double d13 = f;
                        x2 = d13 * d13;
                        en = 19.0;
                        s = 1.0;
                        i = 1;
                        while (i <= 9) {
                            double d14 = s * x2 / en;
                            double d15 = en - 1.0;
                            s = d14 / d15 + 1.0;
                            en -= 2.0;
                            ++i;
                        }
                    } else {
                        double d16 = 1.0 / e;
                        s = (e - d16) * 0.5 / f;
                    }
                    double d17 = nu;
                    x2 = d17 * d17 * 8.0;
                    aye = $Y_bessel$ch[0];
                    double even = 0.0;
                    double alfa = $Y_bessel$ch[1];
                    double odd = 0.0;
                    i = 3;
                    while (i <= 19) {
                        even = -(aye * 2.0 + even);
                        double d18 = -even * x2 - aye;
                        int n = i + -1;
                        double d19 = $Y_bessel$ch[n];
                        aye = d18 + d19;
                        odd = -(alfa * 2.0 + odd);
                        double d20 = -odd * x2 - alfa;
                        double d21 = $Y_bessel$ch[i];
                        alfa = d20 + d21;
                        i += 2;
                    }
                    double d22 = (even * 0.5 + aye) * x2 - aye;
                    double d23 = $Y_bessel$ch[20];
                    even = d22 + d23;
                    odd = (odd + alfa) * 2.0;
                    double gamma2 = odd * nu + even;
                    g = e * gamma2;
                    e = (1.0 / e + e) * 0.5;
                    double d24 = c * 2.0;
                    double d25 = odd * e;
                    double d26 = even * s * d;
                    double d27 = d25 + d26;
                    f = d24 * d27;
                    double d28 = nu;
                    e = d28 * d28;
                    p = g * c;
                    q = 0.3183098861837907 / g;
                    c = nu * 1.5707963267948966;
                    r = Math.abs(c) < 2.149E-8 ? 1.0 : cospi.sinpi(nu / 2.0) / c;
                    r = c * Math.PI * r * r;
                    c = 1.0;
                    d = -b * b;
                    h = 0.0;
                    ya = r * q + f;
                    ya1 = p;
                    en = 1.0;
                    while ((d10 = Math.abs(g / (d9 = Math.abs(ya) + 1.0))) + (d8 = Math.abs(h / (d7 = Math.abs(ya1) + 1.0))) > 2.220446049250313E-16) {
                        double d29 = f * en + p + q;
                        double d30 = en;
                        double d31 = d30 * d30 - e;
                        f = d29 / d31;
                        c = d / en * c;
                        double d32 = en - nu;
                        double d33 = en + nu;
                        g = (r * (q /= d33) + f) * c;
                        double d34 = c * (p /= d32);
                        double d35 = en * g;
                        h = d34 - d35;
                        ya += g;
                        ya1 += h;
                        en += 1.0;
                    }
                    ya = -ya;
                    ya1 = -ya1 / b;
                } else if (ex < 16.0) {
                    double d36 = 0.5 - nu;
                    double d37 = nu + 0.5;
                    c = d36 * d37;
                    b = ex * 2.0;
                    double d38 = ex * 0.3183098861837907;
                    double d39 = cospi.cospi(nu);
                    double d40 = e = d38 * d39 / 2.220446049250313E-16;
                    e = d40 * d40;
                    p = 1.0;
                    q = -ex;
                    double d41 = ex;
                    s = r = d41 * d41 + 1.0;
                    en = 2.0;
                    while (r * en * en < e) {
                        en1 = en + 1.0;
                        double d42 = en - 1.0;
                        double d43 = c / en;
                        d = (d42 + d43) / s;
                        double d44 = en * 2.0;
                        double d45 = p * d;
                        p = (d44 - d45) / en1;
                        q = (q * d - b) / en1;
                        double d46 = p;
                        double d47 = d46 * d46;
                        double d48 = q;
                        double d49 = d48 * d48;
                        s = d47 + d49;
                        r *= s;
                        en = en1;
                    }
                    p = f = p / s;
                    q = g = -q / s;
                    while ((en -= 1.0) > 0.0) {
                        r = (2.0 - p) * en1 - 2.0;
                        s = en1 * q + b;
                        double d50 = en - 1.0;
                        double d51 = c / en;
                        double d52 = d50 + d51;
                        double d53 = r;
                        double d54 = d53 * d53;
                        double d55 = s;
                        double d56 = d55 * d55;
                        double d57 = d54 + d56;
                        d = d52 / d57;
                        p = d * r;
                        q = d * s;
                        e = f + 1.0;
                        double d58 = p * e;
                        double d59 = g * q;
                        f = d58 - d59;
                        double d60 = q * e;
                        double d61 = p * g;
                        g = d60 + d61;
                        en1 = en;
                    }
                    double d62 = f += 1.0;
                    double d63 = d62 * d62;
                    double d64 = g;
                    double d65 = d64 * d64;
                    d = d63 + d65;
                    double pa = f / d;
                    double qa = -g / d;
                    d = nu + 0.5 - p;
                    double d66 = pa * (q += ex);
                    double d67 = qa * d;
                    double pa1 = (d66 - d67) / ex;
                    double d68 = qa * q;
                    double d69 = pa * d;
                    double qa1 = (d68 + d69) / ex;
                    double d70 = (nu + 0.5) * 1.5707963267948966;
                    b = ex - d70;
                    c = Mathlib.cos((double)b);
                    s = Mathlib.sin((double)b);
                    double d71 = Mathlib.sqrt((double)ex);
                    d = 0.7978845608028654 / d71;
                    double d72 = pa * s;
                    double d73 = qa * c;
                    ya = (d72 + d73) * d;
                    double d74 = qa1 * s;
                    double d75 = pa1 * c;
                    ya1 = (d74 - d75) * d;
                } else {
                    na = 0;
                    double fivpi$1 = $Y_bessel$fivpi;
                    double d1 = Mathlib.trunc((double)(ex / fivpi$1));
                    i = (int)d1;
                    double d76 = d1 * 15.0;
                    double d77 = ex - d76;
                    double pim5$2 = $Y_bessel$pim5;
                    double d78 = d1 * pim5$2;
                    double d79 = d77 - d78;
                    double d80 = (alpha.getDouble() + 0.5) * 1.5707963267948966;
                    dmu = d79 - d80;
                    if (i / 2 << 1 == i) {
                        cosmu = Mathlib.cos((double)dmu);
                        sinmu = Mathlib.sin((double)dmu);
                    } else {
                        cosmu = -Mathlib.cos((double)dmu);
                        sinmu = -Mathlib.sin((double)dmu);
                    }
                    ddiv = ex * 8.0;
                    dmu = alpha.getDouble();
                    den = Mathlib.sqrt((double)ex);
                    k = 1;
                    while (k <= 2) {
                        p = cosmu;
                        cosmu = sinmu;
                        sinmu = -p;
                        double d81 = dmu * 2.0 - 1.0;
                        double d82 = dmu * 2.0 + 1.0;
                        d1 = d81 * d82;
                        double d2 = 0.0;
                        double div = ddiv;
                        p = 0.0;
                        q = 0.0;
                        double term = q0 = d1 / div;
                        i = 2;
                        while (i <= 20) {
                            term = -term * (d1 -= (d2 += 8.0)) / (div += ddiv);
                            p += term;
                            term = (d1 -= (d2 += 8.0)) / (div += ddiv) * term;
                            q += term;
                            if (Math.abs(term) <= 2.220446049250313E-16) break;
                            ++i;
                        }
                        p += 1.0;
                        q += q0;
                        if (k == 1) {
                            double d83 = p * cosmu;
                            double d84 = q * sinmu;
                            ya = (d83 - d84) * 0.7978845608028654 / den;
                        } else {
                            double d85 = p * cosmu;
                            double d86 = q * sinmu;
                            ya1 = (d85 - d86) * 0.7978845608028654 / den;
                        }
                        dmu += 1.0;
                        ++k;
                    }
                }
                if (na == 1) {
                    double d87;
                    double d88;
                    h = (nu + 1.0) * 2.0 / ex;
                    if (h > 1.0 && (d88 = Math.abs(ya1)) > (d87 = Double.MAX_VALUE / h)) {
                        h = 0.0;
                        ya = 0.0;
                    }
                    h = h * ya1 - ya;
                    ya = ya1;
                    ya1 = h;
                }
                by.setDouble(ya);
                ncalc.setInt(1);
                if (nb.getInt() > 1) {
                    by.setDouble(8, ya1);
                    if (ya1 != 0.0) {
                        aye = alpha.getDouble() + 1.0;
                        twobyx = 2.0 / ex;
                        ncalc.setInt(2);
                        i = 2;
                        while (nb.getInt() > i) {
                            double d89;
                            int n;
                            int n4;
                            Ptr ptr;
                            double d90;
                            double d91;
                            int n5;
                            int n6;
                            Ptr ptr2;
                            double d92;
                            if (!(twobyx < 1.0 ? !((d92 = Math.abs((ptr2 = by).getDouble(n6 = (n5 = (i + -1) * 8))) * twobyx) >= (d91 = Double.MAX_VALUE / aye)) : !((d90 = Math.abs((ptr = by).getDouble(n4 = (n = (i + -1) * 8)))) >= (d89 = Double.MAX_VALUE / aye / twobyx)))) break;
                            int n7 = i * 8;
                            Ptr ptr3 = by;
                            int n8 = n7;
                            double d93 = twobyx * aye;
                            int n9 = (i + -1) * 8;
                            Ptr ptr4 = by;
                            int n10 = n9;
                            double d94 = ptr4.getDouble(n10);
                            double d95 = d93 * d94;
                            int n11 = (i + -2) * 8;
                            Ptr ptr5 = by;
                            int n12 = n11;
                            double d96 = ptr5.getDouble(n12);
                            double d97 = d95 - d96;
                            ptr3.setDouble(n8, d97);
                            aye += 1.0;
                            int n13 = ncalc.getInt() + 1;
                            ncalc.setInt(n13);
                            ++i;
                        }
                    }
                }
                i = ncalc.getInt();
                while (nb.getInt() > i) {
                    int n = i * 8;
                    Ptr ptr = by;
                    int n14 = n;
                    double d98 = -1.0 / 0.0;
                    ptr.setDouble(n14, d98);
                    ++i;
                }
            }
        } else {
            by.setDouble(0.0);
            int n = Math.min(nb.getInt(), 0) + -1;
            ncalc.setInt(n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double bessel_y_ex(double x, double alpha, Ptr by) {
        double x$47;
        double alpha$33;
        int nb$30;
        int[] nb;
        int[] ncalc;
        double[] alpha2;
        double[] x2;
        block14: {
            block13: {
                x2 = new double[]{x};
                alpha2 = new double[]{alpha};
                ncalc = new int[1];
                nb = new int[1];
                ncalc[0] = 0;
                double x$9 = x2[0];
                double x$10 = x2[0];
                if (Double.isNaN(x$9) || Double.isNaN(x$10)) break block13;
                double alpha$11 = alpha2[0];
                double alpha$12 = alpha2[0];
                if (!Double.isNaN(alpha$11) && !Double.isNaN(alpha$12)) break block14;
            }
            double x$13 = x2[0];
            double alpha$14 = alpha2[0];
            return x$13 + alpha$14;
        }
        if (x2[0] < 0.0) {
            BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
            int msg$offset = 0;
            msg = new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0);
            msg$offset = 0;
            Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("bessel_y\u0000".getBytes(), 0)});
            return 0.0 / 0.0;
        }
        double na = Mathlib.floor((double)alpha2[0]);
        if (alpha2[0] < 0.0) {
            double iftmp$23;
            double iftmp$18;
            if (alpha2[0] - na != 0.5) {
                double d = -alpha2[0];
                double d2 = bessel_y.bessel_y_ex(x2[0], d, by);
                double d3 = cospi.cospi(alpha2[0]);
                iftmp$18 = d2 * d3;
            } else {
                iftmp$18 = 0.0;
            }
            if (alpha2[0] != na) {
                double d = -alpha2[0];
                double d4 = bessel_j.bessel_j_ex(x2[0], d, by);
                double d5 = cospi.sinpi(alpha2[0]);
                iftmp$23 = d4 * d5;
                return iftmp$18 - iftmp$23;
            } else {
                iftmp$23 = 0.0;
            }
            return iftmp$18 - iftmp$23;
        }
        if (alpha2[0] > 1.0E7) {
            double alpha$29 = alpha2[0];
            Stdlib.printf((BytePtr)new BytePtr("besselY(x, nu): nu=%g too large for bessel_y() algorithm\u0000".getBytes(), 0), (Object[])new Object[]{alpha$29});
            return 0.0 / 0.0;
        }
        nb[0] = nb$30 = (int)na + 1;
        double alpha$31 = alpha2[0];
        double d = nb[0] + -1;
        alpha2[0] = alpha$33 = alpha$31 - d;
        bessel_y.Y_bessel((Ptr)new DoublePtr(x2, 0), (Ptr)new DoublePtr(alpha2, 0), (Ptr)new IntPtr(nb, 0), by, (Ptr)new IntPtr(ncalc, 0));
        int ncalc$34 = ncalc[0];
        int nb$35 = nb[0];
        if (ncalc$34 != nb$35) {
            if (ncalc[0] == -1) return 1.0 / 0.0;
            if (ncalc[0] < -1) {
                double alpha$38 = alpha2[0];
                int nb$39 = nb[0];
                int ncalc$40 = ncalc[0];
                double x$41 = x2[0];
                Stdlib.printf((BytePtr)new BytePtr("bessel_y(%g): ncalc (=%d) != nb (=%d); alpha=%g. Arg. out of range?\n\u0000".getBytes(), 0), (Object[])new Object[]{x$41, ncalc$40, nb$39, alpha$38});
            } else {
                double d6 = nb[0];
                double alpha$43 = alpha2[0];
                double d7 = d6 + alpha$43 - 1.0;
                double x$44 = x2[0];
                Stdlib.printf((BytePtr)new BytePtr("bessel_y(%g,nu=%g): precision lost in result\n\u0000".getBytes(), 0), (Object[])new Object[]{x$44, d7});
            }
        }
        int n = (nb[0] + -1) * 8;
        Ptr ptr = by;
        int n2 = n;
        x2[0] = x$47 = ptr.getDouble(n2);
        return x2[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double bessel_y(double x, double alpha) {
        double x$88;
        double alpha$72;
        int nb$69;
        int[] nb;
        int[] ncalc;
        double[] alpha2;
        double[] x2;
        block14: {
            block13: {
                x2 = new double[]{x};
                alpha2 = new double[]{alpha};
                ncalc = new int[1];
                nb = new int[1];
                ncalc[0] = 0;
                double x$48 = x2[0];
                double x$49 = x2[0];
                if (Double.isNaN(x$48) || Double.isNaN(x$49)) break block13;
                double alpha$50 = alpha2[0];
                double alpha$51 = alpha2[0];
                if (!Double.isNaN(alpha$50) && !Double.isNaN(alpha$51)) break block14;
            }
            double x$52 = x2[0];
            double alpha$53 = alpha2[0];
            return x$52 + alpha$53;
        }
        if (x2[0] < 0.0) {
            BytePtr msg = new BytePtr("\u0000".getBytes(), 0);
            int msg$offset = 0;
            msg = new BytePtr("value out of range in '%s'\n\u0000".getBytes(), 0);
            msg$offset = 0;
            Stdlib.printf((BytePtr)((BytePtr)msg.pointerPlus(msg$offset)), (Object[])new Object[]{new BytePtr("bessel_y\u0000".getBytes(), 0)});
            return 0.0 / 0.0;
        }
        double na = Mathlib.floor((double)alpha2[0]);
        if (alpha2[0] < 0.0) {
            double iftmp$62;
            double iftmp$57;
            if (alpha2[0] - na != 0.5) {
                double d = -alpha2[0];
                double d2 = bessel_y.bessel_y(x2[0], d);
                double d3 = cospi.cospi(alpha2[0]);
                iftmp$57 = d2 * d3;
            } else {
                iftmp$57 = 0.0;
            }
            if (alpha2[0] != na) {
                double d = -alpha2[0];
                double d4 = bessel_j.bessel_j(x2[0], d);
                double d5 = cospi.sinpi(alpha2[0]);
                iftmp$62 = d4 * d5;
                return iftmp$57 - iftmp$62;
            } else {
                iftmp$62 = 0.0;
            }
            return iftmp$57 - iftmp$62;
        }
        if (alpha2[0] > 1.0E7) {
            double alpha$68 = alpha2[0];
            Stdlib.printf((BytePtr)new BytePtr("besselY(x, nu): nu=%g too large for bessel_y() algorithm\u0000".getBytes(), 0), (Object[])new Object[]{alpha$68});
            return 0.0 / 0.0;
        }
        nb[0] = nb$69 = (int)na + 1;
        double alpha$70 = alpha2[0];
        double d = nb[0] + -1;
        alpha2[0] = alpha$72 = alpha$70 - d;
        DoublePtr by = DoublePtr.malloc((int)(nb[0] * 8));
        bessel_y.Y_bessel((Ptr)new DoublePtr(x2, 0), (Ptr)new DoublePtr(alpha2, 0), (Ptr)new IntPtr(nb, 0), (Ptr)by, (Ptr)new IntPtr(ncalc, 0));
        int ncalc$75 = ncalc[0];
        int nb$76 = nb[0];
        if (ncalc$75 != nb$76) {
            if (ncalc[0] == -1) return 1.0 / 0.0;
            if (ncalc[0] < -1) {
                double alpha$79 = alpha2[0];
                int nb$80 = nb[0];
                int ncalc$81 = ncalc[0];
                double x$82 = x2[0];
                Stdlib.printf((BytePtr)new BytePtr("bessel_y(%g): ncalc (=%d) != nb (=%d); alpha=%g. Arg. out of range?\n\u0000".getBytes(), 0), (Object[])new Object[]{x$82, ncalc$81, nb$80, alpha$79});
            } else {
                double d6 = nb[0];
                double alpha$84 = alpha2[0];
                double d7 = d6 + alpha$84 - 1.0;
                double x$85 = x2[0];
                Stdlib.printf((BytePtr)new BytePtr("bessel_y(%g,nu=%g): precision lost in result\n\u0000".getBytes(), 0), (Object[])new Object[]{x$85, d7});
            }
        }
        int n = (nb[0] + -1) * 8;
        DoublePtr doublePtr = by;
        int n2 = 0 + n;
        x2[0] = x$88 = doublePtr.getDouble(n2);
        return x2[0];
    }

    static {
        ch$4391 = new double[21];
        $Y_bessel$ch = new double[21];
        pim5$4390 = 0.7079632679489662;
        fivpi$4389 = Math.PI * 5;
        bessel_y.ch$4391$$clinit();
        System.arraycopy(new double[]{-6.773524182239884E-24, -6.145518011604988E-23, 2.9017595056104746E-21, 1.36394179190731E-19, 2.3826220476859634E-18, -9.064290795755071E-18, -1.4943667065169001E-15, -3.391907830536221E-14, -1.702377664251273E-13, 9.160975093876865E-12, 2.42309579004827E-10, 1.7451364971382985E-9, -3.3126119768180853E-8, -8.659207996139126E-7, -4.9717367041957395E-6, 7.630959758590813E-5, 0.0012719271366545622, 0.0017063050710955563, -0.07685284084478668, -0.28387654227602355, 0.9218702936504527}, 0, $Y_bessel$ch, 0, 21);
        $Y_bessel$pim5 = 0.7079632679489662;
        $Y_bessel$fivpi = Math.PI * 5;
    }

    static void ch$4391$$clinit() {
        System.arraycopy(new double[]{-6.773524182239884E-24, -6.145518011604988E-23, 2.9017595056104746E-21, 1.36394179190731E-19, 2.3826220476859634E-18, -9.064290795755071E-18, -1.4943667065169001E-15, -3.391907830536221E-14, -1.702377664251273E-13, 9.160975093876865E-12, 2.42309579004827E-10, 1.7451364971382985E-9, -3.3126119768180853E-8, -8.659207996139126E-7, -4.9717367041957395E-6, 7.630959758590813E-5, 0.0012719271366545622, 0.0017063050710955563, -0.07685284084478668, -0.28387654227602355, 0.9218702936504527}, 0, ch$4391, 0, 21);
    }
}

