/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Ptr;

public class chebyshev {
    private chebyshev() {
    }

    public static double Rf_chebyshev_eval(double x, Ptr a, int n) {
        double d;
        double twox = 0.0;
        if (n <= 0 || n > 1000) {
            d = 0.0 / 0.0;
        } else if (x < -1.1 || x > 1.1) {
            d = 0.0 / 0.0;
        } else {
            double b1;
            twox = x * 2.0;
            double b2 = b1 = 0.0;
            double b0 = 0.0;
            int i = 1;
            while (i <= n) {
                b2 = b1;
                b1 = b0;
                double d2 = twox * b1 - b2;
                int n2 = (n - i) * 8;
                Ptr ptr = a;
                int n3 = n2;
                double d3 = ptr.getDouble(n3);
                b0 = d2 + d3;
                ++i;
            }
            d = (b0 - b2) * 0.5;
        }
        return d;
    }

    public static int Rf_chebyshev_init(Ptr dos, int nos, double eta) {
        int n;
        block4: {
            if (nos <= 0) {
                n = 0;
            } else {
                double err = 0.0;
                int i = 0;
                int ii = 1;
                while (ii <= nos) {
                    Ptr ptr = dos;
                    i = nos - ii;
                    int n2 = i * 8;
                    int n3 = n2;
                    err = Math.abs(ptr.getDouble(n3)) + err;
                    if (err > eta) {
                        n = i;
                        break block4;
                    }
                    ++ii;
                }
                n = i;
            }
        }
        return n;
    }
}

