/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lbeta;
import org.renjin.nmath.lgamma;

public class choose {
    private choose() {
    }

    public static double choose(double n, double k) {
        double d;
        int[] s_choose = new int[]{0};
        double k0 = k;
        k = Mathlib.round((double)k);
        if (Double.isNaN(n) || Double.isNaN(n) || Double.isNaN(k) || Double.isNaN(k)) {
            d = n + k;
        } else {
            if (Math.abs(k - k0) > 1.0E-7) {
                Stdlib.printf((BytePtr)new BytePtr("'k' (%.2f) must be integer, rounded to %.0f\u0000".getBytes(), 0), (Object[])new Object[]{k0, k});
            }
            if (k < 30.0) {
                double d2;
                double d3;
                double d4;
                double d5;
                if (n - k < k && n >= 0.0 && (d5 = Math.abs(n - (d4 = Mathlib.round((double)n)))) > (d3 = fmax2.fmax2(1.0, d2 = Math.abs(n)) * 1.0E-7) ^ true) {
                    k = n - k;
                }
                if (k < 0.0) {
                    d = 0.0;
                } else if (k == 0.0) {
                    d = 1.0;
                } else {
                    double d6;
                    double d7;
                    double r = n;
                    int j = 2;
                    while ((double)j <= k) {
                        double d8 = j;
                        double d9 = n - d8 + 1.0;
                        double d10 = j;
                        r = d9 / d10 * r;
                        ++j;
                    }
                    double d11 = Mathlib.round((double)n);
                    double d12 = Math.abs(n - d11);
                    double iftmp$0 = d12 > (d7 = fmax2.fmax2(1.0, d6 = Math.abs(n)) * 1.0E-7) ^ true ? Mathlib.round((double)r) : r;
                    d = iftmp$0;
                }
            } else if (n < 0.0) {
                double r = choose.choose(k - n - 1.0, k);
                if (Mathlib.floor((double)(k / 2.0)) * 2.0 != k) {
                    r = -r;
                }
                d = r;
            } else {
                double d13 = Mathlib.round((double)n);
                double d14 = Math.abs(n - d13);
                double d15 = Math.abs(n);
                double d16 = fmax2.fmax2(1.0, d15) * 1.0E-7;
                if (d14 > d16 ^ true) {
                    if ((n = Mathlib.round((double)n)) < k) {
                        d = 0.0;
                    } else if (n - k < 30.0) {
                        double d17 = n - k;
                        d = choose.choose(n, d17);
                    } else {
                        d = Mathlib.round((double)Mathlib.exp((double)choose.Rf_lfastchoose(n, k)));
                    }
                } else if (k - 1.0 > n) {
                    double r = choose.lfastchoose2(n, k, (Ptr)new IntPtr(s_choose, 0));
                    double d18 = s_choose[0];
                    double d19 = Mathlib.exp((double)r);
                    d = d18 * d19;
                } else {
                    d = Mathlib.exp((double)choose.Rf_lfastchoose(n, k));
                }
            }
        }
        return d;
    }

    public static double lchoose(double n, double k) {
        double d;
        int[] s = new int[]{0};
        double k0 = k;
        k = Mathlib.round((double)k);
        if (Double.isNaN(n) || Double.isNaN(n) || Double.isNaN(k) || Double.isNaN(k)) {
            d = n + k;
        } else {
            if (Math.abs(k - k0) > 1.0E-7) {
                Stdlib.printf((BytePtr)new BytePtr("'k' (%.2f) must be integer, rounded to %.0f\u0000".getBytes(), 0), (Object[])new Object[]{k0, k});
            }
            if (k < 2.0) {
                d = k < 0.0 ? -1.0 / 0.0 : (k == 0.0 ? 0.0 : Mathlib.log((double)Math.abs(n)));
            } else if (n < 0.0) {
                d = choose.lchoose(k - n - 1.0, k);
            } else {
                double d2 = Mathlib.round((double)n);
                double d3 = Math.abs(n - d2);
                double d4 = Math.abs(n);
                double d5 = fmax2.fmax2(1.0, d4) * 1.0E-7;
                if (d3 > d5 ^ true) {
                    if ((n = Mathlib.round((double)n)) < k) {
                        d = -1.0 / 0.0;
                    } else if (n - k < 2.0) {
                        double d6 = n - k;
                        d = choose.lchoose(n, d6);
                    } else {
                        d = choose.Rf_lfastchoose(n, k);
                    }
                } else {
                    d = k - 1.0 > n ? choose.lfastchoose2(n, k, (Ptr)new IntPtr(s, 0)) : choose.Rf_lfastchoose(n, k);
                }
            }
        }
        return d;
    }

    public static double lfastchoose2(double n, double k, Ptr s_choose) {
        double r = lgamma.lgammafn_sign(n - k + 1.0, s_choose);
        double d = lgamma.lgammafn(n + 1.0);
        double d2 = lgamma.lgammafn(k + 1.0);
        return d - d2 - r;
    }

    public static double Rf_lfastchoose(double n, double k) {
        double d = -Mathlib.log((double)(n + 1.0));
        double d2 = k + 1.0;
        double d3 = lbeta.lbeta(n - k + 1.0, d2);
        return d - d3;
    }
}

