/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;

public class cospi {
    private cospi() {
    }

    public static double tanpi(double x) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else {
            double iftmp$0;
            x = Mathlib.fmod((double)x, (double)1.0);
            if (x <= -0.5) {
                x += 1.0;
            } else if (x > 0.5) {
                x -= 1.0;
            }
            if (x != 0.0) {
                double iftmp$1 = x != 0.5 ? Mathlib.tan((double)(x * Math.PI)) : 0.0 / 0.0;
                iftmp$0 = iftmp$1;
            } else {
                iftmp$0 = 0.0;
            }
            d = iftmp$0;
        }
        return d;
    }

    public static double sinpi(double x) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else {
            x = Mathlib.fmod((double)x, (double)2.0);
            if (x <= -1.0) {
                x += 2.0;
            } else if (x > 1.0) {
                x -= 2.0;
            }
            d = x == 0.0 || x == 1.0 ? 0.0 : (x == 0.5 ? 1.0 : (x == -0.5 ? -1.0 : Mathlib.sin((double)(x * Math.PI))));
        }
        return d;
    }

    public static double cospi(double x) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x)) {
            d = x;
        } else if (!(Math.abs(x) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else {
            x = Mathlib.fmod((double)Math.abs(x), (double)2.0);
            d = Mathlib.fmod((double)x, (double)1.0) == 0.5 ? 0.0 : (x == 1.0 ? -1.0 : (x == 0.0 ? 1.0 : Mathlib.cos((double)(x * Math.PI))));
        }
        return d;
    }
}

