/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.lbeta;

public class dbeta {
    private dbeta() {
    }

    public static double dbeta(double x, double a, double b, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(b)) {
            d = x + a + b;
        } else if (a < 0.0 || b < 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0 || x > 1.0) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (a == 0.0 || b == 0.0 || !(Math.abs(a) <= Double.MAX_VALUE) || !(Math.abs(b) <= Double.MAX_VALUE)) {
            if (a == 0.0 && b == 0.0) {
                if (x == 0.0 || x == 1.0) {
                    d = 1.0 / 0.0;
                } else {
                    double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    d = iftmp$1;
                }
            } else if (a == 0.0 || a / b == 0.0) {
                if (x == 0.0) {
                    d = 1.0 / 0.0;
                } else {
                    double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    d = iftmp$2;
                }
            } else if (b == 0.0 || b / a == 0.0) {
                if (x == 1.0) {
                    d = 1.0 / 0.0;
                } else {
                    double iftmp$3 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    d = iftmp$3;
                }
            } else if (x == 0.5) {
                d = 1.0 / 0.0;
            } else {
                double iftmp$4 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$4;
            }
        } else if (x == 0.0) {
            if (a > 1.0) {
                double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$5;
            } else if (a < 1.0) {
                d = 1.0 / 0.0;
            } else {
                double iftmp$6 = log_p != 0 ? Mathlib.log((double)b) : b;
                d = iftmp$6;
            }
        } else if (x == 1.0) {
            if (b > 1.0) {
                double iftmp$7 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$7;
            } else if (b < 1.0) {
                d = 1.0 / 0.0;
            } else {
                double iftmp$8 = log_p != 0 ? Mathlib.log((double)a) : a;
                d = iftmp$8;
            }
        } else {
            double lval;
            if (a <= 2.0 || b <= 2.0) {
                double d2 = a - 1.0;
                double d3 = Mathlib.log((double)x);
                double d4 = d2 * d3;
                double d5 = b - 1.0;
                double d6 = Mathlib.log1p((double)(-x));
                double d7 = d5 * d6;
                double d8 = d4 + d7;
                double d9 = lbeta.lbeta(a, b);
                lval = d8 - d9;
            } else {
                double d10 = Mathlib.log((double)(a + b - 1.0));
                double d11 = 1.0 - x;
                double d12 = a + b - 2.0;
                double d13 = dbinom.dbinom_raw(a - 1.0, d12, x, d11, 1);
                lval = d10 + d13;
            }
            double iftmp$9 = log_p == 0 ? Mathlib.exp((double)lval) : lval;
            d = iftmp$9;
        }
        return d;
    }
}

