/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bd0;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.stirlerr;

public class dbinom {
    private dbinom() {
    }

    public static double dbinom(double x, double n, double p, int log_p) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(n) || Double.isNaN(p) || Double.isNaN(p)) {
            d5 = x + n + p;
        } else if (p < 0.0 || p > 1.0 || n < 0.0 || (d4 = Math.abs(n - (d3 = Mathlib.round((double)n)))) > (d2 = fmax2.fmax2(1.0, d = Math.abs(n)) * 1.0E-7)) {
            d5 = 0.0 / 0.0;
        } else {
            double d6 = Mathlib.round((double)x);
            double d7 = Math.abs(x - d6);
            double d8 = Math.abs(x);
            double d9 = fmax2.fmax2(1.0, d8) * 1.0E-7;
            if (d7 > d9) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{x});
                double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d5 = iftmp$0;
            } else if (x < 0.0 || !(Math.abs(x) <= Double.MAX_VALUE)) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d5 = iftmp$1;
            } else {
                n = Mathlib.round((double)n);
                x = Mathlib.round((double)x);
                double d10 = 1.0 - p;
                d5 = dbinom.dbinom_raw(x, n, p, d10, log_p);
            }
        }
        return d5;
    }

    public static double dbinom_raw(double x, double n, double p, double q, int log_p) {
        double d;
        if (p == 0.0) {
            double iftmp$2;
            if (x == 0.0) {
                double iftmp$3 = log_p != 0 ? 0.0 : 1.0;
                iftmp$2 = iftmp$3;
            } else {
                double iftmp$4 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$2 = iftmp$4;
            }
            d = iftmp$2;
        } else if (q == 0.0) {
            double iftmp$5;
            if (x == n) {
                double iftmp$6 = log_p != 0 ? 0.0 : 1.0;
                iftmp$5 = iftmp$6;
            } else {
                double iftmp$7 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$5 = iftmp$7;
            }
            d = iftmp$5;
        } else if (x == 0.0) {
            if (n == 0.0) {
                double iftmp$8 = log_p != 0 ? 0.0 : 1.0;
                d = iftmp$8;
            } else {
                double iftmp$9;
                if (p < 0.1) {
                    double d2 = n * q;
                    double d3 = -bd0.Rf_bd0(n, d2);
                    double d4 = n * p;
                    iftmp$9 = d3 - d4;
                } else {
                    iftmp$9 = Mathlib.log((double)q) * n;
                }
                double lc = iftmp$9;
                double iftmp$10 = log_p == 0 ? Mathlib.exp((double)lc) : lc;
                d = iftmp$10;
            }
        } else if (x == n) {
            double iftmp$11;
            if (q < 0.1) {
                double d5 = n * p;
                double d6 = -bd0.Rf_bd0(n, d5);
                double d7 = n * q;
                iftmp$11 = d6 - d7;
            } else {
                iftmp$11 = Mathlib.log((double)p) * n;
            }
            double lc = iftmp$11;
            double iftmp$12 = log_p == 0 ? Mathlib.exp((double)lc) : lc;
            d = iftmp$12;
        } else if (x < 0.0 || x > n) {
            double iftmp$13 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$13;
        } else {
            double iftmp$14;
            double d8 = stirlerr.Rf_stirlerr(n);
            double d9 = stirlerr.Rf_stirlerr(x);
            double d10 = d8 - d9;
            double d11 = stirlerr.Rf_stirlerr(n - x);
            double d12 = d10 - d11;
            double d13 = n * p;
            double d14 = bd0.Rf_bd0(x, d13);
            double d15 = d12 - d14;
            double d16 = n * q;
            double d17 = bd0.Rf_bd0(n - x, d16);
            double lc = d15 - d17;
            double d18 = Mathlib.log((double)x) + 1.8378770664093456;
            double d19 = Mathlib.log1p((double)(-x / n));
            double lf = d18 + d19;
            if (log_p != 0) {
                double d20 = lf * 0.5;
                iftmp$14 = lc - d20;
            } else {
                double d21 = lf * 0.5;
                iftmp$14 = Mathlib.exp((double)(lc - d21));
            }
            d = iftmp$14;
        }
        return d;
    }
}

