/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.dgamma;

public class df {
    private df() {
    }

    public static double df(double x, double m, double n, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(m) || Double.isNaN(m) || Double.isNaN(n) || Double.isNaN(n)) {
            d = x + m + n;
        } else if (m <= 0.0 || n <= 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (x == 0.0) {
            double iftmp$1;
            if (m > 2.0) {
                double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$1 = iftmp$2;
            } else {
                double iftmp$3;
                if (m == 2.0) {
                    double iftmp$4 = log_p != 0 ? 0.0 : 1.0;
                    iftmp$3 = iftmp$4;
                } else {
                    iftmp$3 = 1.0 / 0.0;
                }
                iftmp$1 = iftmp$3;
            }
            d = iftmp$1;
        } else if (!(Math.abs(m) <= Double.MAX_VALUE) && !(Math.abs(n) <= Double.MAX_VALUE)) {
            if (x == 1.0) {
                d = 1.0 / 0.0;
            } else {
                double iftmp$5 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$5;
            }
        } else if (!(Math.abs(n) <= Double.MAX_VALUE)) {
            double d2 = 2.0 / m;
            double d3 = m / 2.0;
            d = dgamma.dgamma(x, d3, d2, log_p);
        } else if (m > 1.0E14) {
            double iftmp$6;
            double d4 = 2.0 / n;
            double d5 = n / 2.0;
            double dens = dgamma.dgamma(1.0 / x, d5, d4, log_p);
            if (log_p != 0) {
                double d6 = Mathlib.log((double)x) * 2.0;
                iftmp$6 = dens - d6;
            } else {
                double d7 = x;
                double d8 = d7 * d7;
                iftmp$6 = dens / d8;
            }
            d = iftmp$6;
        } else {
            double dens;
            double d9 = x * m + n;
            double f = 1.0 / d9;
            double q = n * f;
            double p = x * m * f;
            if (m >= 2.0) {
                f = m * q / 2.0;
                double d10 = (m + n - 2.0) / 2.0;
                dens = dbinom.dbinom_raw((m - 2.0) / 2.0, d10, p, q, log_p);
            } else {
                double d11 = m;
                double d12 = d11 * d11 * q;
                double d13 = p * 2.0;
                double d14 = m + n;
                double d15 = d13 * d14;
                f = d12 / d15;
                double d16 = (m + n) / 2.0;
                dens = dbinom.dbinom_raw(m / 2.0, d16, p, q, log_p);
            }
            double iftmp$7 = log_p != 0 ? Mathlib.log((double)f) + dens : f * dens;
            d = iftmp$7;
        }
        return d;
    }
}

