/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dpois;

public class dgamma {
    private dgamma() {
    }

    public static double dgamma(double x, double shape, double scale, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(shape) || Double.isNaN(shape) || Double.isNaN(scale) || Double.isNaN(scale)) {
            d = x + shape + scale;
        } else if (shape < 0.0 || scale <= 0.0) {
            d = 0.0 / 0.0;
        } else if (x < 0.0) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (shape == 0.0) {
            double iftmp$1;
            if (x != 0.0) {
                double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$1 = iftmp$2;
            } else {
                iftmp$1 = 1.0 / 0.0;
            }
            d = iftmp$1;
        } else if (x == 0.0) {
            if (shape < 1.0) {
                d = 1.0 / 0.0;
            } else if (shape > 1.0) {
                double iftmp$3 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$3;
            } else {
                double iftmp$4 = log_p != 0 ? -Mathlib.log((double)scale) : 1.0 / scale;
                d = iftmp$4;
            }
        } else if (shape < 1.0) {
            double d2 = x / scale;
            double pr = dpois.dpois_raw(shape, d2, log_p);
            double iftmp$5 = log_p != 0 ? Mathlib.log((double)(shape / x)) + pr : pr * shape / x;
            d = iftmp$5;
        } else {
            double iftmp$6;
            double d3 = x / scale;
            double pr = dpois.dpois_raw(shape - 1.0, d3, log_p);
            if (log_p != 0) {
                double d4 = Mathlib.log((double)scale);
                iftmp$6 = pr - d4;
            } else {
                iftmp$6 = pr / scale;
            }
            d = iftmp$6;
        }
        return d;
    }
}

