/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.fmax2;

public class dgeom {
    private dgeom() {
    }

    public static double dgeom(double x, double p, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(p) || Double.isNaN(p)) {
            d = x + p;
        } else if (p <= 0.0 || p > 1.0) {
            d = 0.0 / 0.0;
        } else {
            double d2 = Mathlib.round((double)x);
            double d3 = Math.abs(x - d2);
            double d4 = Math.abs(x);
            double d5 = fmax2.fmax2(1.0, d4) * 1.0E-7;
            if (d3 > d5) {
                Stdlib.printf((BytePtr)new BytePtr("non-integer x = %f\u0000".getBytes(), 0), (Object[])new Object[]{x});
                double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$0;
            } else if (x < 0.0 || !(Math.abs(x) <= Double.MAX_VALUE) || p == 0.0) {
                double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                d = iftmp$1;
            } else {
                x = Mathlib.round((double)x);
                double d6 = 1.0 - p;
                double prob = dbinom.dbinom_raw(0.0, x, p, d6, log_p);
                double iftmp$2 = log_p != 0 ? Mathlib.log((double)p) + prob : p * prob;
                d = iftmp$2;
            }
        }
        return d;
    }
}

