/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;

public class dlnorm {
    private dlnorm() {
    }

    public static double dlnorm(double x, double meanlog, double sdlog, int log_p) {
        double d;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(meanlog) || Double.isNaN(meanlog) || Double.isNaN(sdlog) || Double.isNaN(sdlog)) {
            d = x + meanlog + sdlog;
        } else if (sdlog <= 0.0) {
            if (sdlog < 0.0) {
                d = 0.0 / 0.0;
            } else {
                double iftmp$0;
                if (Mathlib.log((double)x) != meanlog) {
                    double iftmp$1 = log_p != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$0 = iftmp$1;
                } else {
                    iftmp$0 = 1.0 / 0.0;
                }
                d = iftmp$0;
            }
        } else if (x <= 0.0) {
            double iftmp$2 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$2;
        } else {
            double iftmp$3;
            double y = (Mathlib.log((double)x) - meanlog) / sdlog;
            if (log_p != 0) {
                double d2 = y * 0.5 * y + 0.9189385332046728;
                double d3 = Mathlib.log((double)(x * sdlog));
                iftmp$3 = -(d2 + d3);
            } else {
                double d4 = Mathlib.exp((double)(y * -0.5 * y)) * 0.3989422804014327;
                double d5 = x * sdlog;
                iftmp$3 = d4 / d5;
            }
            d = iftmp$3;
        }
        return d;
    }
}

