/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dbeta;
import org.renjin.nmath.dpois;

public class dnbeta {
    public static double eps$4353 = 1.0E-15;
    public static double $dnbeta$eps = 1.0E-15;

    private dnbeta() {
    }

    public static double dnbeta(double x, double a, double b, double ncp, int log_p) {
        double d;
        double p_k = 0.0;
        double dx2 = 0.0;
        int kMax = 0;
        if (Double.isNaN(x) || Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(b) || Double.isNaN(ncp) || Double.isNaN(ncp)) {
            d = x + a + b + ncp;
        } else if (ncp < 0.0 || a <= 0.0 || b <= 0.0) {
            d = 0.0 / 0.0;
        } else if (!(Math.abs(a) <= Double.MAX_VALUE && Math.abs(b) <= Double.MAX_VALUE && Math.abs(ncp) <= Double.MAX_VALUE)) {
            d = 0.0 / 0.0;
        } else if (x < 0.0 || x > 1.0) {
            double iftmp$0 = log_p != 0 ? -1.0 / 0.0 : 0.0;
            d = iftmp$0;
        } else if (ncp == 0.0) {
            d = dbeta.dbeta(x, a, b, log_p);
        } else {
            double d2;
            double ncp2 = ncp * 0.5;
            dx2 = ncp2 * x;
            double d3 = d2 = (dx2 - a - 1.0) / 2.0;
            double d4 = d3 * d3;
            double d5 = (a + b) * dx2;
            double D = d4 + d5 - a;
            if (D <= 0.0) {
                kMax = 0;
            } else {
                D = Mathlib.ceil((double)(Mathlib.sqrt((double)D) + d2));
                int iftmp$1 = D > 0.0 ? (int)D : 0;
                kMax = iftmp$1;
            }
            double d6 = (double)kMax + a;
            double term = dbeta.dbeta(x, d6, b, 1);
            p_k = dpois.dpois_raw(kMax, ncp2, 1);
            if (x == 0.0 || !(Math.abs(term) <= Double.MAX_VALUE) || !(Math.abs(p_k) <= Double.MAX_VALUE)) {
                double iftmp$2 = log_p != 0 ? p_k + term : Mathlib.exp((double)(p_k + term));
                d = iftmp$2;
            } else {
                double eps$4;
                double q;
                double eps$3;
                p_k += term;
                double sum = term = 1.0;
                double k = kMax;
                while (k > 0.0 && sum * (eps$3 = $dnbeta$eps) < term) {
                    double d7 = (k -= 1.0) + 1.0;
                    double d8 = k + a;
                    double d9 = d7 * d8;
                    double d10 = k + a + b;
                    q = d9 / d10 / dx2;
                    sum += (term *= q);
                }
                term = 1.0;
                k = kMax;
                do {
                    double d11 = (k + a + b) * dx2;
                    double d12 = k + a;
                    double d13 = d11 / d12;
                    double d14 = k + 1.0;
                    q = d13 / d14;
                    k += 1.0;
                } while ((sum += (term *= q)) * (eps$4 = $dnbeta$eps) < term);
                double iftmp$5 = log_p != 0 ? Mathlib.log((double)sum) + p_k : Mathlib.exp((double)(Mathlib.log((double)sum) + p_k));
                d = iftmp$5;
            }
        }
        return d;
    }
}

